/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import org.openinstaller.util.EnhancedException;

public class ProgressReporter {
    private final int gSubtotalPercent;
    private static final int ZERO = 0;
    private static final int HUNDRED = 100;
    private final int gSecsLeft;
    private final int gTotalPercent;
    private final String gSubtotalString;
    private final String gTotalString;

    public String toString() {
        return new StringBuffer("Progress: Sub task (").append(this.gSubtotalString).append(") ").append(this.gSubtotalPercent).append("/").append(100).append(" Main task: (").append(this.gTotalString).append(") ").append(this.gTotalPercent).append("/").append(100).toString();
    }

    public ProgressReporter(int aEstimatedSecsLeft, int aSubtotalPercent, String aSubtotalString, int aTotalPercent, String aTotalString) throws EnhancedException {
        if (!ProgressReporter.isValid(aSubtotalPercent) || !ProgressReporter.isValid(aTotalPercent)) {
            throw new EnhancedException("PROGRESS_OUT_OF_RANGE", new String[]{"subtotal=" + aSubtotalPercent, "total=" + aTotalPercent});
        }
        this.gSubtotalPercent = aSubtotalPercent;
        this.gTotalPercent = aTotalPercent;
        this.gSubtotalString = aSubtotalString;
        this.gTotalString = aTotalString;
        this.gSecsLeft = aEstimatedSecsLeft;
    }

    private static boolean isValid(int aProgress) {
        return 0 <= aProgress && 100 >= aProgress;
    }

    public String getTotalString() {
        return this.gTotalString;
    }

    public String getSubtotalString() {
        return this.gSubtotalString;
    }

    public int getTotalPercent() {
        return this.gTotalPercent;
    }

    public int getSubtotalPercent() {
        return this.gSubtotalPercent;
    }

    public int getEstimatedCompletionTime() {
        return this.gSecsLeft;
    }
}

