/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    public static final int BORDER_THICKNESS = 4;
    private Insets INSETS = new Insets(2, 2, 6, 6);
    private Color[] gBorderColors;

    public final Insets getBorderInsets(Component aComponent) {
        return this.INSETS;
    }

    public ShadowBorder() {
        this.setBorderColor(Color.GRAY);
    }

    public ShadowBorder(Color aColor) {
        this();
        this.setBorderColor(aColor);
    }

    public final void setBorderColor(Color aColor) {
        this.gBorderColors = new Color[5];
        int theRed = aColor.getRed();
        int theGreen = aColor.getGreen();
        int theBlue = aColor.getBlue();
        for (int theIndex = 0; theIndex <= 4; ++theIndex) {
            this.gBorderColors[theIndex] = new Color(theRed, theGreen, theBlue, 100 - theIndex * 20);
        }
    }

    public final void paintBorder(Component aComponent, Graphics aGraphics, int aX, int aY, int aWidth, int aHeight) {
        ((Graphics2D)aGraphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)aGraphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.gBorderColors == null) {
            this.setBorderColor(Color.GRAY);
        }
        Color theOldColor = aGraphics.getColor();
        aGraphics.translate(aX, aY);
        aGraphics.setColor(this.gBorderColors[0]);
        aGraphics.drawRect(0, 0, aWidth - 4 - 1, aHeight - 4 - 1);
        for (int theIndex = 0; theIndex < 4; ++theIndex) {
            aGraphics.setColor(this.gBorderColors[theIndex + 1]);
            aGraphics.drawLine(1 + theIndex, aHeight - 4 + theIndex, aWidth - 4 + theIndex, aHeight - 4 + theIndex);
            aGraphics.drawLine(aWidth - 4 + theIndex, 1 + theIndex, aWidth - 4 + theIndex, aHeight - 4 + theIndex);
        }
        aGraphics.translate(-aX, -aY);
        aGraphics.setColor(theOldColor);
    }
}

