/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.openinstaller.util.JDKSelection.utils.FileUtils;

public class FileEntry {
    private File file = null;
    private String name = null;
    private boolean metaDataReady = false;
    private boolean directory = false;
    private boolean empty = false;
    private long size = 0L;
    private String md5 = null;
    private boolean jar = false;
    private boolean packed = false;
    private boolean signed = false;
    private long modified = 0L;
    private int permissions = 0;

    public FileEntry(File file) {
        this.file = file;
        this.name = file.getAbsolutePath().replace("\\", "/");
        this.metaDataReady = false;
    }

    public FileEntry(File file, boolean empty, long modified, int permissions) {
        this(file);
        this.directory = true;
        this.empty = empty;
        this.modified = modified;
        this.permissions = permissions;
        this.metaDataReady = true;
    }

    public FileEntry(File file, long size, String md5, boolean jar, boolean packed, boolean signed, long modified, int permissions) {
        this(file);
        this.directory = false;
        this.size = size;
        this.md5 = md5;
        this.jar = jar;
        this.packed = packed;
        this.signed = signed;
        this.modified = modified;
        this.permissions = permissions;
        this.metaDataReady = true;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isMetaDataReady() {
        return this.metaDataReady;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getSize() {
        return this.size;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean isJarFile() {
        return this.jar;
    }

    public boolean isPackedJarFile() {
        return this.packed;
    }

    public boolean isSignedJarFile() {
        return this.signed;
    }

    public long getLastModified() {
        return this.modified;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void calculateMetaData() throws IOException {
        if (this.file.exists()) {
            this.directory = this.file.isDirectory();
            if (!this.directory) {
                this.size = this.file.length();
                this.md5 = FileUtils.getMd5(this.file);
                this.jar = FileUtils.isJarFile(this.file);
                if (this.jar) {
                    this.packed = false;
                    this.signed = FileUtils.isSigned(this.file);
                }
            } else {
                this.empty = FileUtils.isEmpty(this.file);
            }
        } else {
            throw new FileNotFoundException(this.file.getAbsolutePath());
        }
        this.modified = this.file.lastModified();
        this.metaDataReady = true;
    }
}

