/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.CircularGraphKeyValue;
import org.openinstaller.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyGraph {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final char DEPTH = '.';
    private static final char SIBLING = '/';
    private static final int INCREMENT = 1;
    private static final boolean CIRCULAR_IS_CRITICAL = true;
    private Map<String, List<String>> gHMapIdToTrails;
    private Map<String, String> gHMapTrailToId;
    private Map<String, Set<String>> gHMapParentToChild;
    private Map<String, List<String>> gHMapIdToTracks;
    private Map<String, String> gHMapHeavyTrailToIdSummary;
    private Map<String, List<String>> gHMapHeavyWeightToHeavyTrailSummary;
    private int gIntMaximumMaximorumWeight = 0;
    private boolean gBDependenciesOk = false;
    private String gStrKnot = "";
    private String gStrMissing = "";
    private List<String> gListTemporary;
    private Set<String> gHSetAllTrails = null;
    protected Map<String, List<String>> gHMapDirectDependencies = new HashMap<String, List<String>>();
    protected Map<String, List<String>> gHMapDirectDependenciesBackup = new HashMap<String, List<String>>();
    private boolean gTrailHasNoLoopSoFar;
    private static List<CircularGraphKeyValue> gListOfCircularDeps = new ArrayList<CircularGraphKeyValue>();

    protected final void setmHSetAllTrails(List<String> aHeadsOfTrails) {
        this.gHSetAllTrails = new HashSet<String>();
        for (String aHeadsOfTrail : aHeadsOfTrails) {
            this.gHSetAllTrails.add(aHeadsOfTrail);
        }
    }

    protected final Set getHSetAllTrails() {
        return this.gHSetAllTrails;
    }

    protected final boolean loadGraph() {
        if (this.gHSetAllTrails == null) {
            LOGGER.log(Level.SEVERE, "GRAPH_IS_EMPTY");
        } else {
            LOGGER.log(Level.FINE, "Examining dependencies ...");
            this.initializeMaps();
            int theIndex = 0;
            Iterator<String> theIterator = this.gHSetAllTrails.iterator();
            while (theIterator.hasNext()) {
                this.blazeTrail(theIterator.next(), theIndex);
                ++theIndex;
            }
            this.summarizeMap(this.gHMapIdToTrails);
            LOGGER.log(Level.FINE, "Checking done.");
            if (this.getDependenciesSafe()) {
                if (this.getVerbose()) {
                    LOGGER.log(Level.FINE, "Dependencies look ok, ");
                    LOGGER.log(Level.FINE, "  no circular declaration were detected.");
                    LOGGER.log(Level.FINE, "  all dependency declarations were accounted for.");
                }
            } else {
                LOGGER.log(Level.FINE, "Correct the dependency graph and try again.");
            }
        }
        return this.getDependenciesSafe();
    }

    private void blazeTrail(String aTrailStart, int aIndex) {
        if (this.isLegitimateGroup(aTrailStart) || this.isLegitimateComponent(aTrailStart)) {
            LOGGER.log(Level.FINE, "Identifier " + aIndex + " : " + aTrailStart);
            this.insertEntry(aTrailStart, String.valueOf(aIndex));
            this.gTrailHasNoLoopSoFar = true;
            this.followTrail(aTrailStart);
        } else {
            this.setDependenciesSafe(false);
            LOGGER.log(Level.SEVERE, "INVALID_IDENTIFIER", aTrailStart);
        }
    }

    protected final void displayAliasesTable() {
        Iterator<String> theOverallIter = this.gHMapIdToTrails.keySet().iterator();
        LOGGER.log(Level.FINE, "");
        LOGGER.log(Level.FINE, "-= Internal identifiers Table =-");
        while (theOverallIter.hasNext()) {
            String theKey = theOverallIter.next();
            LOGGER.log(Level.FINE, theKey + " : ");
            List<String> theValues = this.gHMapIdToTrails.get(theKey);
            for (int theIndex = 0; theIndex < theValues.size(); ++theIndex) {
                LOGGER.log(Level.FINE, theValues.get(theIndex));
                if (theIndex >= theValues.size() - 1) continue;
                LOGGER.log(Level.FINE, ", ");
            }
            LOGGER.log(Level.FINE, "");
        }
        LOGGER.log(Level.FINE, "");
    }

    private List getTrails(String aEntry) {
        return this.gHMapIdToTrails.get(aEntry);
    }

    private boolean isKnownTrail(String aEntry) {
        return this.gHMapIdToTrails.containsKey(aEntry);
    }

    protected final List<String> extractSequence() {
        ArrayList<String> theSequence = new ArrayList<String>();
        for (int theIndex = this.gIntMaximumMaximorumWeight; theIndex > 0; --theIndex) {
            List<String> theBuffer = this.gHMapHeavyWeightToHeavyTrailSummary.get(String.valueOf(theIndex));
            if (theBuffer == null) continue;
            for (String theID : theBuffer) {
                theSequence.add(this.gHMapHeavyTrailToIdSummary.get(theID));
            }
        }
        return theSequence;
    }

    public abstract boolean sequenceStatus(List<String> var1);

    private boolean followTrail(String aParentEntry) {
        boolean theRequestIsValid = this.isLegitimateComponent(aParentEntry);
        if (theRequestIsValid) {
            int theChildrenOffset = 0;
            List<String> theParentTrails = this.gHMapIdToTrails.get(aParentEntry);
            List<String> theParentDependencies = this.getDependencies(aParentEntry);
            for (String theChildEntry : theParentDependencies) {
                boolean bl = theRequestIsValid = this.isLegitimateGroup(theChildEntry) || this.isLegitimateComponent(theChildEntry);
                if (theRequestIsValid) {
                    if (!this.isLegitimateGroup(theChildEntry)) {
                        String theParentId = theParentTrails.get(theParentTrails.size() - 1);
                        String theChildId = this.getChildAlias(theParentId, theChildrenOffset);
                        boolean theCircularIsOk = this.testCircularOk(theChildEntry, theChildId);
                        if (theCircularIsOk) {
                            this.insertEntry(theChildEntry, theChildId);
                            if (this.getDependenciesSafe()) {
                                if (this.getVerbose()) {
                                    LOGGER.log(Level.FINE, "dependencies ok thus far ... (" + theChildEntry + ")");
                                    LOGGER.log(Level.FINE, "exploring one level deeper.");
                                }
                                this.followTrail(theChildEntry);
                            }
                            ++theChildrenOffset;
                        } else if (this.gTrailHasNoLoopSoFar) {
                            this.collectCirculars(aParentEntry, theChildEntry);
                            this.gTrailHasNoLoopSoFar = false;
                        }
                        this.setDependenciesSafe((theCircularIsOk || !theCircularIsOk) && this.getDependenciesSafe());
                    }
                } else {
                    this.setDependenciesSafe(false);
                    this.setMissingName(theChildEntry);
                    LOGGER.log(Level.SEVERE, "MISSING_DEPENDENCY", new String[]{aParentEntry, theChildEntry});
                }
                this.setDependenciesSafe(theRequestIsValid && this.getDependenciesSafe());
            }
        }
        this.setDependenciesSafe(theRequestIsValid && this.getDependenciesSafe());
        return this.getDependenciesSafe();
    }

    private boolean testCircularOk(String aEntry, String aAlias) {
        boolean theIdentifierOk = true;
        if (this.isKnownTrail(aEntry)) {
            String theNewAlias = aAlias + ".";
            this.setKnotName("");
            Iterator theIterator = this.getTrails(aEntry).iterator();
            while (theIterator.hasNext() && theIdentifierOk) {
                if (!theNewAlias.startsWith(theIterator.next() + ".")) continue;
                theIdentifierOk = false;
                this.setKnotName(aEntry);
                LOGGER.log(Level.SEVERE, "CIRCULAR_DEPENDENCY", aEntry);
            }
        }
        return theIdentifierOk;
    }

    private void removeCirculars() {
        CircularGraphKeyValue theCircularDependency = gListOfCircularDeps.get(0);
        List<String> theDependencies = this.gHMapDirectDependencies.get(theCircularDependency.getDependencyNodeName());
        if (theDependencies != null) {
            this.setKnotName(theCircularDependency.getCircularNodeName());
            theDependencies.remove(theCircularDependency.getCircularNodeName());
            this.gHMapDirectDependencies.put(theCircularDependency.getDependencyNodeName(), theDependencies);
        }
    }

    protected final void collectCirculars(String aParentEntry, String aChildEntry) {
        gListOfCircularDeps.add(new CircularGraphKeyValue(aParentEntry, aChildEntry));
    }

    protected final void resolveCircularDependencies() {
        for (String theDirectDependencyName : this.gHMapDirectDependencies.keySet()) {
            ArrayList<String> theMapEntry = new ArrayList<String>();
            theMapEntry.add(theDirectDependencyName);
            boolean theFlagToKeepTracking = true;
            while (theFlagToKeepTracking) {
                this.setSelection(theMapEntry);
                this.loadGraph();
                boolean bl = theFlagToKeepTracking = gListOfCircularDeps.size() != 0;
                if (theFlagToKeepTracking) {
                    this.removeCirculars();
                }
                gListOfCircularDeps = new ArrayList<CircularGraphKeyValue>();
            }
        }
    }

    private void invertTrailsMap() {
        for (String theId : this.gHMapIdToTrails.keySet()) {
            List<String> theVectBuffer = this.gHMapIdToTrails.get(theId);
            for (int theIndex = 0; theIndex < theVectBuffer.size(); ++theIndex) {
                this.gHMapTrailToId.put(theVectBuffer.get(theIndex), theId);
            }
        }
    }

    private void summarizeMap(Map<String, List<String>> aMap) {
        List<String> theBuffer;
        String theId;
        Set<Map.Entry<String, List<String>>> theEntrySet = aMap.entrySet();
        for (Map.Entry<String, List<String>> theEntry : theEntrySet) {
            theId = theEntry.getKey();
            theBuffer = theEntry.getValue();
            List<String> theFastTracks = this.scaleTrails(theBuffer);
            String theHeavyTrack = theFastTracks.get(0);
            int theWeightTrack = this.chop(theHeavyTrack, String.valueOf('.')).size();
            if (theWeightTrack > this.gIntMaximumMaximorumWeight) {
                this.gIntMaximumMaximorumWeight = theWeightTrack;
            }
            aMap.put(theId, theFastTracks);
            this.gHMapHeavyTrailToIdSummary.put(theHeavyTrack, theId);
            theBuffer = this.gHMapHeavyWeightToHeavyTrailSummary.get(String.valueOf(theWeightTrack));
            if (theBuffer == null) {
                theBuffer = new ArrayList<String>();
            }
            theBuffer.add(theHeavyTrack);
            this.gHMapHeavyWeightToHeavyTrailSummary.put(String.valueOf(theWeightTrack), theBuffer);
        }
        theEntrySet = this.gHMapHeavyWeightToHeavyTrailSummary.entrySet();
        for (Map.Entry<String, List<String>> theEntry : theEntrySet) {
            theId = theEntry.getKey();
            theBuffer = theEntry.getValue();
            Collections.sort(theBuffer);
            this.gHMapHeavyWeightToHeavyTrailSummary.put(theId, theBuffer);
        }
    }

    protected final void analyseDependencies() {
        this.invertTrailsMap();
        LOGGER.log(Level.FINE, "     -= Submitted Dependency Graph =-");
        this.showDependencies(this.gHMapIdToTrails);
        this.optimizeDependencies();
        LOGGER.log(Level.FINE, "     -= Proposed Dependency Graph =-");
        this.showDependencies(this.gHMapIdToTracks);
    }

    protected final void displayInitialDependencies() {
        this.showDependencies(this.gHMapIdToTrails);
    }

    protected final void displayOptimizedDependencies() {
        this.showDependencies(this.gHMapIdToTracks);
    }

    private void showDependencies(Map<String, List<String>> aTrailsMap) {
        Set<String> theHSetParent;
        String theStrParentName;
        Iterator<String> theOverallIter = aTrailsMap.keySet().iterator();
        this.gHMapParentToChild = new HashMap<String, Set<String>>();
        while (theOverallIter.hasNext()) {
            String theKey = theOverallIter.next();
            List<String> theTrails = aTrailsMap.get(theKey);
            for (String theStrChildId : theTrails) {
                String theStrChildName = this.gHMapTrailToId.get(theStrChildId);
                String theStrParentId = this.getParentTrail(theStrChildId);
                theStrParentName = this.gHMapTrailToId.get(theStrParentId);
                if (!theStrParentName.equals(theStrChildName)) continue;
                theHSetParent = this.gHMapParentToChild.get(theStrParentName);
                if (theHSetParent == null) {
                    theHSetParent = new HashSet<String>();
                }
                theHSetParent.add(theStrChildName);
                this.gHMapParentToChild.put(theStrParentName, theHSetParent);
            }
        }
        if (this.getVerbose()) {
            List<String> theVectRoots = this.gHMapHeavyWeightToHeavyTrailSummary.get("1");
            for (String theStrParentId1 : theVectRoots) {
                theStrParentName = this.gHMapTrailToId.get(theStrParentId1);
                this.readTrail(theStrParentName, 0);
            }
        }
        theOverallIter = aTrailsMap.keySet().iterator();
        LOGGER.log(Level.FINE, "--------------------------------------------------------------------");
        while (theOverallIter.hasNext()) {
            theStrParentName = theOverallIter.next();
            theHSetParent = this.gHMapParentToChild.get(theStrParentName);
            LOGGER.log(Level.FINE, theStrParentName + " -> ");
            if (theHSetParent == null) {
                LOGGER.log(Level.FINE, "[]");
                continue;
            }
            LOGGER.log(Level.FINE, theHSetParent.toString());
        }
        LOGGER.log(Level.FINE, "--------------------------------------------------------------------");
    }

    private void readTrail(String aIdentifier, int aIndentation) {
        String theStrOneSpace = " ";
        StringBuilder theStrSpace = new StringBuilder();
        Set<String> theSetChildren = this.gHMapParentToChild.get(aIdentifier);
        for (int theIndex = 0; theIndex < aIndentation; ++theIndex) {
            theStrSpace.append(" ");
        }
        LOGGER.log(Level.FINE, theStrSpace.append(aIdentifier).toString());
        if (theSetChildren != null) {
            for (String theChild : theSetChildren) {
                this.readTrail(theChild, aIndentation + 3);
            }
        }
    }

    private void optimizeDependencies() {
        for (String theKey : this.gHMapIdToTrails.keySet()) {
            List<String> theTracks = this.reduceIdentifier(theKey);
            this.gHMapIdToTracks.put(theKey, theTracks);
            if (theTracks.size() == this.gHMapIdToTrails.get(theKey).size()) continue;
            LOGGER.log(Level.FINE, "Modified " + theKey);
        }
    }

    private List<String> reduceIdentifier(String aEntry) {
        this.gListTemporary = this.scaleTrails(this.getTrails(aEntry));
        for (int theIndex = 0; theIndex < this.gListTemporary.size() - 1; ++theIndex) {
            this.inspectTrail(theIndex);
        }
        return this.gListTemporary;
    }

    private boolean inspectTrail(int aTrailPos) {
        boolean theBRedundancy = false;
        String theLongTrail = this.gListTemporary.get(aTrailPos);
        for (int theSubIndex = aTrailPos + 1; theSubIndex < this.gListTemporary.size(); ++theSubIndex) {
            String theShortTrail = this.gListTemporary.get(theSubIndex);
            if (!this.redundantTrails(theLongTrail, theShortTrail)) continue;
            this.inspectTrail(theSubIndex);
            theBRedundancy = true;
            this.gListTemporary.remove(theSubIndex);
        }
        return theBRedundancy;
    }

    private boolean redundantTrails(String aLongTrail, String aShortTrail) {
        boolean theRedundant = false;
        int theNarrow = 0;
        List<String> theVectLong = this.convert(aLongTrail);
        List<String> theVectShort = this.convert(aShortTrail);
        while (2 * theNarrow < theVectShort.size() && theVectLong.get(theNarrow) == theVectShort.get(theNarrow) && theVectLong.get(theVectLong.size() - 1 - theNarrow) == theVectShort.get(theVectShort.size() - 1 - theNarrow)) {
            ++theNarrow;
        }
        if (2 * theNarrow == theVectShort.size() || theVectShort.get(theNarrow) == theVectShort.get(theVectShort.size() - 1 - theNarrow) && (theVectShort.get(theNarrow) == theVectLong.get(theNarrow) || theVectShort.get(theNarrow) == theVectLong.get(theVectLong.size() - 1 - theNarrow))) {
            theRedundant = true;
        }
        return theRedundant;
    }

    private List<String> scaleTrails(List aTrails) {
        String theStrBuffer;
        int theIndex;
        ArrayList<String> theListOut = new ArrayList<String>();
        int theIntMaxWeight = 0;
        HashMap theHMapWeights = new HashMap();
        for (theIndex = 0; theIndex < aTrails.size(); ++theIndex) {
            theStrBuffer = (String)aTrails.get(theIndex);
            int theIntWeight = this.chop(theStrBuffer, String.valueOf('.')).size();
            if (theIntWeight > theIntMaxWeight) {
                theIntMaxWeight = theIntWeight;
            }
            List<String> theListBuffer = new ArrayList<String>();
            String theKey = String.valueOf(theIntWeight);
            if (theHMapWeights.containsKey(theKey)) {
                theListBuffer = (List)theHMapWeights.get(theKey);
            }
            theListBuffer.add(theStrBuffer);
            theHMapWeights.put(theKey, theListBuffer);
        }
        for (theIndex = theIntMaxWeight; theIndex > 0; --theIndex) {
            theStrBuffer = String.valueOf(theIndex);
            List theListBuffer = (List)theHMapWeights.get(theStrBuffer);
            if (theListBuffer == null) continue;
            Collections.sort(theListBuffer);
            theListOut.addAll(theListBuffer);
        }
        return theListOut;
    }

    private List<String> convert(String aTrail) {
        List<String> theDisassembledTrail = this.chop(aTrail, String.valueOf('.'));
        for (int theIndex = theDisassembledTrail.size() - 1; theIndex >= 0; --theIndex) {
            StringBuilder theElementId = new StringBuilder();
            for (int theSubIndex = 0; theSubIndex <= theIndex; ++theSubIndex) {
                if (theSubIndex > 0) {
                    theElementId.append('.');
                }
                theElementId.append(theDisassembledTrail.get(theSubIndex));
            }
            String theElementName = this.gHMapTrailToId.get(theElementId.toString());
            theDisassembledTrail.set(theIndex, theElementName);
        }
        return theDisassembledTrail;
    }

    private List<String> chop(String aInput, String aSeparator) {
        ArrayList<String> theOutput = new ArrayList<String>();
        StringTokenizer theStrtkn = new StringTokenizer(aInput, aSeparator);
        while (theStrtkn.hasMoreElements()) {
            theOutput.add((String)theStrtkn.nextElement());
        }
        return theOutput;
    }

    private void initializeMaps() {
        this.setDependenciesSafe(true);
        this.gHMapIdToTrails = new HashMap<String, List<String>>();
        this.gHMapIdToTracks = new HashMap<String, List<String>>();
        this.initializeSummaryMaps();
    }

    private void initializeSummaryMaps() {
        this.gHMapTrailToId = new HashMap<String, String>();
        this.gHMapIdToTracks = new HashMap<String, List<String>>();
        this.gHMapParentToChild = new HashMap<String, Set<String>>();
        this.gHMapHeavyTrailToIdSummary = new HashMap<String, String>();
        this.gHMapHeavyWeightToHeavyTrailSummary = new HashMap<String, List<String>>();
    }

    private void insertEntry(String aEntry, String aIdentifier) {
        if (!this.gHMapIdToTrails.containsKey(aEntry)) {
            this.gHMapIdToTrails.put(aEntry, new ArrayList());
        }
        List<String> theAliases = this.gHMapIdToTrails.get(aEntry);
        theAliases.add(aIdentifier);
        this.gHMapIdToTrails.put(aEntry, theAliases);
    }

    private String getChildAlias(String aParentAlias, int aSiblingOffset) {
        int theIntLastLevelSeparator = aParentAlias.lastIndexOf(46);
        int theIntLastLevelPosition = aParentAlias.lastIndexOf(47);
        if (theIntLastLevelPosition < 0) {
            theIntLastLevelPosition = aParentAlias.length();
        }
        theIntLastLevelSeparator = theIntLastLevelSeparator < 0 ? 0 : ++theIntLastLevelSeparator;
        String theStrLastLevel = aParentAlias.substring(theIntLastLevelSeparator, theIntLastLevelPosition);
        String theStrNextLevel = String.valueOf(Integer.decode(theStrLastLevel) + 1);
        return aParentAlias + '.' + theStrNextLevel + '/' + aSiblingOffset;
    }

    private String getParentTrail(String aChildTrail) {
        int theIntLastLevelSeparator = aChildTrail.lastIndexOf(46);
        if (theIntLastLevelSeparator < 0) {
            theIntLastLevelSeparator = aChildTrail.length();
        }
        return aChildTrail.substring(0, theIntLastLevelSeparator);
    }

    public abstract List<String> getDependencies(String var1);

    public abstract boolean isLegitimateGroup(String var1);

    public abstract boolean isLegitimateComponent(String var1);

    public abstract void setSelection(List<String> var1);

    public abstract void setVerbose(boolean var1);

    public abstract boolean getVerbose();

    public final Map<String, List<String>> exportDirectDependencies() {
        HashMap<String, List<String>> theDisposableMap = new HashMap<String, List<String>>();
        theDisposableMap.putAll(this.gHMapDirectDependencies);
        return theDisposableMap;
    }

    public final boolean getDependenciesSafe() {
        return this.gBDependenciesOk;
    }

    private void setDependenciesSafe(boolean aStatus) {
        this.gBDependenciesOk = aStatus;
    }

    public final String getKnotName() {
        return this.gStrKnot;
    }

    private void setKnotName(String aKnot) {
        this.gStrKnot = aKnot;
    }

    public final String getMissingName() {
        return this.gStrMissing;
    }

    private void setMissingName(String aMissing) {
        this.gStrMissing = aMissing;
    }
}

