/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.DependencyManager;
import org.openinstaller.provider.dependency.HybridComponentElement;
import org.openinstaller.provider.dependency.L10nInstallableUnitKeyValue;
import org.openinstaller.provider.dependency.PlatformInstUnit;
import org.openinstaller.provider.dependency.PreConfiguredKeyValue;
import org.openinstaller.provider.dependency.RequirementKeyValue;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaProduct
implements ProductNodeInterface {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private DependencyManager gDependencyManager;
    private HybridComponentElement gHybridComponentElement;
    private boolean gUpgradeable = true;
    private String gLocalizationCompositeUnitName = "Localization";

    public MediaProduct(DependencyManager aDependencyManager, HybridComponentElement aHybridComponentElement) {
        this.gDependencyManager = aDependencyManager;
        try {
            if (aHybridComponentElement == null) {
                throw new EnhancedException("COMPONENT_NOT_DEFINED", new String[0]);
            }
            this.gHybridComponentElement = aHybridComponentElement;
        }
        catch (EnhancedException aException) {
            LOGGER.log(Level.FINE, "COMPONENT_NOT_DEFINED", aException);
        }
    }

    public final String getID() {
        return this.gHybridComponentElement.getIdentifier();
    }

    public String getName() {
        return this.gHybridComponentElement.getName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    public String getVersionStr() {
        return this.getVersion().toString();
    }

    public final String toString() {
        return this.getName();
    }

    public final String getDescription() {
        return this.gHybridComponentElement.getDescription(Locale.getDefault());
    }

    public final String getDescription(Locale aLocale) {
        return this.gHybridComponentElement.getDescription(aLocale);
    }

    public final Map<Locale, String> getDescriptions() {
        return this.gHybridComponentElement.getDescriptions();
    }

    public final Version getVersion() {
        return new Version(this.gHybridComponentElement.getVersion());
    }

    public void setUpgradeable(boolean aUpgradeable) {
        this.gUpgradeable = aUpgradeable;
    }

    public boolean isUpgradeable() {
        return this.gUpgradeable;
    }

    public final String getRelease(Platform aPlatform) {
        String theStoredRel = null;
        try {
            List<PlatformInstUnit> theInstallableUnits = this.getCoreInstallableUnits(aPlatform);
            for (PlatformInstUnit thePlatPkg : theInstallableUnits) {
                String theCurrentRel;
                if (thePlatPkg == null || (theCurrentRel = thePlatPkg.getIU().getVersion()) == null) continue;
                if (theStoredRel == null) {
                    theStoredRel = theCurrentRel;
                    continue;
                }
                Version theStoredVer = new Version(theStoredRel.trim());
                Version theCurrentVer = new Version(theCurrentRel.trim());
                if (theCurrentVer.compareTo(theStoredVer) <= 0) continue;
                theStoredRel = theCurrentRel;
            }
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "Could not get Installable units");
        }
        if (theStoredRel == null) {
            theStoredRel = this.getVersionStr();
        }
        return theStoredRel;
    }

    public final Set<MediaProduct> getFeatures() {
        LinkedHashSet<MediaProduct> theResultList = new LinkedHashSet<MediaProduct>();
        for (String theElementID : this.gHybridComponentElement.getFeaturesID()) {
            try {
                theResultList.add(this.gDependencyManager.getProductNode(theElementID));
            }
            catch (EnhancedException theEException) {
                LOGGER.log(Level.FINE, "HYBRID_NOT_DEFINED");
            }
        }
        return theResultList;
    }

    public final boolean isUpgradeAll() {
        ComponentDescriptor theCompDesc = this.gHybridComponentElement.getComponentDescriptor();
        return theCompDesc.isUpgradeAll();
    }

    public final Set<MediaProduct> getDependencies() {
        HashSet<MediaProduct> theResultList = new HashSet<MediaProduct>();
        for (String theElementID : this.gHybridComponentElement.getDependenciesID()) {
            try {
                theResultList.add(this.gDependencyManager.getProductNode(theElementID));
            }
            catch (EnhancedException theEException) {
                LOGGER.log(Level.FINE, "HYBRID_NOT_DEFINED");
            }
        }
        return theResultList;
    }

    public final List<PlatformInstUnit> getCoreInstallableUnits(Platform aPlatform) throws EnhancedException {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        ArrayList<PlatformInstUnit> theInstallableUnits = new ArrayList<PlatformInstUnit>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            if (this.gLocalizationCompositeUnitName.equalsIgnoreCase(theCompositeUnitName)) continue;
            for (PlatformInstUnit thePlatformIU : theComponentDescriptor.getPayloadInstallableUnits(theCompositeUnitName, aPlatform)) {
                theInstallableUnits.add(thePlatformIU);
            }
        }
        return theInstallableUnits;
    }

    public final List<PlatformInstUnit> getLocalizedInstallableUnits(Platform aPlatform) throws EnhancedException {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        ArrayList<PlatformInstUnit> thePlatformInstallableUnits = new ArrayList<PlatformInstUnit>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            for (PlatformInstUnit thePlatformIU : theComponentDescriptor.getPayloadInstallableUnits(theCompositeUnitName, aPlatform)) {
                String theTempL10nLocalizedName = thePlatformIU.getIU().getLocalizedInstallableUnitName();
                if (theTempL10nLocalizedName == null || "".equals(theTempL10nLocalizedName)) continue;
                thePlatformInstallableUnits.add(new PlatformInstUnit(aPlatform, new L10nInstallableUnitKeyValue(theTempL10nLocalizedName, "", thePlatformIU.getIU().getOverwrite())));
            }
        }
        if (theComponentDescriptor.getPayloadCompositeNames().contains(this.gLocalizationCompositeUnitName)) {
            for (PlatformInstUnit thePlatformInstUnit : theComponentDescriptor.getPayloadInstallableUnits(this.gLocalizationCompositeUnitName, aPlatform)) {
                if (thePlatformInstUnit.getIU().getCoreInstallableUnitName() == null) continue;
                thePlatformInstallableUnits.add(thePlatformInstUnit);
            }
        }
        return thePlatformInstallableUnits;
    }

    public List<String> getRequirementTypes(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        List<Object> theRequirements = new ArrayList();
        ArrayList<String> theResult = new ArrayList<String>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            theRequirements = theComponentDescriptor.getPayloadRequirements(theCompositeUnitName, aPlatform);
        }
        if (theRequirements != null) {
            for (RequirementKeyValue theRequirement : theRequirements) {
                theResult.add(theRequirement.getType());
            }
        }
        return theResult;
    }

    public List<String> getRequirementContents(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        List<Object> theRequirements = new ArrayList();
        ArrayList<String> theResult = new ArrayList<String>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            theRequirements = theComponentDescriptor.getPayloadRequirements(theCompositeUnitName, aPlatform);
        }
        if (theRequirements != null) {
            for (RequirementKeyValue theRequirement : theRequirements) {
                theResult.add(theRequirement.getContent());
            }
        }
        return theResult;
    }

    public Map<String, List<RequirementKeyValue>> getPayloadRequirementsMap() {
        return null;
    }

    public List<RequirementKeyValue> getRequirements(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        List<RequirementKeyValue> theRequirements = new ArrayList<RequirementKeyValue>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            theRequirements = theComponentDescriptor.getPayloadRequirements(theCompositeUnitName, aPlatform);
        }
        if (theRequirements == null) {
            theRequirements = new ArrayList();
        }
        return theRequirements;
    }

    public List<String> getKeyFiles(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        List<String> theKeyFilesList = new ArrayList<String>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            theKeyFilesList = theComponentDescriptor.getKeyFilesList(theCompositeUnitName, aPlatform);
        }
        if (theKeyFilesList == null) {
            theKeyFilesList = new ArrayList();
        }
        return theKeyFilesList;
    }

    public Map<String, String> getRegistryEntries(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        List<RequirementKeyValue> theRegistryEntries = null;
        HashMap<String, String> theRegistryEntryMap = new HashMap<String, String>();
        for (String theCompositeUnitname : theComponentDescriptor.getPayloadCompositeNames()) {
            theRegistryEntries = theComponentDescriptor.getKeyRegEntriesList(theCompositeUnitname, aPlatform);
        }
        if (theRegistryEntries != null) {
            for (RequirementKeyValue theKeyValue : theRegistryEntries) {
                theRegistryEntryMap.put(theKeyValue.getKey(), theKeyValue.getValue());
            }
        }
        return theRegistryEntryMap;
    }

    public final Map<String, List<String>> getPayloadRequirementsMap(Platform aPlatform) {
        ComponentDescriptor theComponentDescriptor = this.gHybridComponentElement.getComponentDescriptor();
        HashMap<String, List<String>> theResultMap = new HashMap<String, List<String>>();
        for (String theCompositeUnitName : theComponentDescriptor.getPayloadCompositeNames()) {
            for (RequirementKeyValue theRequirement : theComponentDescriptor.getPayloadRequirements(theCompositeUnitName, aPlatform)) {
                ArrayList<String> theRequiredValues = (ArrayList<String>)theResultMap.get(theRequirement.getType());
                if (theRequiredValues == null) {
                    theRequiredValues = new ArrayList<String>();
                }
                theRequiredValues.add(theRequirement.getValue());
                theResultMap.put(theRequirement.getType(), theRequiredValues);
            }
        }
        return theResultMap;
    }

    public List<String> getRequiredCapabilitiesID() {
        return this.gHybridComponentElement.getRequiredCapabilitiesID();
    }

    public final boolean isDamaged() {
        return false;
    }

    public final boolean isFeature() {
        return this.gHybridComponentElement.getComponentDescriptor().isFeature();
    }

    public final boolean needsPreconfig(ProductNodeInterface aPNItoEvaluate) {
        boolean theResult = false;
        String theDependencyName = aPNItoEvaluate.getID();
        Iterator<PreConfiguredKeyValue> theIterConfigReqs = this.getRequirementConfigureRequired().iterator();
        while (!theResult && theIterConfigReqs.hasNext()) {
            PreConfiguredKeyValue theItem = theIterConfigReqs.next();
            if (!theDependencyName.equals(theItem.getContent())) continue;
            theResult = true;
        }
        return theResult;
    }

    protected final boolean isCompatible(ProductNodeInterface aPNIToCompare) {
        boolean theResult = true;
        if (aPNIToCompare != null) {
            ComponentDescriptor theComparedComponentDescriptor = ((MediaProduct)aPNIToCompare).gHybridComponentElement.getComponentDescriptor();
            theResult = this.gHybridComponentElement.getComponentDescriptor().isCompatible(theComparedComponentDescriptor);
        }
        return theResult;
    }

    public final boolean getStatus() {
        return this.gHybridComponentElement.getStatus();
    }

    public final List<PreConfiguredKeyValue> getRequirementConfigureRequired() {
        return this.gHybridComponentElement.getRequirementConfigureRequired();
    }
}

