/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import org.openinstaller.sims.ProgressListener;
import org.openinstaller.util.InvalidArgumentException;

public final class FractionalProgressListener
implements ProgressListener {
    private final int start;
    private final int end;
    private final ProgressListener listener;

    public FractionalProgressListener(ProgressListener aListener, int aStart, int aEnd) throws InvalidArgumentException {
        if (aStart > aEnd) {
            throw new InvalidArgumentException("START_MUST_BE_LESS_OR_EQUAL_TO_END", new String[0]);
        }
        this.start = aStart;
        this.end = aEnd;
        this.listener = aListener;
    }

    public void updateProgress(int aFullProgress) {
        if (this.listener == null) {
            return;
        }
        int theFractionalProgress = (int)((double)aFullProgress / 100.0 * (double)(this.end - this.start));
        this.listener.updateProgress(this.start + theFractionalProgress);
    }
}

