/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.ResourceUtils;
import org.openinstaller.util.JDKSelection.utils.StringUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.NativeException;
import org.openinstaller.util.JDKSelection.utils.helper.ExecutionResults;
import org.openinstaller.util.JDKSelection.utils.helper.Platform;
import org.openinstaller.util.JDKSelection.utils.system.windows.WindowsRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemUtils {
    public static final long MAX_EXECUTION_TIME = 120000L;
    public static final int BUFFER_SIZE = 4096;
    public static final int DELAY = 50;
    private static Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
    private static Platform currentPlatform;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseString(String string, ClassLoader loader) {
        String value;
        String name;
        String classname;
        String parsed = string;
        try {
            parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{install\\}", StringUtils.escapeRegExp(SystemUtils.getDefaultApplicationsLocation().getAbsolutePath()));
        }
        catch (NativeException e) {
            LOGGER.log(Level.INFO, "Cannot obtain default applications location", e);
        }
        parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{home\\}", StringUtils.escapeRegExp(SystemUtils.getUserHomeDirectory().getAbsolutePath()));
        parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{temp\\}", StringUtils.escapeRegExp(SystemUtils.getTempDirectory().getAbsolutePath()));
        parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{current\\}", StringUtils.escapeRegExp(SystemUtils.getCurrentDirectory().getAbsolutePath()));
        Matcher matcher = Pattern.compile("(?<!\\\\)\\$P\\{(.*?), (.*?)(?:, (.*?))?\\}").matcher(parsed);
        while (matcher.find()) {
            String basename = matcher.group(1);
            String key = matcher.group(2);
            String argumentsString = matcher.group(3);
            if (argumentsString == null) {
                parsed = parsed.replace(matcher.group(), ResourceUtils.getString(basename, key, loader));
                continue;
            }
            Object[] arguments = argumentsString.split(", ?");
            parsed = parsed.replace(matcher.group(), ResourceUtils.getString(basename, key, loader, arguments));
        }
        matcher = Pattern.compile("(?<!\\\\)\\$F\\{((?:[a-zA-Z_][a-zA-Z_0-9]*\\.)+[a-zA-Z_][a-zA-Z_0-9]*)\\.([a-zA-Z_][a-zA-Z_0-9]*)\\}").matcher(parsed);
        while (matcher.find()) {
            classname = matcher.group(1);
            String fieldname = matcher.group(2);
            try {
                Object object = loader.loadClass(classname).getField(fieldname).get(null);
                if (object == null) continue;
                String value2 = object.toString();
                parsed = parsed.replace(matcher.group(), value2);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (SecurityException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (NoSuchFieldException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
        }
        matcher = Pattern.compile("(?<!\\\\)\\$M\\{((?:[a-zA-Z_][a-zA-Z_0-9]*\\.)+[a-zA-Z_][a-zA-Z_0-9]*)\\.([a-zA-Z_][a-zA-Z_0-9]*)\\(\\)\\}").matcher(parsed);
        while (matcher.find()) {
            classname = matcher.group(1);
            String methodname = matcher.group(2);
            try {
                Object object;
                Method method = loader.loadClass(classname).getMethod(methodname, new Class[0]);
                if (method == null || (object = method.invoke(null, new Object[0])) == null) continue;
                String value3 = object.toString();
                parsed = parsed.replace(matcher.group(), value3);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (SecurityException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
        }
        matcher = Pattern.compile("(?<!\\\\)\\$R\\{(.*?)\\}").matcher(parsed);
        while (matcher.find()) {
            String path = matcher.group(1);
            InputStream inputStream = null;
            try {
                inputStream = ResourceUtils.getResource(path, loader);
                parsed = parsed.replace(matcher.group(), StringUtils.readStream(inputStream));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Cannot parse pattern: " + matcher.group(), e);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, "Cannot close input stream after reading resource: " + matcher.group(), e);
                }
            }
        }
        matcher = Pattern.compile("(?<!\\\\)\\$S\\{(.*?)\\}").matcher(parsed);
        while (matcher.find()) {
            name = matcher.group(1);
            value = System.getProperty(name);
            parsed = parsed.replace(matcher.group(), value);
        }
        matcher = Pattern.compile("(?<!\\\\)\\$E\\{(.*?)\\}").matcher(parsed);
        while (matcher.find()) {
            name = matcher.group(1);
            value = System.getenv(name);
            parsed = parsed.replace(matcher.group(), value);
        }
        parsed.replace("\\$", "$");
        parsed.replace("\\\\", "\\");
        return parsed;
    }

    public static File parsePath(String string) {
        return SystemUtils.parsePath(string, SystemUtils.class.getClassLoader());
    }

    public static File parsePath(String path, ClassLoader loader) {
        String separator = SystemUtils.getFileSeparator();
        String parsed = SystemUtils.parseString(path, loader);
        parsed = parsed.replace("\\", separator);
        parsed = parsed.replace("/", separator);
        try {
            if (parsed.contains(separator + ".." + separator) || parsed.contains(separator + "." + separator) || parsed.endsWith(separator + "..") || parsed.endsWith(separator + ".")) {
                return new File(parsed).getCanonicalFile();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not get the cannonical path", e);
        }
        return new File(parsed).getAbsoluteFile();
    }

    public static File getUserHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static File getCurrentDirectory() {
        return new File(".");
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getDefaultApplicationsLocation() throws NativeException {
        switch (SystemUtils.getCurrentPlatform()) {
            case WINDOWS: {
                return WindowsRegistry.getDefaultApplicationsLocation();
            }
        }
        return SystemUtils.getUserHomeDirectory();
    }

    public static File getCurrentJavaHome() {
        return new File(System.getProperty("java.home"));
    }

    public static File getUnpacker() {
        if (SystemUtils.isWindows()) {
            return new File(SystemUtils.getCurrentJavaHome(), "bin/unpack200.exe");
        }
        return new File(SystemUtils.getCurrentJavaHome(), "bin/unpack200");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public static ExecutionResults executeCommand(String ... command) throws IOException {
        return SystemUtils.executeCommand(null, command);
    }

    public static ExecutionResults executeCommand(File workingDirectory, String ... command) throws IOException {
        long runningTime;
        StringBuilder stringBuilder = new StringBuilder();
        for (String temp : command) {
            stringBuilder.append(temp).append(" ");
        }
        if (workingDirectory == null) {
            workingDirectory = SystemUtils.getCurrentDirectory();
        }
        LOGGER.log(Level.FINER, "executing command: " + stringBuilder + ", in directory: " + workingDirectory);
        StringBuilder processStdOut = new StringBuilder();
        StringBuilder processStdErr = new StringBuilder();
        int errorLevel = Integer.MAX_VALUE;
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDirectory);
        if (environment != null) {
            builder.environment().clear();
            builder.environment().putAll(environment);
            environment = null;
        }
        Process process = builder.start();
        for (runningTime = 0L; runningTime < 120000L; runningTime += 50L) {
            String line;
            BufferedReader reader;
            String string = StringUtils.readStream(process.getInputStream());
            if (string.length() > 0) {
                reader = new BufferedReader(new StringReader(string));
                line = reader.readLine();
                while (line != null) {
                    LOGGER.log(Level.FINER, "[stdout]: " + line);
                    line = reader.readLine();
                }
                processStdOut.append(string);
            }
            if ((string = StringUtils.readStream(process.getErrorStream())).length() > 0) {
                reader = new BufferedReader(new StringReader(string));
                line = reader.readLine();
                while (line != null) {
                    LOGGER.log(Level.FINER, "[stdout]: " + line);
                    line = reader.readLine();
                }
                processStdErr.append(string);
            }
            try {
                errorLevel = process.exitValue();
                break;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    LOGGER.log(Level.INFO, "Interrupted", e2);
                }
                continue;
            }
        }
        if (runningTime >= 120000L) {
            process.destroy();
            LOGGER.log(Level.FINER, "[return]: killed by timeout");
        } else {
            LOGGER.log(Level.FINER, "[return]: " + errorLevel);
        }
        process.destroy();
        LOGGER.log(Level.FINER, "... command execution finished");
        return new ExecutionResults(errorLevel, processStdOut.toString(), processStdErr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port, int ... forbiddenPorts) {
        for (int forbidden : forbiddenPorts) {
            if (port != forbidden) continue;
            return false;
        }
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            int len$ = 1;
            return len$ != 0;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not close server socket on port " + port, e);
                }
            }
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.INFO, "Interrupted while sleeping", e);
        }
    }

    public static Map<String, String> getEnvironment() {
        return environment;
    }

    public static Platform getCurrentPlatform() {
        if (currentPlatform == null) {
            if (System.getProperty("os.name").contains("Windows")) {
                currentPlatform = Platform.WINDOWS;
            }
            if (System.getProperty("os.name").contains("Linux")) {
                currentPlatform = Platform.LINUX;
            }
            if (System.getProperty("os.name").contains("Mac OS X") && System.getProperty("os.arch").contains("ppc")) {
                currentPlatform = Platform.MACOS_X_PPC;
            }
            if (System.getProperty("os.name").contains("Mac OS X") && System.getProperty("os.arch").contains("i386")) {
                currentPlatform = Platform.MACOS_X_X86;
            }
            if (System.getProperty("os.name").contains("SunOS") && System.getProperty("os.arch").contains("sparc")) {
                currentPlatform = Platform.SOLARIS_SPARC;
            }
            if (System.getProperty("os.name").contains("SunOS") && System.getProperty("os.arch").contains("x86")) {
                currentPlatform = Platform.SOLARIS_X86;
            }
            if (System.getProperty("os.name").contains("HP-UX") && System.getProperty("os.arch").contains("RISC")) {
                currentPlatform = Platform.HPUX_RISC;
            }
            if (System.getProperty("os.name").contains("AIX") && System.getProperty("os.arch").contains("ppc")) {
                currentPlatform = Platform.AIX_PPC;
            }
        }
        return currentPlatform;
    }

    public static boolean isWindows() {
        return SystemUtils.getCurrentPlatform() == Platform.WINDOWS;
    }

    public static boolean isMacOS() {
        return SystemUtils.getCurrentPlatform() == Platform.MACOS_X_X86 || SystemUtils.getCurrentPlatform() == Platform.MACOS_X_PPC;
    }

    public static boolean intersects(List<? extends Object> list1, List<? extends Object> list2) {
        for (Object object : list1) {
            for (Object object2 : list2) {
                if (!object.equals(object2)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

