/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.Msg;

public final class LogThread
extends Thread {
    private InputStream gLin = null;
    private OutputStream[] gOuts = null;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public LogThread(InputStream aLin, OutputStream[] aOuts) {
        this.setInputStream(aLin);
        this.setOutputStreams(aOuts);
    }

    public LogThread(InputStream aLin, OutputStream aOut) {
        this.setInputStream(aLin);
        this.setOutputStream(aOut);
    }

    public void setInputStream(InputStream aLin) {
        this.gLin = aLin;
    }

    public void setOutputStreams(OutputStream[] aOuts) {
        this.gOuts = (OutputStream[])aOuts.clone();
    }

    public void setOutputStream(OutputStream aOut) {
        OutputStream[] theOutputStream = new OutputStream[]{aOut};
        this.setOutputStreams(theOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BufferedInputStream theBin = new BufferedInputStream(this.gLin);
        BufferedOutputStream[] theBouts = new BufferedOutputStream[this.gOuts.length];
        try {
            for (int theIndex = 0; theIndex < theBouts.length; ++theIndex) {
                theBouts[theIndex] = new BufferedOutputStream(this.gOuts[theIndex]);
            }
            int theBytesWritten = 0;
            boolean theDoneFlag = false;
            while (!theDoneFlag) {
                int theNextByte = theBin.read();
                if (theNextByte == -1) {
                    theDoneFlag = true;
                    continue;
                }
                for (BufferedOutputStream theBout : theBouts) {
                    theBout.write(theNextByte);
                }
                if (theBytesWritten++ % 10240 != 0) continue;
                Thread.sleep(5L);
            }
        }
        catch (Exception theEx) {
            String theThreadMsg = Msg.get(this.getClass(), "LOGTHREAD_ERR", Thread.currentThread().toString() + ":" + theEx.toString());
            LOGGER.log(Level.WARNING, "ERROR_READING_STREAM", theThreadMsg);
        }
        finally {
            for (BufferedOutputStream theBout : theBouts) {
                try {
                    if (theBout == null) continue;
                    theBout.flush();
                    theBout.close();
                }
                catch (IOException theEx) {
                    LOGGER.log(Level.FINE, "Can't close stream", theEx);
                }
            }
        }
    }
}

