/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.config.oor.update.ComponentData;
import org.openinstaller.bindings.config.oor.update.Node;
import org.openinstaller.bindings.config.oor.update.ObjectFactory;
import org.openinstaller.bindings.config.oor.update.Prop;
import org.openinstaller.bindings.config.oor.update.Value;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.provider.conf.oor.OORGroup;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySheet {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private ComponentData gDataRoot;
    private String gPkgName;
    private String gCompName;
    private boolean gAllowTransient = true;

    public void read(OORComponent aSchema, InputStream aSheet) throws EnhancedException {
        this.gDataRoot = this.createDataRoot(aSchema, false);
        this.gPkgName = aSchema.getPackage();
        this.gCompName = aSchema.getName();
        if (aSheet != null) {
            ComponentData theData;
            try {
                JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.update");
                Unmarshaller theUnmarshaller = theContext.createUnmarshaller();
                theData = (ComponentData)theUnmarshaller.unmarshal(aSheet);
            }
            catch (JAXBException theEx) {
                throw new EnhancedException("CORRUPT_CONFIG_STREAM", (Throwable)theEx, new String[]{"stream=" + aSheet});
            }
            PropertySheet.updateDataRoot(this.gDataRoot, theData);
        }
    }

    public void read(OORComponent aSchema) throws EnhancedException {
        this.gDataRoot = this.createDataRoot(aSchema, true);
        this.gPkgName = aSchema.getPackage();
        this.gCompName = aSchema.getName();
    }

    private ComponentData createDataRoot(OORComponent aSchema, boolean aCurrentFlag) {
        ObjectFactory theFac = new ObjectFactory();
        ComponentData theRoot = theFac.createComponentData();
        theRoot.setPackage(aSchema.getPackage());
        theRoot.setFinalized(Boolean.valueOf(true));
        theRoot.setReadonly(Boolean.valueOf(true));
        for (OORGroup theGroup : aSchema.getGroups()) {
            Node theNode = theFac.createNode();
            theNode.setName(theGroup.getName());
            for (OORProp theOORProp : theGroup.getProperties()) {
                if (!this.gAllowTransient && theOORProp.isTransient()) {
                    LOGGER.fine("Ignoring transient " + theOORProp.getName());
                    continue;
                }
                Prop theProp = theFac.createProp();
                theProp.setName(theOORProp.getName());
                theProp.setType(theOORProp.getType().getTypeSpecifier());
                Value theVal = theFac.createValue();
                try {
                    if (aCurrentFlag) {
                        if (theOORProp.getValue() != null) {
                            theVal.getValue().add(theOORProp.getValue().toString());
                        }
                    } else if (theOORProp.getDefaultValue() != null) {
                        theVal.getValue().add(theOORProp.getDefaultValue().toString());
                    }
                }
                catch (EnhancedException theEx) {
                    LOGGER.log(Level.FINE, "Could not get the current value from schema", "Property=" + theOORProp.getName());
                }
                theProp.getValue().add(theVal);
                theNode.getNodeOrProp().add(theProp);
            }
            theRoot.getNodeOrProp().add(theNode);
        }
        return theRoot;
    }

    private static void updateDataRoot(ComponentData aRoot, ComponentData aData) throws EnhancedException {
        for (Object theObj : aData.getNodeOrProp()) {
            if (Node.class.isInstance(theObj)) {
                Node theNode = (Node)theObj;
                LOGGER.fine("Updating node " + theNode.getName());
                Node theRootNode = PropertySheet.getNodeForName(aRoot.getNodeOrProp(), theNode.getName());
                PropertySheet.updateDataNode(theRootNode, theNode);
                continue;
            }
            throw new EnhancedException("CONFIG_DATA_INVALID", new String[]{"nodeorproperty=" + theObj});
        }
    }

    private static void updateDataNode(Node aRootNode, Node aNode) throws EnhancedException {
        for (Object theObj : aNode.getNodeOrProp()) {
            if (Node.class.isInstance(theObj)) {
                Node theNode = (Node)theObj;
                Node theRootNode = PropertySheet.getNodeForName(aRootNode.getNodeOrProp(), theNode.getName());
                LOGGER.fine("Updating node " + theNode.getName());
                PropertySheet.updateDataNode(theRootNode, theNode);
                continue;
            }
            Prop theProp = (Prop)theObj;
            LOGGER.fine("Looking for property " + theProp.getName());
            Prop theRootProp = PropertySheet.getPropForName(aRootNode.getNodeOrProp(), theProp.getName());
            theRootProp.setType(theProp.getType());
            theRootProp.getValue().clear();
            Value theNewValue = new ObjectFactory().createValue();
            String theNewString = PropertySheet.concat(((Value)theProp.getValue().get(0)).getValue());
            theNewValue.getValue().add(theNewString);
            theRootProp.getValue().add(theNewValue);
            for (Value theValue : theProp.getValue()) {
                theRootProp.getValue().add(theValue);
            }
        }
    }

    private static String concat(List<String> aStringList) {
        StringBuffer theSB = new StringBuffer();
        for (String theString : aStringList) {
            theSB.append(theString);
            theSB.append(" ");
        }
        return theSB.toString().trim();
    }

    private static Node getNodeForName(List<Object> aNodeOrProp, String aName) throws EnhancedException {
        for (Object theObj : aNodeOrProp) {
            Node theNode;
            if (!Node.class.isInstance(theObj) || !aName.equals((theNode = (Node)theObj).getName())) continue;
            return theNode;
        }
        throw new EnhancedException("CANNOT_FIND_NODE", new String[]{"nodename=" + aName});
    }

    private static Prop getPropForName(List<Object> aNodeOrProp, String aName) throws EnhancedException {
        LOGGER.fine("searching for property [" + aName + "]:");
        for (Object theObj : aNodeOrProp) {
            Prop theProp;
            LOGGER.fine("  - Object: " + theObj);
            if (!Prop.class.isInstance(theObj) || !aName.equals((theProp = (Prop)theObj).getName())) continue;
            return theProp;
        }
        throw new EnhancedException("CANNOT_FIND_PROPERTY", new String[]{"propertyname=" + aName});
    }

    public void write(OutputStream aOut) throws EnhancedException {
        this.checkInitialized();
        try {
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.update");
            Marshaller theMarshaller = theContext.createMarshaller();
            theMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            theMarshaller.marshal((Object)this.gDataRoot, aOut);
        }
        catch (JAXBException theEx) {
            throw new EnhancedException("CANNOT_WRITE_CONFIG_FILE", (Throwable)theEx, new String[]{"outputstream=" + aOut});
        }
    }

    private void checkInitialized() throws EnhancedException {
        if (this.gDataRoot == null) {
            throw new EnhancedException("NOT_INITIALIZED_WITH_DEF_DATA", new String[0]);
        }
    }

    public void setProperty(String aName, Object aValue) throws EnhancedException {
        Prop theRightProp = this.locateProp(aName);
        ((Value)theRightProp.getValue().get(0)).getValue().clear();
        ((Value)theRightProp.getValue().get(0)).getValue().add(aValue.toString());
    }

    private Prop locateProp(String aName) throws EnhancedException {
        Prop theRightProp;
        this.checkInitialized();
        int theArrayIndex = 0;
        StringTokenizer theStringTokens = new StringTokenizer(aName, ".");
        String[] theNames = new String[theStringTokens.countTokens()];
        while (theStringTokens.hasMoreTokens()) {
            theNames[theArrayIndex] = theStringTokens.nextToken();
            ++theArrayIndex;
        }
        if (theNames.length < 1) {
            throw new EnhancedException("ILLEGAL_PROP_NAME", new String[]{"propertyname=" + aName});
        }
        if (theNames.length == 1) {
            List theChildren = this.gDataRoot.getNodeOrProp();
            theRightProp = PropertySheet.getPropForName(theChildren, theNames[0]);
        } else {
            Node theCurNode = PropertySheet.getNodeForName(this.gDataRoot.getNodeOrProp(), theNames[0]);
            for (int theIndex = 1; theIndex < theNames.length - 1; ++theIndex) {
                theCurNode = PropertySheet.getNodeForName(theCurNode.getNodeOrProp(), theNames[theIndex]);
            }
            theRightProp = PropertySheet.getPropForName(theCurNode.getNodeOrProp(), theNames[theNames.length - 1]);
        }
        return theRightProp;
    }

    public String getProperty(String aName) throws EnhancedException {
        Prop theRightProp = this.locateProp(aName);
        return (String)((Value)theRightProp.getValue().get(0)).getValue().get(0);
    }

    public Map<String, String> getAllProps() throws EnhancedException {
        if (this.gDataRoot == null) {
            throw new EnhancedException("NOT_INITIALIZED_WITH_DEF_DATA", new String[0]);
        }
        HashMap<String, String> theProps = new HashMap<String, String>();
        for (Object theObj : this.gDataRoot.getNodeOrProp()) {
            if (Node.class.isInstance(theObj)) {
                Node theNode = (Node)theObj;
                theProps.putAll(this.getAllPropsForNode(theNode));
                continue;
            }
            Prop theProp = (Prop)theObj;
            String thePropName = theProp.getName();
            String thePropVal = (String)((Value)theProp.getValue().get(0)).getValue().get(0);
            theProps.put(thePropName, thePropVal);
        }
        return theProps;
    }

    private Map<String, String> getAllPropsForNode(Node aNode) {
        HashMap<String, String> theProps = new HashMap<String, String>();
        for (Object theObj : aNode.getNodeOrProp()) {
            if (Node.class.isInstance(theObj)) {
                theProps.putAll(this.getAllPropsForNode((Node)theObj));
                continue;
            }
            String thePropName = ((Prop)theObj).getName();
            String thePropVal = (String)((Value)((Prop)theObj).getValue().get(0)).getValue().get(0);
            theProps.put(thePropName, thePropVal);
        }
        return theProps;
    }

    public String getPackageName() throws EnhancedException {
        this.checkInitialized();
        return this.gPkgName;
    }

    public String getComponentName() throws EnhancedException {
        this.checkInitialized();
        return this.gCompName;
    }

    public boolean doesAllowTransients() {
        return this.gAllowTransient;
    }

    public void setAllowTransient(boolean aAllowTransient) {
        this.gAllowTransient = aAllowTransient;
    }
}

