/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.swixml.DefaultFactory;
import org.swixml.Factory;

public abstract class TagLibrary {
    private Map tags = new HashMap();

    public TagLibrary() {
        this.registerTags();
    }

    protected abstract void registerTags();

    public void registerTag(String string, Class clazz) {
        this.registerTag(string, new DefaultFactory(clazz));
    }

    public void registerTag(String string, Factory factory) {
        this.tags.put(string.toLowerCase(), factory);
    }

    public boolean unregisterTag(String string) {
        return null != this.tags.remove(string);
    }

    public Map getTagClasses() {
        return this.tags;
    }

    public Factory getFactory(String string) {
        return (Factory)this.tags.get(string.toLowerCase());
    }

    public Factory getFactory(Class clazz) {
        Factory factory = null;
        Iterator iterator = this.tags.values().iterator();
        while (iterator != null && iterator.hasNext()) {
            Factory factory2 = (Factory)iterator.next();
            if (!factory2.getTemplate().equals(clazz)) continue;
            factory = factory2;
            break;
        }
        return factory;
    }

    protected Method getSetter(Class clazz, String string) {
        Method method = null;
        Factory factory = this.getFactory(clazz.getName());
        if (factory != null) {
            method = factory.getSetter(string);
        }
        return method;
    }

    protected Method guessSetter(Class clazz, String string) {
        Method method = null;
        Factory factory = this.getFactory(clazz.getName());
        if (factory != null) {
            method = factory.guessSetter(string);
        }
        return method;
    }
}

