/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.LoggerAdapter;
import org.openinstaller.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedException
extends Exception {
    private static LoggerAdapter logger;
    private final List<MethodContext> gLoggableContextList;
    private final Date gExceptionTime;
    private final Throwable gThrown;
    private String gLoggedClassName = null;
    private String gLoggedMethodName = null;
    private String gUserVisibleMsgKey;
    private Object[] gUserVisibleParams;
    private String gLoggableMsgKey;

    public final Date getExceptionTime() {
        return (Date)this.gExceptionTime.clone();
    }

    public final Throwable getThrown() {
        return this.gThrown;
    }

    @Override
    public final Throwable getCause() {
        return this.getThrown();
    }

    public final String getLoggedClassName() {
        return this.gLoggedClassName;
    }

    public final String getLoggedMethodName() {
        return this.gLoggedMethodName;
    }

    public EnhancedException(String aMsgId, Throwable aThrowable, String ... aContext) {
        super(aMsgId);
        this.gLoggableMsgKey = aMsgId;
        this.gThrown = aThrowable;
        this.gExceptionTime = new Date();
        StackTraceElement[] theStack = this.getStackTrace();
        StackTraceElement theFrame = theStack[0];
        this.gLoggableContextList = new ArrayList<MethodContext>();
        this.gLoggableContextList.add(new MethodContext(this.formCaller(theFrame.getClassName(), theFrame.getMethodName()), aMsgId, aContext));
    }

    public EnhancedException(String aMsgId, String ... aContext) {
        this(aMsgId, (Throwable)null, aContext);
    }

    public EnhancedException(Throwable aThrowable) {
        this.gThrown = aThrowable;
        this.gLoggableContextList = new ArrayList<MethodContext>();
        this.gExceptionTime = new Date();
        this.gUserVisibleMsgKey = "";
        this.gLoggableMsgKey = "";
    }

    public final void setUserVisibleMessage(String aUserVisibleMsgKey, Object ... aUserVisibleParams) {
        if (aUserVisibleMsgKey != null) {
            this.gUserVisibleMsgKey = aUserVisibleMsgKey;
            this.gUserVisibleParams = (Object[])aUserVisibleParams.clone();
        }
    }

    public final void addContext(String aMsgId, String ... aContext) {
        StackTraceElement[] theStack = new Throwable().getStackTrace();
        StackTraceElement theFrame = theStack[1];
        this.gLoggableContextList.add(new MethodContext(this.formCaller(theFrame.getClassName(), theFrame.getMethodName()), aMsgId, aContext));
    }

    public final String getUserVisibleMessage() {
        String theUserVisibleMessage = "";
        if (this.gUserVisibleMsgKey != null) {
            theUserVisibleMessage = Msg.get(this.gUserVisibleMsgKey, this.gUserVisibleParams);
        }
        return theUserVisibleMessage;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public final void logRecovered() {
        StackTraceElement[] theStack = new Throwable().getStackTrace();
        this.log(theStack, true);
    }

    public final void logFatal() {
        StackTraceElement[] theStack = new Throwable().getStackTrace();
        this.log(theStack, false);
    }

    public final List<MethodContext> getContextList() {
        return this.gLoggableContextList;
    }

    protected final void log(StackTraceElement[] aStack, boolean aRecoveredFlag) {
        StackTraceElement theFrame = aStack[1];
        this.gLoggedClassName = theFrame.getClassName();
        this.gLoggedMethodName = theFrame.getMethodName();
        if (logger == null) {
            Logger.getAnonymousLogger().log(Level.WARNING, "NO_LOG_ADAPT_PROV_STDERR");
            this.logToAnon(aRecoveredFlag);
        } else {
            try {
                logger.logException(aRecoveredFlag, this);
            }
            catch (Throwable theThrowable) {
                Logger.getAnonymousLogger().log(Level.WARNING, "LOGGER_FAILED_WITH", theThrowable);
            }
        }
    }

    protected final void logToAnon(boolean aRecoveredFlag) {
        Logger theAnon = Logger.getAnonymousLogger();
        try {
            String theSeverity = aRecoveredFlag ? "Recovered" : "Fatal";
            theAnon.log(Level.WARNING, "*****");
            theAnon.log(Level.WARNING, this.gExceptionTime.toString() + " - " + theSeverity + " exception");
            if (this.gThrown != null) {
                theAnon.log(Level.WARNING, "    Caused By Exception=" + this.gThrown.getMessage(), this.gThrown);
            }
            ListIterator<MethodContext> theContexts = this.gLoggableContextList.listIterator();
            while (theContexts.hasNext()) {
                String[] theContextItems;
                MethodContext theMethodContext = (MethodContext)theContexts.next();
                theAnon.log(Level.WARNING, "        Method=" + theMethodContext.getMethod());
                theAnon.log(Level.WARNING, "        Operation=" + theMethodContext.getOperation());
                for (String theContextItem : theContextItems = theMethodContext.getContext()) {
                    theAnon.log(Level.WARNING, "            " + theContextItem);
                }
            }
            theAnon.log(Level.WARNING, "  ----");
        }
        catch (Throwable theEx) {
            theAnon.log(Level.WARNING, "*** Exception while handling exception ***");
            theAnon.log(Level.WARNING, theEx.toString());
        }
    }

    private static String getLocalizedContextMessage(MethodContext aCtx) {
        StringBuffer theResult = new StringBuffer();
        theResult.append(Msg.get(aCtx.getOperation(), new Object[0]));
        theResult.append(' ');
        for (String theCtx : aCtx.getContext()) {
            String[] theParts = theCtx.split("=", 2);
            if (theParts.length == 1) {
                theResult.append(Msg.get(theParts[0], new Object[0]));
                continue;
            }
            theResult.append(Msg.get(theParts[0], new Object[0]));
            theResult.append("=");
            theResult.append(theParts[1]);
            theResult.append(' ');
        }
        return theResult.toString();
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder theMsg = new StringBuilder();
        Iterator<MethodContext> theIt = this.getContextList().iterator();
        while (theIt.hasNext()) {
            theMsg.append(EnhancedException.getLocalizedContextMessage(theIt.next()));
            if (!theIt.hasNext()) continue;
            theMsg.append(": ");
        }
        Throwable theCause = this.getCause();
        if (theCause != null && this != theCause) {
            theMsg.append(Msg.get("CAUSED_BY", new Object[0]));
            theMsg.append(": ");
            theMsg.append(theCause.getLocalizedMessage());
        }
        return theMsg.toString();
    }

    @Override
    public final String toString() {
        StringBuffer theEx = new StringBuffer();
        theEx.append("Exception=");
        theEx.append(this.gLoggableMsgKey);
        theEx.append(EnhancedException.getStackAsString(this));
        if (this.getCause() != null) {
            theEx.append("Caused By=");
            theEx.append(this.getCause());
            theEx.append(EnhancedException.getStackAsString(this.getCause()));
        }
        theEx.append(" Context-Items=[");
        ListIterator<MethodContext> theContexts = this.gLoggableContextList.listIterator();
        while (theContexts.hasNext()) {
            String[] theContextItems;
            MethodContext theMethodContext = (MethodContext)theContexts.next();
            theEx.append("[method=");
            theEx.append(theMethodContext.getMethod());
            theEx.append(", ");
            theEx.append("operation=");
            theEx.append(theMethodContext.getOperation());
            for (String theContextItem : theContextItems = theMethodContext.getContext()) {
                theEx.append(", ");
                theEx.append(theContextItem);
            }
            theEx.append(']');
        }
        theEx.append(']');
        return theEx.toString();
    }

    public static String getStackAsString(Throwable aThrowable) {
        StringBuffer theStack = new StringBuffer();
        String theLb = System.getProperty("line.separator");
        if (theLb == null) {
            theLb = "\n";
        }
        theStack.append(theLb);
        theStack.append('[');
        theStack.append(theLb);
        for (StackTraceElement theElement : aThrowable.getStackTrace()) {
            theStack.append(" at ");
            theStack.append(theElement.getClassName());
            theStack.append('.');
            theStack.append(theElement.getMethodName());
            theStack.append('(');
            if (theElement.getMethodName() == null) {
                theStack.append('?');
            } else {
                theStack.append(theElement.getFileName());
            }
            theStack.append(':');
            if (theElement.getLineNumber() < 1) {
                theStack.append('?');
            } else {
                theStack.append(theElement.getLineNumber());
            }
            theStack.append(')');
            theStack.append(theLb);
        }
        theStack.append(']');
        theStack.append(theLb);
        return theStack.toString();
    }

    public static String getCompleteStack(Throwable aThrowable) {
        return EnhancedException.getCompleteStack(aThrowable, new ArrayList<Throwable>());
    }

    private static String getCompleteStack(Throwable aThrowable, List<Throwable> aVisitedList) {
        StringBuffer theEx = new StringBuffer();
        theEx.append("Exception=");
        theEx.append(aThrowable.getMessage());
        theEx.append(EnhancedException.getStackAsString(aThrowable));
        if (aThrowable.getCause() != null) {
            if (aVisitedList.contains(aThrowable.getCause())) {
                theEx.append("Detected infinite stack trace.  Terminating stack");
            } else {
                aVisitedList.add(aThrowable.getCause());
                theEx.append("Caused By=");
                theEx.append(EnhancedException.getCompleteStack(aThrowable.getCause(), aVisitedList));
            }
        }
        return theEx.toString();
    }

    protected final String formCaller(String aClassName, String aMethodName) {
        return aClassName + "." + aMethodName + "()";
    }

    public static void setLoggerAdapter(LoggerAdapter aAdapter) {
        logger = aAdapter;
    }

    public static LoggerAdapter getLoggerAdapter() {
        return logger;
    }

    public static Throwable getLastCause(Throwable aEx) {
        Throwable theCause = aEx;
        while (theCause.getCause() != null) {
            if ((theCause = theCause.getCause()) != aEx) continue;
            return theCause;
        }
        return theCause;
    }

    public static class MethodContext {
        private final String gMethod;
        private final String gOperation;
        private final String[] gContext;

        public MethodContext(String aMethod, String aOperation, String ... aContext) {
            this.gMethod = aMethod;
            this.gOperation = aOperation;
            this.gContext = (String[])aContext.clone();
        }

        public final String getMethod() {
            return this.gMethod;
        }

        public final String getOperation() {
            return this.gOperation;
        }

        public final String[] getContext() {
            return (String[])this.gContext.clone();
        }
    }
}

