/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;

public final class GetOpt {
    private int gOptind = 0;
    private String gOptarg = null;
    private String[] gArgv = null;
    private int gArgc = 0;
    private String gOptionString = null;
    private static final int MINUS_POSITION = 0;
    private int gOptionPosition = 1;
    private static final int AFTER_OPTION_POSITION = 2;

    public GetOpt(String[] aArgv, String aOptionString) {
        this.gArgv = (String[])aArgv.clone();
        this.gOptionString = aOptionString;
        this.gArgc = aArgv.length;
    }

    public int getNextOption() throws EnhancedException {
        if (this.gOptind >= this.gArgc || this.gArgv[this.gOptind].length() < 2 || this.gArgv[this.gOptind].charAt(0) != '-') {
            return -1;
        }
        char theCurrentOption = this.gArgv[this.gOptind].charAt(this.gOptionPosition);
        if (!this.isValidOption(theCurrentOption)) {
            ++this.gOptind;
            String theMsg = Msg.get(GetOpt.class, "ILLEGAL_OPTION", Character.valueOf(theCurrentOption));
            InvalidArgumentException theIae = new InvalidArgumentException(theMsg, new String[0]);
            throw new EnhancedException("ERROR_IN_GET_NEXT_OPTION", (Throwable)theIae, new String[0]);
        }
        if (this.isOptionArgAllowedByOption(theCurrentOption) && this.gOptionPosition == 1) {
            if (this.gArgv[this.gOptind].length() == 2) {
                if (this.gOptind + 1 >= this.gArgc) {
                    ++this.gOptind;
                    if (this.isOptionArgMandatoryByOption(theCurrentOption)) {
                        String theMsg = Msg.get(GetOpt.class, "OPTION_REQUIRES_ARG", Character.valueOf(theCurrentOption));
                        InvalidArgumentException theIae = new InvalidArgumentException(theMsg, new String[0]);
                        throw new EnhancedException("ERROR_IN_GET_NEXT_OPTION", (Throwable)theIae, new String[0]);
                    }
                } else if (this.gArgv[this.gOptind + 1].length() > 0 && this.gArgv[this.gOptind + 1].charAt(0) == '-' && this.isValidOption(this.gArgv[this.gOptind + 1].charAt(this.gOptionPosition))) {
                    ++this.gOptind;
                    if (this.isOptionArgMandatoryByOption(theCurrentOption)) {
                        String theMsg = Msg.get(GetOpt.class, "OPTION_REQUIRES_ARG", Character.valueOf(theCurrentOption));
                        InvalidArgumentException theIae = new InvalidArgumentException(theMsg, new String[0]);
                        throw new EnhancedException("ERROR_IN_GET_NEXT_OPTION", (Throwable)theIae, new String[0]);
                    }
                } else {
                    this.gOptarg = this.gArgv[++this.gOptind];
                    ++this.gOptind;
                }
            } else {
                this.gOptarg = this.gArgv[this.gOptind].substring(2);
                ++this.gOptind;
            }
            this.gOptionPosition = 1;
        } else {
            if (this.isOptionArgMandatoryByOption(theCurrentOption)) {
                String theMsg = Msg.get(GetOpt.class, "OPTION_CANNOT_GROUP", Character.valueOf(theCurrentOption));
                InvalidArgumentException theIae = new InvalidArgumentException(theMsg, new String[0]);
                throw new EnhancedException("ERROR_IN_GET_NEXT_OPTION", (Throwable)theIae, new String[0]);
            }
            if (this.gArgv[this.gOptind].length() == this.gOptionPosition + 1) {
                this.gOptionPosition = 1;
                ++this.gOptind;
            } else {
                ++this.gOptionPosition;
            }
        }
        return theCurrentOption;
    }

    public String getOptionArg() {
        return this.gOptarg;
    }

    private boolean isValidOption(char aChar) {
        return aChar != ':' && this.gOptionString.indexOf(aChar) != -1;
    }

    private boolean isOptionArgMandatoryByOption(char aOption) {
        return this.isValidOption(aOption) && this.gOptionString.length() > this.gOptionString.indexOf(aOption) + 1 && this.gOptionString.charAt(this.gOptionString.indexOf(aOption) + 1) == ':';
    }

    public int getNextOptionIndex() {
        return this.gOptind;
    }

    private boolean isOptionArgAllowedByOption(char aOption) {
        return this.isValidOption(aOption) && this.gOptionString.length() > this.gOptionString.indexOf(aOption) + 1 && (this.gOptionString.charAt(this.gOptionString.indexOf(aOption) + 1) == ':' || this.gOptionString.charAt(this.gOptionString.indexOf(aOption) + 1) == ';');
    }
}

