/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.Platform;

public final class BackendFactory {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final String BACKEND_BASE = "org.openinstaller.sims.backends.";
    private static final String BACKEND_NAME = "SIMSBackend";

    private BackendFactory() {
    }

    public static Backend getBackend(String aNativeDir) throws SIMSException {
        Backend theBackend = BackendFactory.discoverBackend();
        theBackend.setAttribute(Backend.Attribute.NATIVE_FILE_DIR, aNativeDir);
        theBackend.initialize();
        return theBackend;
    }

    private static Backend discoverBackend() throws SIMSException {
        String theOSName = Platform.getCurrentOsName().getValue().replaceAll("[\\s\\p{Punct}]", "_");
        String theOSTypeName = Platform.getCurrentOsType().getValue().replaceAll("[\\s\\p{Punct}]", "_");
        String thePkgFormat = "";
        try {
            BusRequest theReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.PKG_FORMAT));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            thePkgFormat = theResp.getResult().toString();
        }
        catch (Exception theEx) {
            throw new SIMSException(theEx, "CANNOT_DETERMINE_PACKAGEFORMAT", "os=" + theOSName);
        }
        Backend theBackend = BackendFactory.getBackendByClass(BACKEND_BASE + thePkgFormat.toLowerCase() + "." + theOSTypeName.toLowerCase() + "." + theOSName.toLowerCase() + "." + BACKEND_NAME);
        if (theBackend == null) {
            theBackend = BackendFactory.getBackendByClass(BACKEND_BASE + thePkgFormat.toLowerCase() + "." + theOSTypeName.toLowerCase() + "." + BACKEND_NAME);
        }
        if (theBackend == null) {
            theBackend = BackendFactory.getBackendByClass(BACKEND_BASE + thePkgFormat.toLowerCase() + "." + BACKEND_NAME);
        }
        if (theBackend == null) {
            throw new SIMSException("CANNOT_LOAD_SIMS_BACKEND", "platform=" + Platform.getCurrentPlatform(), "type=" + thePkgFormat);
        }
        return theBackend;
    }

    private static Backend getBackendByClass(String aName) {
        Class<?> theClass;
        Backend theBackend = null;
        try {
            LOGGER.log(Level.FINE, "LOADING_CLASS", aName);
            theClass = Class.forName(aName);
        }
        catch (ClassNotFoundException theCnfe) {
            LOGGER.log(Level.FINE, "Can't load SIMS backend " + aName, theCnfe);
            return null;
        }
        if (theClass == null) {
            LOGGER.log(Level.FINE, "Can't load SIMS backend " + aName);
            return null;
        }
        try {
            theBackend = (Backend)theClass.newInstance();
            LOGGER.log(Level.FINE, "loaded " + theBackend);
        }
        catch (InstantiationException theInste) {
            LOGGER.log(Level.FINE, "Can't load class " + aName, theInste);
        }
        catch (IllegalAccessException theIlae) {
            LOGGER.log(Level.FINE, "Can't load class " + aName, theIlae);
        }
        return theBackend;
    }
}

