/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class CompositeIcon
implements Icon,
SwingConstants {
    Icon fIcon1;
    Icon fIcon2;
    int fPosition;
    int fHorizontalOrientation;
    int fVerticalOrientation;

    public CompositeIcon(Icon icon1, Icon icon2) {
        this(icon1, icon2, 1);
    }

    public CompositeIcon(Icon icon1, Icon icon2, int position) {
        this(icon1, icon2, position, 0, 0);
    }

    public CompositeIcon(Icon icon1, Icon icon2, int position, int horizontalOrientation, int verticalOrientation) {
        this.fIcon1 = icon1;
        this.fIcon2 = icon2;
        this.fPosition = position;
        this.fHorizontalOrientation = horizontalOrientation;
        this.fVerticalOrientation = verticalOrientation;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (this.fPosition == 2 || this.fPosition == 4) {
            Icon rightIcon;
            Icon leftIcon;
            if (this.fPosition == 2) {
                leftIcon = this.fIcon1;
                rightIcon = this.fIcon2;
            } else {
                leftIcon = this.fIcon2;
                rightIcon = this.fIcon1;
            }
            this.paintIcon(c, g, leftIcon, x, y, width, height, 2, this.fVerticalOrientation);
            this.paintIcon(c, g, rightIcon, x + leftIcon.getIconWidth(), y, width, height, 2, this.fVerticalOrientation);
        } else if (this.fPosition == 1 || this.fPosition == 3) {
            Icon bottomIcon;
            Icon topIcon;
            if (this.fPosition == 1) {
                topIcon = this.fIcon1;
                bottomIcon = this.fIcon2;
            } else {
                topIcon = this.fIcon2;
                bottomIcon = this.fIcon1;
            }
            this.paintIcon(c, g, topIcon, x, y, width, height, this.fHorizontalOrientation, 1);
            this.paintIcon(c, g, bottomIcon, x, y + topIcon.getIconHeight(), width, height, this.fHorizontalOrientation, 1);
        } else {
            this.paintIcon(c, g, this.fIcon1, x, y, width, height, this.fHorizontalOrientation, this.fVerticalOrientation);
            this.paintIcon(c, g, this.fIcon2, x, y, width, height, this.fHorizontalOrientation, this.fVerticalOrientation);
        }
    }

    void paintIcon(Component c, Graphics g, Icon icon, int x, int y, int width, int height, int horizontalOrientation, int verticalOrientation) {
        int yIcon;
        int xIcon;
        switch (horizontalOrientation) {
            case 2: {
                xIcon = x;
                break;
            }
            case 4: {
                xIcon = x + width - icon.getIconWidth();
                break;
            }
            default: {
                xIcon = x + (width - icon.getIconWidth()) / 2;
            }
        }
        switch (verticalOrientation) {
            case 1: {
                yIcon = y;
                break;
            }
            case 3: {
                yIcon = y + height - icon.getIconHeight();
                break;
            }
            default: {
                yIcon = y + (height - icon.getIconHeight()) / 2;
            }
        }
        icon.paintIcon(c, g, xIcon, yIcon);
    }

    public int getIconWidth() {
        if (this.fPosition == 2 || this.fPosition == 4) {
            return this.fIcon1.getIconWidth() + this.fIcon2.getIconWidth();
        }
        return Math.max(this.fIcon1.getIconWidth(), this.fIcon2.getIconWidth());
    }

    public int getIconHeight() {
        if (this.fPosition == 1 || this.fPosition == 3) {
            return this.fIcon1.getIconHeight() + this.fIcon2.getIconHeight();
        }
        return Math.max(this.fIcon1.getIconHeight(), this.fIcon2.getIconHeight());
    }
}

