/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml.converters;

import charva.awt.BorderLayout;
import charva.awt.FlowLayout;
import charva.awt.GridBagLayout;
import charva.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.chaxml.Converter;
import org.chaxml.Localizer;
import org.chaxml.converters.PrimitiveConverter;
import org.chaxml.converters.Util;
import org.jdom.Attribute;

public class LayoutConverter
implements Converter {
    public static final Class TEMPLATE = LayoutManager.class;
    public static final String FLOW_LAYOUT = "flowlayout";
    public static final String BORDER_LAYOUT = "borderlayout";
    public static final String GRID_LAYOUT = "gridlayout";
    public static final String GRIDBAG_LAYOUT = "gridbaglayout";
    public static final String CARD_LAYOUT = "cardlayout";

    public Object convert(Class type, Attribute attr, Localizer localizer) {
        FlowLayout lm = null;
        StringTokenizer st = new StringTokenizer(attr.getValue(), "(,)");
        String s = st.nextToken().trim();
        if (s != null) {
            if ((s = s.toLowerCase()).equals(FLOW_LAYOUT)) {
                try {
                    if (st.hasMoreTokens()) {
                        Object o = PrimitiveConverter.conv(null, new Attribute("NA", st.nextToken()), localizer);
                        int[] para = Util.ia(st);
                        lm = para.length < 2 ? new FlowLayout(Integer.valueOf(o.toString()).intValue(), 0, 0) : new FlowLayout(Integer.valueOf(o.toString()).intValue(), para[0], para[1]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (lm == null) {
                    lm = new FlowLayout();
                }
            } else if (s.equals(BORDER_LAYOUT)) {
                int[] para = Util.ia(st);
                lm = new BorderLayout();
            } else if (s.equals(GRIDBAG_LAYOUT)) {
                lm = new GridBagLayout();
                if (st.hasMoreTokens()) {
                    try {
                        String fieldname = st.nextToken();
                        Field field = GridBagLayout.class.getField(fieldname);
                        if (field != null) {
                            Class<?> fieldtype = field.getType();
                            if (int[].class.equals(fieldtype)) {
                                field.set(lm, Util.ia(st));
                            } else if (double[].class.equals(fieldtype)) {
                                field.set(lm, Util.da(st));
                            }
                        }
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (SecurityException e) {
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
            }
        }
        return lm;
    }

    public Class convertsTo() {
        return TEMPLATE;
    }
}

