/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform.backends;

import java.util.logging.Logger;
import org.openinstaller.provider.platform.PlatformToolkit;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

public abstract class AbstractUnixPlatformToolkit
extends PlatformToolkit {
    protected String gNativeFileDir = null;
    protected static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public long getUsableDiskSpace(String aPath) throws EnhancedException {
        long theFreeSpace = 0L;
        String theScript = AbstractUnixPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"diskspace.sh");
        String theResult = " ";
        try {
            ExecuteCommand theCmd = new ExecuteCommand(new String[]{"sh", theScript, aPath});
            theCmd.setCollectOutput(true);
            theCmd.setOutputType(3);
            theCmd.execute();
            theResult = theCmd.getOutput();
            theResult = theResult.trim();
            if (null != theResult && !"".equals(theResult)) {
                theFreeSpace = Long.parseLong(theResult);
            }
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theEx, new String[]{"script=" + theScript});
        }
        catch (NumberFormatException theNFEx) {
            throw new EnhancedException("CANNOT_CONVERT_STRING_TO_LONG", (Throwable)theNFEx, new String[]{"string=" + theResult});
        }
        return theFreeSpace;
    }

    public long getSwapSpace() throws EnhancedException {
        long theSwapSize = 0L;
        String theScript = AbstractUnixPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"swapspace.sh");
        String theResult = " ";
        try {
            ExecuteCommand theCmd = new ExecuteCommand(new String[]{"sh", theScript});
            theCmd.setCollectOutput(true);
            theCmd.setOutputType(3);
            theCmd.execute();
            theResult = theCmd.getOutput();
            theResult = theResult.trim();
            if (null != theResult && !"".equals(theResult)) {
                theSwapSize = Long.parseLong(theResult);
            }
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theEx, new String[]{"script=" + theScript});
        }
        catch (NumberFormatException theNFEx) {
            throw new EnhancedException("CANNOT_CONVERT_STRING_TO_LONG", (Throwable)theNFEx, new String[]{"string=" + theResult});
        }
        return theSwapSize;
    }

    public long getPhysicalMemory() throws EnhancedException {
        long theRAM = 0L;
        String theScript = AbstractUnixPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"memory.sh");
        String theResult = " ";
        try {
            ExecuteCommand theCmd = new ExecuteCommand(new String[]{"sh", theScript});
            theCmd.setCollectOutput(true);
            theCmd.setOutputType(3);
            theCmd.execute();
            theResult = theCmd.getOutput();
            theResult = theResult.trim();
            if (null != theResult && !"".equals(theResult)) {
                theRAM = Long.parseLong(theResult);
            }
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theEx, new String[]{"script=" + theScript});
        }
        catch (NumberFormatException theNFEx) {
            throw new EnhancedException("CANNOT_CONVERT_STRING_TO_LONG", (Throwable)theNFEx, new String[]{"string=" + theResult});
        }
        return theRAM;
    }
}

