/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform.backends;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchCommandExecutor {
    private ArrayList<String> cmdList = new ArrayList();
    private ArrayList<String> patchPresentList = new ArrayList();
    private ArrayList<String> patchObsoletedList = new ArrayList();
    private HashMap patchIncompatiblesMap = new HashMap();
    private String[] command = null;
    private static final String patchKey = "Patch:";
    private static final String obsoletesKey = "Obsoletes:";
    private static final String requiresKey = "Requires:";
    private static final String incompatiblesKey = "Incompatibles:";

    public PatchCommandExecutor(String[] commandPassed) throws EnhancedException {
        this.command = commandPassed;
        try {
            this.bootstrap();
        }
        catch (Exception theEx) {
            throw new EnhancedException("SHELL_PATCH_COMMAND_NOT_EXECUTED", (Throwable)theEx, new String[0]);
        }
    }

    public void bootstrap() throws Exception {
        if (!this.isShowRevAvail()) {
            throw new Exception("showrev not available on system being tested - patch determination not possible");
        }
        this.cmdList = this.executePatchCmd();
        this.patchPresentList = this.createPatchPresentList();
        boolean retValue = false;
    }

    private boolean isShowRevAvail() {
        return true;
    }

    private ArrayList<String> executePatchCmd() throws Exception {
        String[] cmdOp = ExecuteCommand.executeScript((String[])this.command);
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < cmdOp.length; ++i) {
            retList.add(cmdOp[i]);
        }
        return retList;
    }

    private String getPatchNumber(String opLine, String srchStr) {
        String possiblePatch;
        int indxSrch = opLine.indexOf(srchStr);
        if (indxSrch == -1) {
            return "";
        }
        int substrStart = indxSrch + srchStr.length();
        if (substrStart >= opLine.length()) {
            return "";
        }
        String patchPlus = opLine.substring(substrStart);
        StringTokenizer stok = new StringTokenizer(patchPlus, " ");
        String resultStr = "";
        while (stok.hasMoreTokens() && (possiblePatch = stok.nextToken()).indexOf(":") == -1) {
            resultStr = resultStr + possiblePatch;
        }
        return resultStr;
    }

    public ArrayList<String> createPatchPresentList() {
        ArrayList<String> present = new ArrayList<String>();
        for (int j = 0; j < this.cmdList.size(); ++j) {
            String infoString = this.cmdList.get(j);
            String resultString = this.getPatchNumber(infoString, patchKey);
            if (resultString.length() <= 0) continue;
            present.add(resultString);
        }
        return present;
    }

    private String getPatchMajorVersion(String patchId) {
        int minidx = patchId.indexOf(45);
        if (minidx != -1) {
            return patchId.substring(0, patchId.indexOf(45));
        }
        return patchId;
    }

    private String getPatchMinorVersion(String patchId) {
        int minidx = patchId.indexOf(45);
        if (minidx != -1) {
            return patchId.substring(patchId.indexOf(45) + 1);
        }
        return "null";
    }

    public String checkPatchInstalled(String patchId) {
        String patchMajorVersion = this.getPatchMajorVersion(patchId);
        String patchMinorVersion = this.getPatchMinorVersion(patchId);
        ArrayList<String> present = this.createPatchPresentList();
        for (int i = 0; i < present.size(); ++i) {
            String presentPatchId = present.get(i);
            String majorVersion = this.getPatchMajorVersion(presentPatchId);
            String minorVersion = this.getPatchMinorVersion(presentPatchId);
            if (majorVersion == null || majorVersion.equals("") || !majorVersion.equalsIgnoreCase(patchMajorVersion)) continue;
            if (patchMinorVersion.equalsIgnoreCase("null") || minorVersion.equalsIgnoreCase(patchMinorVersion)) {
                return presentPatchId;
            }
            return "";
        }
        return "";
    }
}

