/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform.backends;

import java.util.ArrayList;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMCommandExecutor {
    private ArrayList<String> cmdCompleteList = new ArrayList();
    private ArrayList<String> cmdPartialList = new ArrayList();
    private ArrayList<String> packagePresentCompleteList = new ArrayList();
    private ArrayList<String> packagePresentPartialList = new ArrayList();

    public RPMCommandExecutor() throws EnhancedException {
        try {
            this.bootstrap();
        }
        catch (Exception theEx) {
            throw new EnhancedException("SHELL_PATCH_COMMAND_NOT_EXECUTED", (Throwable)theEx, new String[0]);
        }
    }

    public void bootstrap() throws Exception {
        this.cmdCompleteList = this.executePackageCompleteCmd();
        this.packagePresentCompleteList = this.cmdCompleteList;
    }

    private ArrayList<String> executePackageCompleteCmd() throws Exception {
        String[] cmdOp = ExecuteCommand.executeScript((String[])new String[]{"/bin/rpm", "-qa"});
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < cmdOp.length; ++i) {
            retList.add(cmdOp[i]);
        }
        return retList;
    }

    private ArrayList<String> executePackagePartialCmd() throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        return retList;
    }

    public ArrayList<String> createPackagePresentList() {
        return this.packagePresentCompleteList;
    }

    private ArrayList<String> createPackagePresentPartialList(ArrayList<String> cmdList) {
        ArrayList<String> partial = new ArrayList<String>();
        for (int j = 0; j < cmdList.size(); ++j) {
            String infoString = cmdList.get(j);
            String partialStr = this.getPackageName(infoString);
            if (partialStr.length() <= 0) continue;
            partial.add(partialStr);
        }
        return partial;
    }

    private String getPackageName(String opLine) {
        if (opLine == null || opLine.length() == 0) {
            return "";
        }
        int index = 0;
        char c = opLine.charAt(index);
        while (!this.isWhiteSpace(c)) {
            c = opLine.charAt(++index);
        }
        if (index == 0) {
            return "";
        }
        return opLine.substring(0, index);
    }

    private boolean isWhiteSpace(char c) {
        if (c == ' ') {
            return true;
        }
        return c == '\t';
    }

    private String isPackageInPresentCompleteList(String packageId) {
        for (int h = 0; h < this.packagePresentCompleteList.size(); ++h) {
            String presentPackageId = this.packagePresentCompleteList.get(h);
            if (!presentPackageId.startsWith(packageId)) continue;
            return presentPackageId;
        }
        return "";
    }

    private boolean isPackageInPresentPartialList(String packageId) {
        for (int h = 0; h < this.packagePresentPartialList.size(); ++h) {
            String presentPackageId = this.packagePresentPartialList.get(h);
            if (!packageId.equals(presentPackageId)) continue;
            return true;
        }
        return false;
    }

    public boolean isPartialPackage(String packageId) {
        return this.isPackageInPresentPartialList(packageId);
    }

    public String checkPackageInstalled(String packageId) {
        try {
            String[] Package2 = ExecuteCommand.executeScript((String[])new String[]{"/bin/rpm", "-q", packageId});
            return Package2[0];
        }
        catch (Exception exception) {
            return "";
        }
    }
}

