/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform.backends;

import java.io.IOException;
import java.util.ArrayList;
import org.openinstaller.provider.platform.backends.AbstractUnixPlatformToolkit;
import org.openinstaller.provider.platform.backends.PatchCommandExecutor;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarisPlatformToolkit
extends AbstractUnixPlatformToolkit {
    public void setNativeFileDir(String aDirName) {
        this.gNativeFileDir = aDirName;
    }

    public String[] getProcessorInfo() throws EnhancedException {
        String theScript = SolarisPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"processorspeed.sh");
        String[] theCPUSpeed = new String[]{};
        try {
            theCPUSpeed = ExecuteCommand.executeScript((String[])new String[]{"sh", theScript});
        }
        catch (IOException theIOEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theIOEx, new String[]{"script=" + theScript});
        }
        return theCPUSpeed;
    }

    public ArrayList<String> createPatchPresentList() throws EnhancedException {
        PatchCommandExecutor theExecutor = new PatchCommandExecutor(new String[]{"/usr/bin/showrev", "-p"});
        return theExecutor.createPatchPresentList();
    }

    public String checkPatchInstalled(String aPatchId) throws EnhancedException {
        boolean theFormatCheckResult = this.checkFormat(aPatchId);
        if (theFormatCheckResult) {
            PatchCommandExecutor theExecutor = new PatchCommandExecutor(new String[]{"/usr/bin/showrev", "-p"});
            return theExecutor.checkPatchInstalled(aPatchId);
        }
        return "";
    }

    public String getOSPatchLevel() throws EnhancedException {
        String theVer = "";
        try {
            String[] theOsVers = ExecuteCommand.executeScript((String[])new String[]{"/usr/bin/uname", "-v"});
            theVer = theOsVers[0];
        }
        catch (Exception theEx) {
            throw new EnhancedException("ERROR_GETTING_PATCH_LEVEL", new String[]{"Exception=", theEx.getMessage()});
        }
        String thePre = "Generic_";
        String theNoPatch = "Generic";
        int theIdx = theVer.indexOf("Generic_");
        if (theIdx != -1) {
            String thePatchVers = theVer.substring("Generic_".length());
            return thePatchVers;
        }
        if (theVer.equalsIgnoreCase("Generic")) {
            String thePatchVers = "00-00";
            return thePatchVers;
        }
        return theVer;
    }

    private boolean checkFormat(String aPatchId) {
        int thePatchLength = aPatchId.length();
        if (thePatchLength == 9) {
            int theIndexofHiphen = aPatchId.indexOf("-");
            return theIndexofHiphen == 6;
        }
        return thePatchLength == 6;
    }
}

