/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform.backends;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.platform.PlatformToolkit;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowsPlatformToolkit
extends PlatformToolkit {
    private static final Logger LOGGER = Logger.getLogger(WindowsPlatformToolkit.class.getName());
    private String gNativeFileDir;

    public void setNativeFileDir(String aDirName) {
        this.gNativeFileDir = aDirName;
    }

    public long getPhysicalMemory() throws EnhancedException {
        long theRAM = 0L;
        String theScript = WindowsPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"memory.vbs");
        String theResult = " ";
        try {
            ExecuteCommand theCmd = new ExecuteCommand(new String[]{"cscript", "//nologo", theScript});
            theCmd.setCollectOutput(true);
            theCmd.setOutputType(3);
            theCmd.execute();
            theResult = theCmd.getOutput();
            theResult = theResult.trim();
            if (null != theResult && !"".equals(theResult)) {
                theRAM = Long.parseLong(theResult);
            }
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theEx, new String[]{"script=" + theScript});
        }
        catch (NumberFormatException theNFEx) {
            throw new EnhancedException("CANNOT_CONVERT_STRING_TO_LONG", (Throwable)theNFEx, new String[]{"string=" + theResult});
        }
        return theRAM;
    }

    public String[] getProcessorInfo() throws EnhancedException {
        String theScript = WindowsPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"processorspeed.vbs");
        String[] theCPUSpeed = new String[]{};
        LOGGER.log(Level.FINEST, "Script-Path = [" + theScript + "]");
        try {
            theCPUSpeed = ExecuteCommand.executeScript((String[])new String[]{"cscript", "//nologo", theScript});
        }
        catch (IOException theIOEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theIOEx, new String[]{"script=" + theScript});
        }
        return theCPUSpeed;
    }

    public long getUsableDiskSpace(String aPath) throws EnhancedException {
        long theFreeSpace = 0L;
        long theDivisor = 1024L;
        String theScript = WindowsPlatformToolkit.getScriptPath((String)this.gNativeFileDir, (String)"diskspace.vbs");
        String theResult = " ";
        String theDriveLetter = this.getRoot(aPath);
        LOGGER.log(Level.FINEST, "Drive Letter = [" + theDriveLetter + "]");
        try {
            ExecuteCommand theCmd = new ExecuteCommand(new String[]{"cscript", "//nologo", theScript, theDriveLetter});
            theCmd.setCollectOutput(true);
            theCmd.setOutputType(3);
            theCmd.execute();
            theResult = theCmd.getOutput();
            theResult = theResult.trim();
            if (null != theResult && !"".equals(theResult)) {
                theFreeSpace = Long.parseLong(theResult);
            }
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("CANNOT_EXECUTE_SCRIPT", (Throwable)theEx, new String[]{"script=" + theScript});
        }
        catch (NumberFormatException theNFEx) {
            throw new EnhancedException("CANNOT_CONVERT_STRING_TO_LONG", (Throwable)theNFEx, new String[]{"string=" + theResult});
        }
        LOGGER.log(Level.FINEST, "Free Space on drive " + theDriveLetter + " =[" + theFreeSpace / 1024L + "]");
        return Math.round(theFreeSpace / 1024L);
    }

    public String getRoot(String aPath) throws EnhancedException {
        File thePathFile = new File(aPath).getAbsoluteFile();
        while (thePathFile.getParent() != null) {
            thePathFile = thePathFile.getParentFile();
        }
        for (File theRoot : File.listRoots()) {
            if (theRoot.compareTo(thePathFile) != 0) continue;
            LOGGER.log(Level.FINE, "The Windows root = [" + thePathFile + "]");
            String thePath = theRoot.getAbsolutePath();
            if (thePath.startsWith("\\\\")) {
                throw new EnhancedException("REMOTE_SYSTEM_PATH_SPECIFIED", new String[]{"path=" + thePath});
            }
            String[] thePathParts = thePath.split("\\\\");
            return thePathParts[0];
        }
        return null;
    }

    public ArrayList<String> createPatchPresentList() throws EnhancedException {
        throw new RuntimeException("Not implemented");
    }

    public String checkPatchInstalled(String aPatchId) throws EnhancedException {
        throw new RuntimeException("Not implemented");
    }

    public String getOSPatchLevel() {
        throw new RuntimeException("Not implemented");
    }

    public long getSwapSpace() {
        throw new RuntimeException("Not implemented");
    }
}

