/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private Locale locale = Locale.getDefault();
    private String bundleName;
    private ResourceBundle bundle;
    private ClassLoader cl = Localizer.class.getClassLoader();

    public String getString(String key) {
        String s;
        if (!this.isUsable()) {
            return key;
        }
        try {
            s = this.bundle.getString(key);
        }
        catch (Exception e) {
            s = key;
        }
        return s;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            this.bundle = null;
            this.bundleName = null;
        } else if (this.locale != locale) {
            this.locale = locale;
            this.setResourceBundle(this.bundleName);
        }
    }

    public void setResourceBundle(String bundleName) throws MissingResourceException {
        this.bundleName = bundleName;
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.bundle = bundleName != null ? ResourceBundle.getBundle(bundleName, this.locale, this.cl) : null;
    }

    public boolean isUsable() {
        return this.locale != null && this.bundle != null;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }
}

