/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.config.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.config.oor.schema.ComponentSchema;
import org.openinstaller.config.PropertySheet;
import org.openinstaller.provider.conf.OORUtils;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.GetOpt;

public final class Helper {
    public static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private Helper() {
    }

    public static void main(String[] aArgSet) {
        String theSchema = null;
        String theData = null;
        String theFile = null;
        OPERATION theOp = null;
        try {
            try {
                GetOpt theOptionParser = new GetOpt(aArgSet, "s:d:o:f:");
                int theOption = theOptionParser.getNextOption();
                while (theOption != -1) {
                    switch (theOption) {
                        case 115: {
                            theSchema = theOptionParser.getOptionArg();
                            break;
                        }
                        case 100: {
                            theData = theOptionParser.getOptionArg();
                            break;
                        }
                        case 111: {
                            theOp = OPERATION.valueOf(theOptionParser.getOptionArg().toUpperCase());
                            break;
                        }
                        case 102: {
                            theFile = theOptionParser.getOptionArg();
                            break;
                        }
                        default: {
                            LOGGER.log(Level.WARNING, "UNKNOWN_OPT", aArgSet[theOption]);
                        }
                    }
                    theOption = theOptionParser.getNextOption();
                }
                if (theSchema == null || theData == null || theOp == null) {
                    throw new EnhancedException("MUST_SPECIFY_ALL_PARAMS", new String[0]);
                }
                switch (theOp) {
                    case DECODE: {
                        Helper.doDecode(theSchema, theData, theFile);
                        break;
                    }
                    case ENCODE: {
                        break;
                    }
                    default: {
                        throw new EnhancedException("NO_OPERATION_SPECIFIED", new String[0]);
                    }
                }
            }
            catch (EnhancedException theEe) {
                theEe.addContext("HELPER_FAILED", new String[]{"args=" + Arrays.toString(aArgSet)});
                throw theEe;
            }
            catch (Exception theEx) {
                throw new EnhancedException("HELPER_FAILED", (Throwable)theEx, new String[]{"args=" + Arrays.toString(aArgSet)});
            }
        }
        catch (EnhancedException theEe) {
            theEe.logFatal();
            System.exit(1);
        }
    }

    private static void doDecode(String aSchema, String aData, String aFile) throws JAXBException, EnhancedException, IOException {
        ComponentSchema theComponentSchema;
        PropertySheet theProps = new PropertySheet();
        JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.schema");
        Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
        try {
            theComponentSchema = (ComponentSchema)theUnMarshaller.unmarshal(new URL(aSchema));
        }
        catch (MalformedURLException theEx) {
            theComponentSchema = (ComponentSchema)theUnMarshaller.unmarshal(new File(aSchema));
        }
        OORComponent theOORComp = OORUtils.createOORComponent((ComponentSchema)theComponentSchema);
        try {
            theProps.read(theOORComp, new URL(aData).openStream());
        }
        catch (MalformedURLException theEx) {
            theProps.read(theOORComp, new File(aData).toURI().toURL().openStream());
        }
        if (aFile == null) {
            System.out.println(theProps.getPackageName());
            System.out.println(theProps.getComponentName());
            Map<String, String> thePropVals = theProps.getAllProps();
            for (Map.Entry<String, String> theEntry : thePropVals.entrySet()) {
                System.out.println(theEntry.getKey());
                System.out.println(theEntry.getValue());
            }
        } else {
            FileWriter theWriter = new FileWriter(aFile);
            theWriter.write(theProps.getPackageName());
            theWriter.write("\n");
            theWriter.write(theProps.getComponentName());
            theWriter.write("\n");
            Map<String, String> thePropVals = theProps.getAllProps();
            for (Map.Entry<String, String> theEntry : thePropVals.entrySet()) {
                theWriter.write(theEntry.getKey());
                theWriter.write("\n");
                theWriter.write(theEntry.getValue());
                theWriter.write("\n");
            }
            theWriter.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OPERATION {
        DECODE,
        ENCODE;

    }
}

