/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.ColorPair;
import charva.awt.TerminfoCapabilityException;
import charva.awt.Toolkit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Color {
    private static final Log LOG = LogFactory.getLog(Color.class);
    private int _red;
    private int _green;
    private int _blue;
    public static final Color black = new Color(0, 0, 0);
    public static final Color red = new Color(255, 0, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color white = new Color(255, 255, 255);

    public Color(int red_, int green_, int blue_) {
        this._red = red_ != 0 ? 255 : 0;
        this._green = green_ != 0 ? 255 : 0;
        this._blue = blue_ != 0 ? 255 : 0;
    }

    public Color(int red_, int green_, int blue_, int alpha_) {
        this(red_, green_, blue_);
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public boolean equals(Object obj_) {
        if (obj_ == null) {
            return false;
        }
        if (!(obj_ instanceof Color)) {
            return false;
        }
        Color othercolor = (Color)obj_;
        if (this._red != othercolor._red) {
            return false;
        }
        if (this._green != othercolor._green) {
            return false;
        }
        return this._blue == othercolor._blue;
    }

    public int getCursesColor() {
        if (this._red != 0) {
            if (this._green != 0) {
                if (this._blue != 0) {
                    return Toolkit.WHITE;
                }
                return Toolkit.YELLOW;
            }
            if (this._blue != 0) {
                return Toolkit.MAGENTA;
            }
            return Toolkit.RED;
        }
        if (this._green != 0) {
            if (this._blue != 0) {
                return Toolkit.CYAN;
            }
            return Toolkit.GREEN;
        }
        if (this._blue != 0) {
            return Toolkit.BLUE;
        }
        return Toolkit.BLACK;
    }

    public String toString() {
        if (this._red != 0) {
            if (this._green != 0) {
                if (this._blue != 0) {
                    return "white";
                }
                return "cyan";
            }
            if (this._blue != 0) {
                return "magenta";
            }
            return "red";
        }
        if (this._green != 0) {
            if (this._blue != 0) {
                return "white";
            }
            return "green";
        }
        if (this._blue != 0) {
            return "blue";
        }
        return "black";
    }

    public static int getCursesColor(Color foreground_, Color background_) {
        if (!Toolkit.isColorEnabled) {
            return 0;
        }
        int curses_color_pair = 0;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit.hasColors()) {
                ColorPair color_pair = new ColorPair(foreground_, background_);
                curses_color_pair = toolkit.getColorPairIndex(color_pair);
            }
        }
        catch (TerminfoCapabilityException e) {
            LOG.warn((Object)("can't set color pair: foreground " + foreground_ + " background " + background_));
        }
        return curses_color_pair;
    }

    public static String getColorName(int colorval_) {
        if (colorval_ == Toolkit.BLACK) {
            return "black";
        }
        if (colorval_ == Toolkit.RED) {
            return "red";
        }
        if (colorval_ == Toolkit.GREEN) {
            return "green";
        }
        if (colorval_ == Toolkit.YELLOW) {
            return "yellow";
        }
        if (colorval_ == Toolkit.BLUE) {
            return "blue";
        }
        if (colorval_ == Toolkit.MAGENTA) {
            return "magenta";
        }
        if (colorval_ == Toolkit.CYAN) {
            return "cyan";
        }
        if (colorval_ == Toolkit.WHITE) {
            return "white";
        }
        return "UNKNOWN";
    }

    public static Color fromCursesColor(int colorval_) {
        if (colorval_ == Toolkit.BLACK) {
            return black;
        }
        if (colorval_ == Toolkit.RED) {
            return red;
        }
        if (colorval_ == Toolkit.GREEN) {
            return green;
        }
        if (colorval_ == Toolkit.YELLOW) {
            return yellow;
        }
        if (colorval_ == Toolkit.BLUE) {
            return blue;
        }
        if (colorval_ == Toolkit.MAGENTA) {
            return magenta;
        }
        if (colorval_ == Toolkit.CYAN) {
            return cyan;
        }
        if (colorval_ == Toolkit.WHITE) {
            return white;
        }
        return null;
    }
}

