/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Color;
import charva.awt.ColorPair;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.MouseEventInfo;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.TerminfoCapabilityException;
import charva.awt.Window;
import charva.awt.event.FocusEvent;
import charva.awt.event.GarbageCollectionEvent;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Toolkit {
    private static final Log LOG = LogFactory.getLog(Toolkit.class);
    private static Toolkit _instance = null;
    private static FocusEvent _lastFocusEvent = null;
    private Vector _windowList = new Vector();
    private Vector _colorPairs = new Vector();
    private EventQueue _evtQueue;
    private static PrintStream _scriptPrintStream = null;
    private long _prevTimeMillis = 0L;
    private long _lastMousePressTime;
    private long _lastMouseClickTime;
    public static final char Auml = '\u00c4';
    public static final char Ccedil = '\u00c7';
    public static final char Eacute = '\u00c9';
    public static final char Euml = '\u00cb';
    public static final char Ouml = '\u00d6';
    public static final char Uuml = '\u00dc';
    public static final boolean isColorEnabled;
    private StringBuffer scriptbuffer = new StringBuffer();
    public static final int A_NORMAL;
    public static final int A_STANDOUT;
    public static final int A_UNDERLINE;
    public static final int A_REVERSE;
    public static final int A_BLINK;
    public static final int A_DIM;
    public static final int A_BOLD;
    public static final int A_ALTCHARSET;
    public static final int A_INVIS;
    public static final int ACS_ULCORNER;
    public static final int ACS_LLCORNER;
    public static final int ACS_URCORNER;
    public static final int ACS_LRCORNER;
    public static final int ACS_LTEE;
    public static final int ACS_RTEE;
    public static final int ACS_BTEE;
    public static final int ACS_TTEE;
    public static final int ACS_HLINE;
    public static final int ACS_VLINE;
    public static final int ACS_PLUS;
    public static final int ACS_S1;
    public static final int ACS_S9;
    public static final int ACS_DIAMOND;
    public static final int ACS_CKBOARD;
    public static final int ACS_DEGREE;
    public static final int ACS_PLMINUS;
    public static final int ACS_BULLET;
    public static final int BLACK;
    public static final int RED;
    public static final int GREEN;
    public static final int YELLOW;
    public static final int BLUE;
    public static final int MAGENTA;
    public static final int CYAN;
    public static final int WHITE;
    public static Color _defaultForeground;
    public static Color _defaultBackground;
    public static final int KEY_MOUSE = 409;
    public static final int BUTTON1_RELEASED = 1;
    public static final int BUTTON1_PRESSED = 2;
    public static final int BUTTON1_CLICKED = 4;
    public static final int BUTTON2_RELEASED = 64;
    public static final int BUTTON2_PRESSED = 128;
    public static final int BUTTON2_CLICKED = 256;
    public static final int BUTTON3_RELEASED = 4096;
    public static final int BUTTON3_PRESSED = 8192;
    public static final int BUTTON3_CLICKED = 16384;

    private Toolkit() {
        this._evtQueue = EventQueue.getInstance();
        if (this.hasColors() && isColorEnabled) {
            this.startColors();
            this._colorPairs.add(new ColorPair(_defaultForeground, _defaultBackground));
        }
    }

    public static Toolkit getDefaultToolkit() {
        if (_instance == null) {
            _instance = new Toolkit();
        }
        return _instance;
    }

    public EventQueue getSystemEventQueue() {
        return this._evtQueue;
    }

    public Window getTopWindow() {
        return (Window)this._windowList.lastElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWindowDisplayed(Window window_) {
        boolean answer = false;
        Vector vector = this._windowList;
        synchronized (vector) {
            for (int i = 0; i < this._windowList.size(); ++i) {
                Window w = (Window)this._windowList.elementAt(i);
                if (w != window_) continue;
                answer = true;
                break;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireKeystroke(int key_) {
        Component currentFocus;
        Vector vector = this._windowList;
        synchronized (vector) {
            Window sourcewin = this.getTopWindow();
            currentFocus = sourcewin.getCurrentFocus();
            while (currentFocus instanceof Container) {
                currentFocus = ((Container)currentFocus).getCurrentFocus();
            }
        }
        this.fireKeystroke(key_, currentFocus);
    }

    public void fireKeystroke(int key_, Component source_) {
        int id = Toolkit.isActionKey(key_) ? 2 : 1;
        this._evtQueue.postEvent(new KeyEvent(key_, id, source_));
    }

    public FocusEvent getLastFocusEvent() {
        return _lastFocusEvent;
    }

    protected void setLastFocusEvent(FocusEvent ev_) {
        _lastFocusEvent = ev_;
    }

    public void fireMouseEvent(MouseEventInfo mouse_info) {
        Component component;
        Window top_window = this.getTopWindow();
        Point origin = top_window.getLocation();
        int x = mouse_info.x;
        int y = mouse_info.y;
        int button = 0;
        int modifiers = 0;
        switch (mouse_info.button) {
            case 2: {
                button = 1;
                modifiers = 100;
                break;
            }
            case 1: {
                button = 1;
                modifiers = 101;
                break;
            }
            case 128: {
                button = 2;
                modifiers = 100;
                break;
            }
            case 64: {
                button = 2;
                modifiers = 101;
                break;
            }
            case 8192: {
                button = 3;
                modifiers = 100;
                break;
            }
            case 4096: {
                button = 3;
                modifiers = 101;
            }
        }
        if (!top_window.contains(x, y)) {
            if (modifiers == 100) {
                this.beep();
            }
            return;
        }
        if (modifiers == 100) {
            this._lastMousePressTime = System.currentTimeMillis();
        }
        if ((component = top_window.getComponentAt(x - origin.x, y - origin.y)) != null) {
            this._evtQueue.postEvent(new MouseEvent(component, modifiers, x, y, 0, button));
            long current_time = System.currentTimeMillis();
            if (modifiers == 101 && current_time - this._lastMousePressTime < 400L) {
                this._evtQueue.postEvent(new MouseEvent(component, 102, x, y, 1, button));
                if (current_time - this._lastMouseClickTime < 500L) {
                    this._evtQueue.postEvent(new MouseEvent(component, 102, x, y, 2, button));
                }
                this._lastMouseClickTime = current_time;
            }
        }
    }

    public void checkForKeystroke() {
        int key = this.readKey();
        MouseEventInfo mouse_info = null;
        if (key == -1) {
            return;
        }
        if (key == 10 || key == 13) {
            key = 343;
        } else if (key == 8) {
            key = 263;
        }
        if (key == 409) {
            mouse_info = this.getMouseEventInfo();
            this.fireMouseEvent(mouse_info);
        } else {
            this.fireKeystroke(key);
        }
        if (_scriptPrintStream != null) {
            this.scriptbuffer.setLength(0);
            long current = System.currentTimeMillis();
            long elapsed = 1000L;
            if (this._prevTimeMillis != 0L) {
                elapsed = current - this._prevTimeMillis;
            }
            this._prevTimeMillis = current;
            this.scriptbuffer.append(elapsed).append(" ");
            if (key == 409) {
                this.scriptbuffer.append("MOUSE ").append(" ").append(mouse_info.getButton()).append(" ").append(mouse_info.getX()).append(" ").append(mouse_info.getY());
            } else {
                this.scriptbuffer.append("KEY ");
                this.scriptbuffer.append(Integer.toHexString(key));
                this.scriptbuffer.append(" ");
                this.scriptbuffer.append(Toolkit.key2ASCII(key));
            }
            _scriptPrintStream.println(this.scriptbuffer.toString());
        }
    }

    public static String key2ASCII(int key_) {
        StringBuffer buf = new StringBuffer();
        if (key_ < 32) {
            buf.append("^");
            buf.append((char)(key_ + 64));
        } else if (key_ == 32) {
            buf.append("SPACE");
        } else if (key_ < 127) {
            buf.append((char)key_);
        } else {
            switch (key_) {
                case 258: {
                    buf.append("VK_DOWN");
                    break;
                }
                case 259: {
                    buf.append("VK_UP");
                    break;
                }
                case 260: {
                    buf.append("VK_LEFT");
                    break;
                }
                case 261: {
                    buf.append("VK_RIGHT");
                    break;
                }
                case 262: {
                    buf.append("VK_HOME");
                    break;
                }
                case 263: {
                    buf.append("VK_BACK_SPACE");
                    break;
                }
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 278: 
                case 279: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 284: {
                    buf.append("VK_F");
                    int c = 1 + key_ - 265;
                    buf.append(c);
                    break;
                }
                case 330: {
                    buf.append("VK_DELETE");
                    break;
                }
                case 331: {
                    buf.append("VK_INSERT");
                    break;
                }
                case 338: {
                    buf.append("VK_PAGE_DOWN");
                    break;
                }
                case 339: {
                    buf.append("VK_PAGE_UP");
                    break;
                }
                case 343: {
                    buf.append("VK_ENTER");
                    break;
                }
                case 353: {
                    buf.append("VK_BACK_TAB");
                    break;
                }
                case 360: {
                    buf.append("VK_END");
                    break;
                }
                default: {
                    buf.append("UNKNOWN");
                }
            }
        }
        return buf.toString();
    }

    public native void close();

    public native void clear();

    public void setCursor(Point p) {
        this.setCursor(p.x, p.y);
    }

    public native void setCursor(int var1, int var2);

    public Point getCursor() {
        int x = this.getx();
        int y = this.gety();
        return new Point(x, y);
    }

    public Point getCursor(Point p_) {
        p_.x = this.getx();
        p_.y = this.gety();
        return p_;
    }

    public native void addChar(int var1, int var2, int var3);

    public native void addHorizontalLine(int var1, int var2, int var3);

    public native void addVerticalLine(int var1, int var2, int var3);

    public native void addString(String var1, int var2, int var3);

    public void drawBox(Point origin_, Dimension size_) {
        this.drawBoxNative(origin_.x, origin_.y, origin_.x + size_.width - 1, origin_.y + size_.height - 1, 0);
    }

    public void drawBox(Point origin_, Dimension size_, int colorpair_) {
        this.drawBoxNative(origin_.x, origin_.y, origin_.x + size_.width - 1, origin_.y + size_.height - 1, colorpair_);
    }

    public native void drawBoxNative(int var1, int var2, int var3, int var4, int var5);

    public void blankBox(Point origin_, Dimension size_) {
        this.blankBoxNative(origin_.x, origin_.y, origin_.x + size_.width - 1, origin_.y + size_.height - 1, 0);
    }

    public void blankBox(Point origin_, Dimension size_, int colorpair_) {
        this.blankBoxNative(origin_.x, origin_.y, origin_.x + size_.width - 1, origin_.y + size_.height - 1, colorpair_);
    }

    public native void blankBoxNative(int var1, int var2, int var3, int var4, int var5);

    public void setClipRect(Rectangle clip_) {
        this.setClipRectNative(clip_.getLeft(), clip_.getTop(), clip_.getRight(), clip_.getBottom());
    }

    public native void setClipRectNative(int var1, int var2, int var3, int var4);

    public native void resetClipRect();

    public native void beep();

    public native int getScreenRows();

    public native int getScreenColumns();

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenColumns(), this.getScreenRows());
    }

    public native boolean hasColors();

    public native int getMaxColorPairs();

    public native void startColors();

    public int getColorPairIndex(ColorPair pair_) throws TerminfoCapabilityException {
        int index = this._colorPairs.indexOf(pair_);
        if (index != -1) {
            return index;
        }
        if (this._colorPairs.size() == this.getMaxColorPairs()) {
            throw new TerminfoCapabilityException("max number of color pairs (" + this.getMaxColorPairs() + ") exceeded");
        }
        index = this._colorPairs.size();
        this._colorPairs.add(pair_);
        this.initColorPair(index, pair_.getForeground(), pair_.getBackground());
        return index;
    }

    public native void sync();

    public native void redrawWin();

    public native String getStringCapability(String var1) throws TerminfoCapabilityException;

    public native int getNumericCapability(String var1) throws TerminfoCapabilityException;

    public native boolean getBooleanCapability(String var1) throws TerminfoCapabilityException;

    public native void putp(String var1);

    public native void print(String var1) throws TerminfoCapabilityException;

    public native void initColorPair(int var1, int var2, int var3) throws TerminfoCapabilityException;

    public static int COLOR_PAIR_ATTRIBUTE(int pair_) {
        return pair_ << 8;
    }

    public native String getTtyName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWindow(Window window_) {
        Vector vector = this._windowList;
        synchronized (vector) {
            this._windowList.add(window_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWindow(Window window_) {
        Vector vector = this._windowList;
        synchronized (vector) {
            if (!this._windowList.remove(window_)) {
                throw new RuntimeException("trying to remove window not in windowlist");
            }
        }
    }

    Vector getWindowList() {
        return this._windowList;
    }

    static native int getColor(int var0);

    public static void setDefaultForeground(Color color_) {
        _defaultForeground = color_;
    }

    public static Color getDefaultForeground() {
        return _defaultForeground;
    }

    public static void setDefaultBackground(Color color_) {
        _defaultBackground = color_;
    }

    public static Color getDefaultBackground() {
        return _defaultBackground;
    }

    public void triggerGarbageCollection(Component source_) {
        this._evtQueue.postEvent(new GarbageCollectionEvent(source_));
    }

    public native MouseEventInfo getMouseEventInfo();

    private native int readKey();

    private static native void init();

    private native int getx();

    private native int gety();

    private static native int getAttribute(int var0);

    private static native int getACSchar(int var0);

    public static boolean isActionKey(int _key) {
        boolean value = false;
        if (_key == 27) {
            value = true;
        }
        if (_key == 258) {
            value = true;
        }
        if (_key == 259) {
            value = true;
        }
        if (_key == 260) {
            value = true;
        }
        if (_key == 261) {
            value = true;
        }
        if (_key == 262) {
            value = true;
        }
        if (_key == 263) {
            value = true;
        }
        if (_key == 265) {
            value = true;
        }
        if (_key == 266) {
            value = true;
        }
        if (_key == 267) {
            value = true;
        }
        if (_key == 268) {
            value = true;
        }
        if (_key == 269) {
            value = true;
        }
        if (_key == 270) {
            value = true;
        }
        if (_key == 271) {
            value = true;
        }
        if (_key == 272) {
            value = true;
        }
        if (_key == 273) {
            value = true;
        }
        if (_key == 274) {
            value = true;
        }
        if (_key == 275) {
            value = true;
        }
        if (_key == 276) {
            value = true;
        }
        if (_key == 277) {
            value = true;
        }
        if (_key == 278) {
            value = true;
        }
        if (_key == 279) {
            value = true;
        }
        if (_key == 280) {
            value = true;
        }
        if (_key == 281) {
            value = true;
        }
        if (_key == 282) {
            value = true;
        }
        if (_key == 283) {
            value = true;
        }
        if (_key == 284) {
            value = true;
        }
        if (_key == 330) {
            value = true;
        }
        if (_key == 331) {
            value = true;
        }
        if (_key == 338) {
            value = true;
        }
        if (_key == 339) {
            value = true;
        }
        if (_key == 343) {
            value = true;
        }
        if (_key == 353) {
            value = true;
        }
        if (_key == 360) {
            value = true;
        }
        return value;
    }

    static {
        String scriptfilename = System.getProperty("charva.script.record");
        if (scriptfilename != null) {
            try {
                _scriptPrintStream = new PrintStream(new FileOutputStream(scriptfilename));
            }
            catch (FileNotFoundException ef) {
                LOG.warn((Object)("Cannot open script file \"" + scriptfilename + "\" for writing"));
                System.exit(1);
            }
        }
        System.loadLibrary("Terminal");
        Toolkit.init();
        isColorEnabled = System.getProperty("charva.color") != null;
        A_NORMAL = Toolkit.getAttribute(0);
        A_STANDOUT = Toolkit.getAttribute(1);
        A_UNDERLINE = Toolkit.getAttribute(2);
        A_REVERSE = Toolkit.getAttribute(3);
        A_BLINK = Toolkit.getAttribute(4);
        A_DIM = Toolkit.getAttribute(5);
        A_BOLD = Toolkit.getAttribute(6);
        A_ALTCHARSET = Toolkit.getAttribute(7);
        A_INVIS = Toolkit.getAttribute(8);
        ACS_ULCORNER = Toolkit.getACSchar(0);
        ACS_LLCORNER = Toolkit.getACSchar(1);
        ACS_URCORNER = Toolkit.getACSchar(2);
        ACS_LRCORNER = Toolkit.getACSchar(3);
        ACS_LTEE = Toolkit.getACSchar(4);
        ACS_RTEE = Toolkit.getACSchar(5);
        ACS_BTEE = Toolkit.getACSchar(6);
        ACS_TTEE = Toolkit.getACSchar(7);
        ACS_HLINE = Toolkit.getACSchar(8);
        ACS_VLINE = Toolkit.getACSchar(9);
        ACS_PLUS = Toolkit.getACSchar(10);
        ACS_S1 = Toolkit.getACSchar(11);
        ACS_S9 = Toolkit.getACSchar(12);
        ACS_DIAMOND = Toolkit.getACSchar(13);
        ACS_CKBOARD = Toolkit.getACSchar(14);
        ACS_DEGREE = Toolkit.getACSchar(15);
        ACS_PLMINUS = Toolkit.getACSchar(16);
        ACS_BULLET = Toolkit.getACSchar(17);
        BLACK = Toolkit.getColor(0);
        RED = Toolkit.getColor(1);
        GREEN = Toolkit.getColor(2);
        YELLOW = Toolkit.getColor(3);
        BLUE = Toolkit.getColor(4);
        MAGENTA = Toolkit.getColor(5);
        CYAN = Toolkit.getColor(6);
        WHITE = Toolkit.getColor(7);
        _defaultForeground = Color.white;
        _defaultBackground = Color.black;
    }
}

