/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Adjustable;
import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.EventQueue;
import charva.awt.Frame;
import charva.awt.PlaybackThread;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.SyncQueue;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.AdjustmentEvent;
import charva.awt.event.GarbageCollectionEvent;
import charva.awt.event.InvocationEvent;
import charva.awt.event.PaintEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.SyncEvent;
import charva.awt.event.WindowEvent;
import charva.awt.event.WindowListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Window
extends Container
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Window.class);
    private Window _owner;
    protected Toolkit _term;
    private boolean _windowClosed = false;
    private Vector _windowListeners = null;
    private static boolean _dispatchThreadRunning = false;

    public Window(Window owner_) {
        this._owner = owner_;
        this.init();
    }

    public Window(Frame owner_) {
        this._owner = owner_;
        this.init();
    }

    private void init() {
        this._term = Toolkit.getDefaultToolkit();
        this._layoutMgr = new BorderLayout();
        this._visible = false;
        if (this._owner != null) {
            super.setForeground(this._owner.getForeground());
            super.setBackground(this._owner.getBackground());
        } else {
            super.setForeground(Toolkit.getDefaultForeground());
            super.setBackground(Toolkit.getDefaultBackground());
        }
    }

    public Window getOwner() {
        return this._owner;
    }

    public void addWindowListener(WindowListener listener_) {
        if (this._windowListeners == null) {
            this._windowListeners = new Vector();
        }
        this._windowListeners.add(listener_);
    }

    protected void processWindowEvent(WindowEvent evt_) {
        if (this._windowListeners == null) {
            return;
        }
        Enumeration e = this._windowListeners.elements();
        while (e.hasMoreElements()) {
            WindowListener wl = (WindowListener)e.nextElement();
            switch (evt_.getID()) {
                case 3: {
                    wl.windowClosing(evt_);
                    break;
                }
                case 4: {
                    wl.windowOpened(evt_);
                }
            }
        }
    }

    public boolean isDisplayed() {
        return this._term.isWindowDisplayed(this);
    }

    public void pack() {
        this.setSize(this.minimumSize());
        super.doLayout();
    }

    public void show() {
        if (this._visible) {
            return;
        }
        this._visible = true;
        this._term.addWindow(this);
        super.doLayout();
        this.adjustLocation();
        this.draw();
        SyncQueue.getInstance().postEvent(new SyncEvent(this));
        if (_dispatchThreadRunning) {
            this.run();
        } else {
            _dispatchThreadRunning = true;
            Thread dispatchThread = new Thread(this);
            dispatchThread.setName("event dispatcher");
            dispatchThread.start();
            this.startPlayback();
        }
    }

    public void run() {
        EventQueue evtQueue = this._term.getSystemEventQueue();
        try {
            this._windowClosed = false;
            while (!this._windowClosed) {
                this._term.checkForKeystroke();
                while (!evtQueue.queuesAreEmpty()) {
                    AWTEvent evt = evtQueue.getNextEvent();
                    this.processEvent(evt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(AWTEvent evt_) {
        Object source = evt_.getSource();
        if (evt_ instanceof AdjustmentEvent) {
            ((Adjustable)source).processAdjustmentEvent((AdjustmentEvent)evt_);
        } else if (evt_ instanceof ScrollEvent) {
            ((Scrollable)source).processScrollEvent((ScrollEvent)evt_);
            this.requestFocus();
            super.requestSync();
        } else if (evt_ instanceof PaintEvent) {
            if (!((Component)source).isTotallyObscured()) {
                Vector windowlist;
                Vector vector = windowlist = this._term.getWindowList();
                synchronized (vector) {
                    int i;
                    Window ancestor = ((Component)source).getAncestorWindow();
                    if (ancestor != null) {
                        ancestor.draw();
                    }
                    Window w = null;
                    for (i = 0; i < windowlist.size() && (w = (Window)windowlist.elementAt(i)) != ancestor; ++i) {
                    }
                    while (i < windowlist.size()) {
                        w = (Window)windowlist.elementAt(i);
                        w.draw();
                        ++i;
                    }
                }
                super.requestSync();
            }
        } else if (evt_ instanceof SyncEvent) {
            this._term.sync();
        } else if (evt_ instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)evt_;
            we.getWindow().processWindowEvent(we);
            if (we.getID() == 3) {
                we.getWindow()._windowClosed = true;
                this._term.removeWindow(we.getWindow());
                this._term.blankBox(this._origin, this._size);
                Vector winlist = this._term.getWindowList();
                Container window = null;
                Vector vector = winlist;
                synchronized (vector) {
                    for (int i = 0; i < winlist.size(); ++i) {
                        window = (Window)winlist.elementAt(i);
                        ((Window)window).draw();
                    }
                    if (window != null) {
                        window.requestFocus();
                    }
                }
                if (window != null) {
                    SyncQueue.getInstance().postEvent(new SyncEvent(window));
                }
            }
        } else if (evt_ instanceof GarbageCollectionEvent) {
            SyncQueue.getInstance().postEvent(evt_);
        } else if (evt_ instanceof InvocationEvent) {
            ((InvocationEvent)evt_).dispatch();
        } else {
            ((Component)source).processEvent(evt_);
        }
    }

    public void hide() {
        if (!this._visible) {
            LOG.warn((Object)("Trying to hide window " + this + " that is already hidden!"));
            return;
        }
        this._visible = false;
        WindowEvent we = new WindowEvent(this, 3);
        this._term.getSystemEventQueue().postEvent(we);
    }

    public void draw() {
        super.draw();
        this.requestFocus();
    }

    public Point getLocationOnScreen() {
        return new Point(this._origin);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void adjustLocation() {
        int right;
        int bottom = this._origin.y + this.getHeight();
        if (bottom > this._term.getScreenRows()) {
            this._origin.y -= bottom - this._term.getScreenRows();
        }
        if (this._origin.y < 0) {
            this._origin.y = 0;
        }
        if ((right = this._origin.x + this.getWidth()) > this._term.getScreenColumns()) {
            this._origin.x -= right - this._term.getScreenColumns();
        }
        if (this._origin.x < 0) {
            this._origin.x = 0;
        }
    }

    public void debug(int level_) {
        LOG.debug((Object)("Window origin=" + this._origin + " size=" + this._size));
        super.debug(1);
    }

    private void startPlayback() {
        String scriptfilename = System.getProperty("charva.script.playbackFile");
        if (scriptfilename == null) {
            return;
        }
        File scriptFile = new File(scriptfilename);
        if (!scriptFile.canRead()) {
            LOG.warn((Object)("Cannot read script tile \"" + scriptfilename + "\""));
            return;
        }
        PlaybackThread thr = new PlaybackThread(scriptFile);
        thr.setDaemon(true);
        thr.setName("playback thread");
        thr.start();
    }
}

