/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charvax.swing.Action;
import charvax.swing.ArrayTable;
import charvax.swing.Icon;
import charvax.swing.event.SwingPropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private transient ArrayTable arrayTable;
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String name) {
        this.putValue("Name", name);
    }

    public AbstractAction(String name, Icon icon) {
        this(name);
        this.putValue("SmallIcon", icon);
    }

    public Object getValue(String key) {
        if (this.arrayTable == null) {
            return null;
        }
        return this.arrayTable.get(key);
    }

    public void putValue(String key, Object newValue) {
        Object oldValue = null;
        if (this.arrayTable == null) {
            this.arrayTable = new ArrayTable();
        }
        if (this.arrayTable.containsKey(key)) {
            oldValue = this.arrayTable.get(key);
        }
        if (newValue == null) {
            this.arrayTable.remove(key);
        } else {
            this.arrayTable.put(key, newValue);
        }
        this.firePropertyChange(key, oldValue, newValue);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        if (oldValue != newValue) {
            this.enabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    public Object[] getKeys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] keys = new Object[this.arrayTable.size()];
        this.arrayTable.getKeys(keys);
        return keys;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        AbstractAction newAction = (AbstractAction)super.clone();
        AbstractAction abstractAction = this;
        synchronized (abstractAction) {
            if (this.arrayTable != null) {
                newAction.arrayTable = (ArrayTable)this.arrayTable.clone();
            }
        }
        return newAction;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ArrayTable.writeArrayTable(s, this.arrayTable);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        for (int counter = s.readInt() - 1; counter >= 0; --counter) {
            this.putValue((String)s.readObject(), s.readObject());
        }
    }
}

