/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ItemEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.AbstractButton;

public class JButton
extends AbstractButton {
    public JButton() {
        this("");
    }

    public JButton(String text_) {
        super.setText(text_);
        super.setActionCommand(text_);
    }

    public void setLabel(String label_) {
        this.setText(label_);
    }

    public void setText(String label_) {
        super.setText(label_);
        this.repaint();
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return super.getLabelString().length() + 2 + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit term = Toolkit.getDefaultToolkit();
        term.setCursor(origin);
        int colorpair = this.getCursesColor();
        if (super.isEnabled()) {
            int mnemonicPos;
            term.addString(" ", Toolkit.A_REVERSE, colorpair);
            term.addString(super.getLabelString(), Toolkit.A_REVERSE, colorpair);
            term.addString(" ", Toolkit.A_REVERSE, colorpair);
            if (super.getMnemonic() > 0 && (mnemonicPos = super.getLabelString().indexOf((char)super.getMnemonic())) != -1) {
                term.setCursor(origin.addOffset(1 + mnemonicPos, 0));
                term.addChar(super.getMnemonic(), Toolkit.A_UNDERLINE | Toolkit.A_REVERSE, colorpair);
            }
        } else {
            term.addString("<", 0, colorpair);
            term.addString(this.getText(), 0, colorpair);
            term.addString(">", 0, colorpair);
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (super.isEnabled() && key == 343) {
            EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            queue.postEvent(new ItemEvent(this, this, 100));
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(1 + insets.left, 0 + insets.top));
    }

    public String toString() {
        return "JButton location=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\"";
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JButton origin=" + this._origin + " size=" + this.getSize() + " label=" + super.getText());
    }
}

