/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Insets;
import charva.awt.Point;
import charvax.swing.border.Border;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public abstract class JComponent
extends Component {
    protected int gRowCount = 0;
    protected int gColumnCount = 0;
    protected int gTotalWidth = 0;
    protected boolean isHTMLTable = false;
    protected Map<String, String> gTableData = new HashMap<String, String>();
    protected Border _border = null;
    protected Hashtable _clientProperties = null;

    public void setBorder(Border border_) {
        this._border = border_;
    }

    public Border getBorder() {
        return this._border;
    }

    public Insets getInsets() {
        if (this._border != null) {
            return this._border.getBorderInsets(this);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        if (this._border != null) {
            this._border.paintBorder(this, 0, origin.x, origin.y, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putClientProperty(Object key, Object value) {
        Object prev;
        if (value == null) {
            return;
        }
        if (this._clientProperties == null) {
            this._clientProperties = new Hashtable();
        }
        Hashtable hashtable = this._clientProperties;
        synchronized (hashtable) {
            prev = this._clientProperties.get(key);
            if (value != null) {
                this._clientProperties.put(key, value);
            } else if (prev != null) {
                this._clientProperties.remove(key);
            } else {
                return;
            }
        }
        this.firePropertyChange(key.toString(), prev, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getClientProperty(Object key) {
        if (this._clientProperties == null) {
            return null;
        }
        Hashtable hashtable = this._clientProperties;
        synchronized (hashtable) {
            return this._clientProperties.get(key);
        }
    }

    public String convertHtml2Ascii(String aContent) {
        if (!aContent.trim().matches("\\s*<\\s*[hH][tT][mM][lL].*$")) {
            return aContent;
        }
        StringReader theReader = new StringReader(aContent);
        HTMLHandler theHandler = new HTMLHandler();
        try {
            new ParserDelegator().parse(theReader, theHandler, true);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return theHandler.getBuffer();
    }

    private class HTMLHandler
    extends HTMLEditorKit.ParserCallback {
        final StringBuffer theBuffer = new StringBuffer();
        private HTML.Tag theLastTag = null;
        private HTML.Tag theLastEndTag = null;
        private int theColumnCount = 0;
        private int theRowCount = 0;

        public void handleText(char[] aData, int aPos) {
            this.theBuffer.append(aData);
            if (this.theLastTag == HTML.Tag.TD || this.theLastTag == HTML.Tag.TH) {
                if (JComponent.this.gTableData.get(String.valueOf(this.theColumnCount)) == null) {
                    JComponent.this.gTableData.put(String.valueOf(this.theColumnCount), String.valueOf(aData.length));
                    ++this.theColumnCount;
                } else {
                    JComponent.this.gTableData.put(String.valueOf(this.theColumnCount), String.valueOf(Integer.parseInt(JComponent.this.gTableData.get(String.valueOf(this.theColumnCount))) + aData.length));
                    ++this.theColumnCount;
                }
                JComponent.this.gTotalWidth += aData.length;
            }
        }

        public void handleSimpleTag(HTML.Tag aTag, MutableAttributeSet aAttr, int aPos) {
            if (HTML.Tag.BR == aTag) {
                this.theBuffer.append("\n");
            }
        }

        public void handleStartTag(HTML.Tag aTag, MutableAttributeSet aAttr, int aPos) {
            if (HTML.Tag.P == aTag) {
                this.theBuffer.append("\n\n");
            }
            if (HTML.Tag.LI == aTag) {
                this.theBuffer.append("\n *) ");
            }
            if (HTML.Tag.TABLE == aTag) {
                JComponent.this.isHTMLTable = true;
                this.theBuffer.append("<TABLE>");
            }
            if (HTML.Tag.TR == aTag) {
                this.theLastTag = aTag;
                this.theBuffer.append("<TR>");
                ++this.theRowCount;
            }
            if (HTML.Tag.TH == aTag) {
                this.theBuffer.append("<TD>");
                this.theLastTag = aTag;
            }
            if (HTML.Tag.TD == aTag) {
                this.theBuffer.append("<TD>");
                this.theLastTag = aTag;
            }
        }

        public void handleEndTag(HTML.Tag aTag, int pos) {
            if (HTML.Tag.H1 == aTag || HTML.Tag.H2 == aTag || HTML.Tag.H3 == aTag || HTML.Tag.H4 == aTag || HTML.Tag.H5 == aTag || HTML.Tag.H6 == aTag) {
                this.theBuffer.append("\n");
            }
            if (HTML.Tag.TR == aTag) {
                if ((HTML.Tag.TD == this.theLastEndTag || HTML.Tag.TH == this.theLastEndTag) && JComponent.this.gTableData.get(String.valueOf(this.theColumnCount - 1)) != null) {
                    if (JComponent.this.gColumnCount < this.theColumnCount) {
                        JComponent.this.gColumnCount = this.theColumnCount;
                    }
                    this.theColumnCount = 0;
                }
                this.theBuffer.append("</TR>");
                this.theLastEndTag = HTML.Tag.TR;
            }
            if (HTML.Tag.TH == aTag) {
                this.theBuffer.append("</TD>");
                this.theLastEndTag = HTML.Tag.TH;
            }
            if (HTML.Tag.TD == aTag) {
                this.theBuffer.append("</TD>");
                this.theLastEndTag = HTML.Tag.TD;
            }
            if (HTML.Tag.TABLE == aTag) {
                JComponent.this.gRowCount = this.theRowCount;
                this.theLastEndTag = HTML.Tag.TABLE;
                this.theBuffer.append("</TABLE>");
            }
        }

        public String getBuffer() {
            return this.theBuffer.toString();
        }
    }
}

