/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charvax.swing.JMenuBar;
import charvax.swing.JMenuItem;
import charvax.swing.JPopupMenu;
import charvax.swing.JSeparator;
import charvax.swing.SwingUtilities;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;

public class JMenu
extends JMenuItem {
    private Vector _menuItems = new Vector();
    private WeakReference _parentMenu;
    private boolean _popupMenuVisible = false;
    private JPopupMenu _popup;

    public JMenuItem getItem(int index_) {
        return this.getMenuItem(index_);
    }

    public int getItemCount() {
        return this._menuItems.size();
    }

    public JMenu() {
    }

    public JMenu(String text_) {
        this(text_, -1);
    }

    public JMenu(String text_, int mnemonic_) {
        super(text_, mnemonic_);
    }

    public JMenuItem add(JMenuItem item_) {
        this._menuItems.add(item_);
        if (item_ instanceof JMenu) {
            ((JMenu)item_).setParentMenu(this);
        }
        return item_;
    }

    public void addSeparator() {
        this._menuItems.add(new JSeparator());
    }

    public JMenuItem add(String text_) {
        JMenuItem item = new JMenuItem(text_);
        this.add(item);
        return item;
    }

    public void setForeground(Color color_) {
        super.setForeground(color_);
        Enumeration e = this._menuItems.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c.getForeground() != null) continue;
            c.setForeground(color_);
        }
    }

    public void setBackground(Color color_) {
        super.setBackground(color_);
        Enumeration e = this._menuItems.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c.getBackground() != null) continue;
            c.setBackground(color_);
        }
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        term.setCursor(origin);
        if (!(this.getParent() instanceof JMenuBar)) {
            super.draw();
        } else {
            int mnemonicPos;
            int attribute = super.hasFocus() ? Toolkit.A_BOLD : Toolkit.A_REVERSE;
            term.addString(" ", attribute, colorpair);
            term.addString(super.getText(), attribute, colorpair);
            term.addString(" ", attribute, colorpair);
            if (super.getMnemonic() > 0 && (mnemonicPos = super.getText().indexOf((char)super.getMnemonic())) != -1) {
                term.setCursor(origin.addOffset(mnemonicPos + 1, 0));
                term.addChar(super.getMnemonic(), attribute | Toolkit.A_UNDERLINE, colorpair);
            }
        }
    }

    public JMenuItem getMenuItem(int index_) {
        Object o = this._menuItems.elementAt(index_);
        if (o instanceof JMenuItem) {
            return (JMenuItem)o;
        }
        return null;
    }

    public void fireActionPerformed(ActionEvent ae_) {
        super.fireActionPerformed(ae_);
        this.setPopupMenuVisible(true);
        if (this._popup.leftWasPressed()) {
            Toolkit.getDefaultToolkit().fireKeystroke(260);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().fireKeystroke(343);
                }
            });
        } else if (this._popup.rightWasPressed()) {
            Toolkit.getDefaultToolkit().fireKeystroke(261);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().fireKeystroke(343);
                }
            });
        } else if (!this.isTopLevelMenu()) {
            this.getAncestorWindow().hide();
        }
    }

    public Dimension minimumSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getSize() {
        return this.minimumSize();
    }

    public int getWidth() {
        return this.getText().length() + 2;
    }

    public int getHeight() {
        return 1;
    }

    public boolean isPopupMenuVisible() {
        return this._popupMenuVisible;
    }

    public void setPopupMenuVisible(boolean visible_) {
        this._popupMenuVisible = visible_;
        if (!visible_) {
            this._popup.hide();
            return;
        }
        if (this._popup == null) {
            this._popup = new JPopupMenu(this._menuItems);
        }
        if (!this.isTopLevelMenu()) {
            JMenu parentmenu = (JMenu)this.getParentMenu();
            JPopupMenu parentpopup = parentmenu.getPopupMenu();
            Point p = parentpopup.getLocation();
            int verticalOffset = parentpopup.getComponentIndex(this);
            this._popup.setInvoker(parentpopup);
            int parentwidth = parentpopup.getSize().width;
            Toolkit term = Toolkit.getDefaultToolkit();
            if (p.x + parentwidth + this._popup.getWidth() < term.getScreenColumns()) {
                this._popup.setLocation(p.addOffset(parentwidth - 1, verticalOffset));
            } else {
                this._popup.setLocation(p.addOffset(-this._popup.getWidth() + 1, verticalOffset));
            }
        } else {
            JMenuBar parentMenuBar = (JMenuBar)this.getParent();
            Point p = parentMenuBar.getPopupMenuLocation(this);
            this._popup.setInvoker(parentMenuBar);
            this._popup.setLocation(p);
        }
        this._popup.setFocus(this._popup.getFirstMenuItem());
        this._popup.show();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JMenu origin=" + this._origin + " text=" + this.getText());
    }

    public String toString() {
        return "JMenu: text=" + this.getText();
    }

    void setParentMenu(Component parent_) {
        this._parentMenu = new WeakReference<Component>(parent_);
        if (super.getForeground() == null) {
            super.setForeground(parent_.getForeground());
        }
        if (super.getBackground() == null) {
            super.setBackground(parent_.getBackground());
        }
    }

    Component getParentMenu() {
        return (Component)this._parentMenu.get();
    }
}

