/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.BorderLayout;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.FlowLayout;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charvax.swing.AbstractButton;
import charvax.swing.BoxLayout;
import charvax.swing.JButton;
import charvax.swing.JDialog;
import charvax.swing.JLabel;
import charvax.swing.JPanel;
import charvax.swing.JTextField;
import charvax.swing.border.EmptyBorder;

public class JOptionPane {
    protected Object _message;
    protected int _messagetype;
    protected int _optiontype;
    protected boolean _wantsInput = false;
    protected String _inputValue = "";
    protected Object[] _options;
    protected Object _initialValue;
    protected Object _value;
    public static final int ERROR_MESSAGE = 100;
    public static final int INFORMATION_MESSAGE = 101;
    public static final int WARNING_MESSAGE = 102;
    public static final int QUESTION_MESSAGE = 103;
    public static final int PLAIN_MESSAGE = 104;
    public static final int DEFAULT_OPTION = 200;
    public static final int YES_NO_OPTION = 201;
    public static final int YES_NO_CANCEL_OPTION = 202;
    public static final int OK_CANCEL_OPTION = 203;
    public static final int YES_OPTION = 300;
    public static final int NO_OPTION = 301;
    public static final int CANCEL_OPTION = 302;
    public static final int OK_OPTION = 303;
    public static final int CLOSED_OPTION = 304;
    public static String YES_LABEL = "Yes";
    public static String NO_LABEL = "No";
    public static String CANCEL_LABEL = "Cancel";
    public static String OK_LABEL = "OK";
    public static int YES_ACCELERATOR = -1;
    public static int NO_ACCELERATOR = -1;
    public static int CANCEL_ACCELERATOR = -1;
    public static int OK_ACCELERATOR = -1;

    public JOptionPane() {
        this("This is a test message", 104, 200, null, null, null);
    }

    public JOptionPane(Object message_) {
        this(message_, 104, 200, null, null, null);
    }

    public JOptionPane(Object message_, int messagetype_) {
        this(message_, messagetype_, 200, null, null, null);
    }

    public JOptionPane(Object message_, int messagetype_, int optiontype_) {
        this(message_, messagetype_, optiontype_, null, null, null);
    }

    public JOptionPane(Object message_, int messageType_, int optionType_, Object icon_, Object[] options_, Object initialValue_) {
        this._message = message_;
        this._messagetype = messageType_;
        this._optiontype = optionType_;
        this._options = options_;
        this._initialValue = initialValue_;
    }

    public void setWantsInput(boolean newvalue_) {
        this._wantsInput = newvalue_;
    }

    public boolean getWantsInput() {
        return this._wantsInput;
    }

    public void setInitialSelectionValue(Object value_) {
        this._inputValue = (String)value_;
    }

    public void setInputValue(Object value_) {
        this._inputValue = (String)value_;
    }

    public Object getInputValue() {
        return this._inputValue;
    }

    public void setOptions(Object[] newOptions_) {
        this._options = newOptions_;
    }

    public Object[] getOptions() {
        return this._options;
    }

    public void setInitialValue(Object initialValue_) {
    }

    public Object getInitialValue() {
        return null;
    }

    public JDialog createDialog(Component owner_, String title_) {
        Popup dlg = null;
        dlg = new Popup(owner_, this._message, title_);
        if (owner_ != null) {
            dlg.setLocationRelativeTo(owner_);
        }
        return dlg;
    }

    public static int showConfirmDialog(Component parent_, Object message_, String title_, int optiontype_) {
        JOptionPane pane = new JOptionPane(message_, 104, optiontype_);
        Popup dialog = (Popup)pane.createDialog(parent_, title_);
        dialog.show();
        return (Integer)pane.getValue();
    }

    public static String showInputDialog(Component parent_, Object message_, String title_, int messagetype_) {
        JOptionPane pane = new JOptionPane(message_, messagetype_, 203);
        pane._wantsInput = true;
        Popup dialog = (Popup)pane.createDialog(parent_, title_);
        dialog.show();
        int option = (Integer)pane.getValue();
        if (option == 302) {
            return null;
        }
        return (String)pane.getInputValue();
    }

    public static void showMessageDialog(Component parent_, Object message_) {
        JOptionPane.showMessageDialog(parent_, message_, "Confirm", 200);
    }

    public static void showMessageDialog(Component parent_, Object message_, String title_, int msgtype_) {
        JOptionPane pane = new JOptionPane(message_, msgtype_, 200);
        JDialog dialog = pane.createDialog(parent_, title_);
        dialog.show();
    }

    public Object getValue() {
        return this._value;
    }

    private class Popup
    extends JDialog
    implements ActionListener,
    KeyListener {
        private Component _ownerComponent;
        private JButton _okButton;
        private JButton _yesButton;
        private JButton _noButton;
        private JButton _cancelButton;
        private JTextField _inputField = new JTextField(20);

        Popup(Component owner_, Object message_, String title_) {
            int i;
            if (owner_ != null) {
                super.setForeground(owner_.getForeground());
                super.setBackground(owner_.getBackground());
            } else {
                super.setForeground(Toolkit.getDefaultForeground());
                super.setBackground(Toolkit.getDefaultBackground());
            }
            this.setTitle(title_);
            this._ownerComponent = owner_;
            this.setLayout(new BorderLayout());
            JPanel northpan = new JPanel();
            northpan.setBorder(new EmptyBorder(2, 2, 1, 2));
            JPanel messagepanel = new JPanel();
            if (message_ instanceof String) {
                message_ = ((String)message_).split(System.getProperty("line.separator"));
            }
            if (message_ instanceof Object[]) {
                messagepanel.setLayout(new BoxLayout(this.getOwner(), 101));
                Object[] objects = message_;
                for (i = 0; i < objects.length; ++i) {
                    messagepanel.add(new JLabel(objects[i].toString()));
                }
            } else {
                throw new IllegalArgumentException("illegal message type " + message_.getClass().getName());
            }
            northpan.add(messagepanel);
            this.add(northpan, "North");
            if (JOptionPane.this._wantsInput) {
                JPanel centerpan = new JPanel();
                centerpan.setBorder(new EmptyBorder(1, 1, 1, 1));
                this._inputField = new JTextField(JOptionPane.this._inputValue, 20);
                this._inputField.addActionListener(this);
                centerpan.add(this._inputField);
                this.add(centerpan, "Center");
            }
            JPanel southpan = new JPanel();
            southpan.setLayout(new FlowLayout(2, 1, 1));
            if (JOptionPane.this._options != null) {
                for (i = 0; i < JOptionPane.this._options.length; ++i) {
                    AbstractButton button = null;
                    if (JOptionPane.this._options[i] instanceof String) {
                        button = new JButton((String)JOptionPane.this._options[i]);
                    } else if (JOptionPane.this._options[i] instanceof AbstractButton) {
                        button = (AbstractButton)JOptionPane.this._options[i];
                    }
                    button.addActionListener(this);
                    southpan.add(button);
                }
            } else {
                if (JOptionPane.this._optiontype == 200 || JOptionPane.this._optiontype == 203) {
                    this._okButton = new JButton("OK");
                    this._okButton.setText(OK_LABEL);
                    this._okButton.addActionListener(this);
                    southpan.add(this._okButton);
                }
                if (JOptionPane.this._optiontype == 201 || JOptionPane.this._optiontype == 202) {
                    this._yesButton = new JButton("Yes");
                    this._yesButton.setText(YES_LABEL);
                    this._yesButton.addActionListener(this);
                    southpan.add(this._yesButton);
                }
                if (JOptionPane.this._optiontype == 201 || JOptionPane.this._optiontype == 202) {
                    this._noButton = new JButton("No");
                    this._noButton.setText(NO_LABEL);
                    this._noButton.addActionListener(this);
                    southpan.add(this._noButton);
                }
                if (JOptionPane.this._optiontype == 202 || JOptionPane.this._optiontype == 203) {
                    this._cancelButton = new JButton("Cancel");
                    this._cancelButton.setText(CANCEL_LABEL);
                    this._cancelButton.addActionListener(this);
                    southpan.add(this._cancelButton);
                }
            }
            this.add(southpan, "South");
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            this.pack();
            Dimension msgsize = messagepanel.getSize();
            this.setSize(msgsize.width + 8, msgsize.height + 9);
            this.pack();
            Dimension ourSize = this.getSize();
            if (this._ownerComponent != null) {
                Point ownerOrigin = this._ownerComponent.getLocationOnScreen();
                Dimension ownerSize = this._ownerComponent.getSize();
                Point ownerCenter = ownerOrigin.addOffset(ownerSize.width / 2, ownerSize.height / 2);
                this.setLocation(ownerCenter.addOffset(-ourSize.width / 2, -ourSize.height / 2));
            } else {
                Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
                Point screenCenter = new Point(screensize.width / 2, screensize.height / 2);
                this.setLocation(screenCenter.addOffset(-ourSize.width / 2, -ourSize.height / 2));
            }
            this.addKeyListener(this);
        }

        public void actionPerformed(ActionEvent e_) {
            if (JOptionPane.this._wantsInput) {
                JOptionPane.this._inputValue = this._inputField.getText();
            }
            if (JOptionPane.this._options != null) {
                if (e_.getSource() == this._inputField) {
                    return;
                }
                AbstractButton source = (AbstractButton)e_.getSource();
                for (int i = 0; i < JOptionPane.this._options.length; ++i) {
                    if (JOptionPane.this._options[i] instanceof String && source.getText().equals(JOptionPane.this._options[i])) {
                        JOptionPane.this._value = JOptionPane.this._options[i];
                    } else {
                        if (source != JOptionPane.this._options[i]) continue;
                        JOptionPane.this._value = source;
                    }
                    break;
                }
            } else {
                Object source = e_.getSource();
                if (source == this._okButton || source == this._inputField) {
                    JOptionPane.this._value = new Integer(303);
                } else if (source == this._yesButton) {
                    JOptionPane.this._value = new Integer(300);
                } else if (source == this._noButton) {
                    JOptionPane.this._value = new Integer(301);
                } else if (source == this._cancelButton) {
                    JOptionPane.this._value = new Integer(302);
                }
            }
            this.hide();
        }

        public void keyPressed(KeyEvent e_) {
            int key = e_.getKeyCode();
            if (key == OK_ACCELERATOR && (JOptionPane.this._optiontype == 200 || JOptionPane.this._optiontype == 203)) {
                JOptionPane.this._value = new Integer(303);
                JOptionPane.this._inputValue = this._inputField.getText();
                this.hide();
            } else if (key == YES_ACCELERATOR && (JOptionPane.this._optiontype == 201 || JOptionPane.this._optiontype == 202)) {
                JOptionPane.this._value = new Integer(300);
                JOptionPane.this._inputValue = this._inputField.getText();
                this.hide();
            } else if (key == NO_ACCELERATOR && (JOptionPane.this._optiontype == 201 || JOptionPane.this._optiontype == 202)) {
                JOptionPane.this._value = new Integer(301);
                this.hide();
            } else if (key == CANCEL_ACCELERATOR && (JOptionPane.this._optiontype == 202 || JOptionPane.this._optiontype == 203)) {
                JOptionPane.this._value = new Integer(302);
                this.hide();
            }
        }

        public void keyTyped(KeyEvent e_) {
        }

        public void keyReleased(KeyEvent e_) {
        }
    }
}

