/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Container;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charvax.swing.JTextField;

public class JPasswordField
extends JTextField {
    private char _echoChar = (char)42;

    public JPasswordField() {
    }

    public JPasswordField(String text_) {
        super(text_);
    }

    public JPasswordField(int length_) {
        super("", length_);
    }

    public JPasswordField(String text_, int length_) {
        super(text_, length_);
    }

    public void setEchoChar(char echochar_) {
        this._echoChar = echochar_;
    }

    public char getEchoChar() {
        return this._echoChar;
    }

    public boolean echoCharIsSet() {
        return this._echoChar != '\u0000';
    }

    public String getText() {
        return super.getText();
    }

    public char[] getPassword() {
        return super.getText().toCharArray();
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        int colorpair = this.getCursesColor();
        Container parent = this.getParent();
        Toolkit term = Toolkit.getDefaultToolkit();
        if (parent != null && colorpair != parent.getCursesColor()) {
            term.blankBox(origin, this.getSize(), colorpair);
        }
        if (this._border != null) {
            this._border.paintBorder(this, colorpair, origin.x, origin.y, this.getWidth(), this.getHeight());
        }
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        int attrib = 0;
        if (this._enabled) {
            attrib |= Toolkit.A_UNDERLINE;
        }
        term.setCursor(origin);
        term.addString(this._padding, attrib, colorpair);
        term.setCursor(origin);
        int end = this._document.length() > this._offset + this._columns ? this._offset + this._columns : this._document.length();
        StringBuffer displaybuf = new StringBuffer();
        if (this._echoChar != '\u0000') {
            for (int i = 0; i < this._document.length(); ++i) {
                displaybuf.append(this._echoChar);
            }
        } else {
            for (int i = 0; i < this._document.length(); ++i) {
                displaybuf.append(' ');
            }
        }
        term.addString(displaybuf.substring(this._offset, end).toString(), attrib, colorpair);
        term.setCursor(origin.addOffset(this._caretPosition - this._offset, 0));
    }

    public String toString() {
        return "JPasswordField location=" + this.getLocation() + " text=\"" + this._document + "\"" + " actionCommand=\"" + this.getActionCommand() + "\"";
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JPasswordField origin=" + this._origin + " size=" + this.getSize() + " text=" + this._document);
    }
}

