/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.GridBagLayout;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.JPanel;
import charvax.swing.JTable;
import charvax.swing.JViewport;
import charvax.swing.border.Border;
import charvax.swing.table.TableHeader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JScrollPane
extends Container
implements ScrollListener {
    private static final Log LOG = LogFactory.getLog(JScrollPane.class);
    private Component _child;
    private JViewport _headerViewport = null;
    private JViewport _childViewport = new JViewport();
    private Border _border;

    public JScrollPane() {
    }

    public JScrollPane(Component component_) {
        this.setViewportView(component_);
    }

    public void setViewportView(Component component_) {
        this._child = component_;
        if (this._child instanceof Container) {
            this.setLayout(new GridBagLayout());
        }
        this._childViewport.setView(component_);
        this.add(this._childViewport);
        this._childViewport.setParent(this);
        Scrollable scrollable = (Scrollable)((Object)component_);
        scrollable.addScrollListener(this);
        if (this._child instanceof Container) {
            ((Container)this._child).setSize(this.getSize().width, this.getSize().height);
            try {
                this._childViewport.setLayout((LayoutManager)((JPanel)this._child).getLayout().getClass().newInstance());
            }
            catch (InstantiationException ex) {
                LOG.warn((Object)("Instantiation Exception :" + ex.getMessage()));
            }
            catch (IllegalAccessException ex) {
                LOG.warn((Object)("IllegalAccessException :" + ex.getMessage()));
            }
        }
        if (component_ instanceof JTable) {
            JTable table = (JTable)component_;
            TableHeader header = new TableHeader(table.getModel());
            this._headerViewport = new JViewport();
            this._headerViewport.setView(header);
            this.add(this._headerViewport);
            this._headerViewport.setParent(this);
            this._childViewport.setLocation(new Point(0, 1));
            this._childViewport.setViewPosition(new Point(0, -1));
        }
    }

    public JViewport getViewport() {
        return this._childViewport;
    }

    public void setSize(int width_, int height_) {
        super.setSize(width_, height_);
        Dimension size = new Dimension(width_, height_);
        if (this._border != null) {
            Insets borderInsets = this._border.getBorderInsets(this);
            size.height -= borderInsets.top + borderInsets.bottom;
            size.width -= borderInsets.left + borderInsets.right;
        }
        this.setViewportExtents(size);
    }

    public void setSize(Dimension size_) {
        this.setSize(size_.width, size_.height);
    }

    public Dimension minimumSize() {
        Dimension size = new Dimension();
        Component view = this.getViewport().getView();
        if (view instanceof Scrollable) {
            Scrollable s = (Scrollable)((Object)view);
            size.setSize(s.getPreferredScrollableViewportSize());
        } else {
            size.setSize(view.getSize());
        }
        this.setViewportExtents(size);
        if (this._border != null) {
            Insets borderInsets = this._border.getBorderInsets(this);
            size.height += borderInsets.top + borderInsets.bottom;
            size.width += borderInsets.left + borderInsets.right;
        }
        return size;
    }

    public void scroll(ScrollEvent e_) {
        Scrollable scrollable = e_.getScrollable();
        int direction = e_.getDirection();
        Point limit = e_.getLimit();
        Point viewportLocation = this.getViewport().getLocation();
        limit.translate(viewportLocation.x, viewportLocation.y);
        limit.translate(scrollable.getLocation());
        Rectangle viewport = this._childViewport.getBounds();
        Point viewPosition = this._childViewport.getViewPosition();
        Point headerPosition = null;
        if (this._headerViewport != null) {
            headerPosition = this._headerViewport.getViewPosition();
        }
        if (limit.x > viewport.getRight()) {
            if (direction == 100 || direction == 104 || direction == 106) {
                viewPosition.x -= limit.x - viewport.getRight();
                if (this._headerViewport != null) {
                    headerPosition.x -= limit.x - viewport.getRight();
                }
            } else if (direction == 101 || direction == 105 || direction == 107) {
                viewPosition.x += viewport.getLeft() - limit.x;
                if (this._headerViewport != null) {
                    headerPosition.x += viewport.getLeft() - limit.x;
                }
            }
        } else if (limit.x < viewport.getLeft()) {
            if (direction == 101 || direction == 105 || direction == 107) {
                viewPosition.x += viewport.getLeft() - limit.x;
                if (this._headerViewport != null) {
                    headerPosition.x += viewport.getLeft() - limit.x;
                }
            } else if (direction == 100 || direction == 104 || direction == 106) {
                viewPosition.x -= limit.x - viewport.getRight();
                if (this._headerViewport != null) {
                    headerPosition.x -= limit.x - viewport.getRight();
                }
            }
        }
        if (limit.y < viewport.getTop() && (direction == 103 || direction == 106 || direction == 107)) {
            viewPosition.y += viewport.getTop() - limit.y;
        } else if (limit.y > viewport.getBottom() && (direction == 102 || direction == 104 || direction == 105)) {
            viewPosition.y -= limit.y - viewport.getBottom();
        }
        this._childViewport.setViewPosition(viewPosition);
        if (this._headerViewport != null) {
            this._headerViewport.setViewPosition(headerPosition);
        }
        this.draw();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point cursor = toolkit.getCursor();
        Point viewportOrigin = this._childViewport.getLocationOnScreen();
        if (cursor.x < viewportOrigin.x || cursor.y < viewportOrigin.y) {
            if (cursor.x < viewportOrigin.x) {
                cursor.x = viewportOrigin.x;
            }
            if (cursor.y < viewportOrigin.y) {
                cursor.y = viewportOrigin.y;
            }
            toolkit.setCursor(cursor);
        }
    }

    public void draw() {
        int i;
        int scrollbar_offset;
        Point origin = this.getLocationOnScreen();
        Insets borderInsets = this.getViewportBorder() != null ? this.getViewportBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        Dimension size = this.minimumSize();
        if (this._border != null) {
            this._border.paintBorder(this, 0, origin.x, origin.y, size.width, size.height);
        }
        if (this._child instanceof TableHeader) {
            return;
        }
        Dimension childSize = this.getViewport().getViewSize();
        Dimension extentSize = this.getViewport().getExtentSize();
        Point viewPosition = this.getViewport().getViewPosition();
        if (childSize.height > extentSize.height) {
            int scrollbar_height = extentSize.height * extentSize.height / childSize.height;
            if (extentSize.height * extentSize.height % childSize.height != 0) {
                ++scrollbar_height;
            }
            scrollbar_offset = -1 * viewPosition.y * extentSize.height / childSize.height;
            for (i = 0; i < extentSize.height; ++i) {
                term.setCursor(origin.addOffset(borderInsets.left + extentSize.width, borderInsets.top + i));
                if (i < scrollbar_offset || i >= scrollbar_offset + scrollbar_height) continue;
                term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
            }
        }
        if (childSize.width > extentSize.width) {
            int scrollbar_width = extentSize.width * extentSize.width / childSize.width;
            if (extentSize.width * extentSize.width % childSize.width != 0) {
                ++scrollbar_width;
            }
            scrollbar_offset = -1 * viewPosition.x * extentSize.width / childSize.width;
            for (i = 0; i < extentSize.width; ++i) {
                term.setCursor(origin.addOffset(borderInsets.left + i, borderInsets.top + extentSize.height));
                if (i < scrollbar_offset || i >= scrollbar_offset + scrollbar_width) continue;
                term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
            }
        }
        super.draw();
    }

    public void setViewportBorder(Border viewportBorder_) {
        this._border = viewportBorder_;
        Insets insets = this._border.getBorderInsets(this);
        if (this._headerViewport != null) {
            this._headerViewport.setLocation(new Point(insets.left, insets.top));
            this._childViewport.setLocation(new Point(insets.left, insets.top + 1));
        } else {
            this._childViewport.setLocation(new Point(insets.left, insets.top));
        }
    }

    public Border getViewportBorder() {
        return this._border;
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JScrollPane origin=" + this._origin + " size=" + this.getSize());
        super.debug(level_ + 1);
    }

    public String toString() {
        return "JScrollPane origin=" + this._origin + " size=" + this.getSize();
    }

    private void setViewportExtents(Dimension size) {
        if (this._headerViewport != null) {
            this._headerViewport.setExtentSize(size.width, 1);
            this._childViewport.setExtentSize(size.width, size.height - 1);
        } else {
            this._childViewport.setExtentSize(size.width, size.height);
        }
    }
}

