/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Point;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.DefaultListSelectionModel;
import charvax.swing.JComponent;
import charvax.swing.JViewport;
import charvax.swing.ListSelectionModel;
import charvax.swing.event.ListSelectionEvent;
import charvax.swing.event.ListSelectionListener;
import charvax.swing.event.TableModelEvent;
import charvax.swing.event.TableModelListener;
import charvax.swing.table.DefaultTableModel;
import charvax.swing.table.TableModel;
import java.util.Enumeration;
import java.util.Vector;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
ListSelectionListener {
    private TableModel _model = null;
    private Dimension _viewportSize;
    private boolean _viewportSizeSet = false;
    private int _currentRow = 0;
    private int _currentColumn = 0;
    private boolean _columnSelectionAllowed = true;
    private boolean _rowSelectionAllowed = true;
    private Vector _scrollListeners = null;
    protected ListSelectionModel _rowSelectionModel = new DefaultListSelectionModel();
    protected ListSelectionModel _columnSelectionModel = new DefaultListSelectionModel();

    public JTable() {
        this(new DefaultTableModel(0, 0));
    }

    public JTable(int numRows_, int numColumns_) {
        this(new DefaultTableModel(numRows_, numColumns_));
    }

    public JTable(Object[][] data_, Object[] columnNames_) {
        this(new DefaultTableModel(data_, columnNames_));
    }

    public JTable(TableModel model_) {
        this.setModel(model_);
        this._rowSelectionModel.addListSelectionListener(this);
    }

    public void setModel(TableModel model_) {
        this._model = model_;
        this._model.addTableModelListener(this);
    }

    public TableModel getModel() {
        return this._model;
    }

    public void setValueAt(Object object_, int row_, int column_) {
        this._model.setValueAt(object_, row_, column_);
    }

    public Object getValueAt(int row_, int column_) {
        return this._model.getValueAt(row_, column_);
    }

    public void tableChanged(TableModelEvent evt_) {
        this.repaint();
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        int x = 1;
        for (int i = 0; i < this._currentColumn; ++i) {
            x += this.getColumnWidth(i) + 1;
        }
        Point newCursor = origin.addOffset(x, this._currentRow + 1);
        if (newCursor.x < 0) {
            newCursor.x = 0;
        }
        if (newCursor.y < 0) {
            newCursor.y = 0;
        }
        Toolkit.getDefaultToolkit().setCursor(newCursor);
    }

    public void draw() {
        int i;
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        int rows = this._model.getRowCount();
        int columns = this._model.getColumnCount();
        int colorpair = this.getCursesColor();
        term.blankBox(origin, this.getSize(), colorpair);
        term.drawBox(origin, this.getSize(), colorpair);
        int x = 1;
        int attr = Toolkit.A_BOLD;
        for (i = 0; i < columns; ++i) {
            term.setCursor(origin.addOffset(x, 0));
            term.addChar(32, attr, colorpair);
            term.addString(this._model.getColumnName(i), attr, colorpair);
            term.addChar(32, attr, colorpair);
            x += this.getColumnWidth(i) + 1;
        }
        if (this._model.getColumnCount() != 0) {
            x = this.getColumnWidth(0) + 1;
            for (i = 0; i < columns - 1; ++i) {
                term.setCursor(origin.addOffset(x, 0));
                term.addChar(Toolkit.ACS_TTEE, 0, colorpair);
                term.setCursor(origin.addOffset(x, 1));
                term.addVerticalLine(rows, 0, colorpair);
                term.setCursor(origin.addOffset(x, rows + 1));
                term.addChar(Toolkit.ACS_BTEE, 0, colorpair);
                x += this.getColumnWidth(i + 1) + 1;
            }
        }
        x = 1;
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                int attrib;
                term.setCursor(origin.addOffset(x, row + 1));
                Object value = this._model.getValueAt(row, column);
                int n = attrib = this.isRowSelected(row) || this.isColumnSelected(column) ? Toolkit.A_REVERSE : Toolkit.A_NORMAL;
                if (this._currentRow == row || this._currentColumn == column) {
                    attrib += Toolkit.A_BOLD;
                }
                if (value == null) {
                    term.addString("", attrib, colorpair);
                    continue;
                }
                term.addString(value.toString(), attrib, colorpair);
            }
            x += this.getColumnWidth(column) + 1;
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        Toolkit term = Toolkit.getDefaultToolkit();
        EventQueue evtqueue = term.getSystemEventQueue();
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (key == 259) {
            if (this._currentRow == 0) {
                term.beep();
            } else {
                --this._currentRow;
                int x = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    x += this.getColumnWidth(i) + 1;
                }
                evtqueue.postEvent(new ScrollEvent(this, 103, new Point(x, this._currentRow + 1)));
            }
        } else if (key == 258) {
            if (this._currentRow == this._model.getRowCount() - 1) {
                term.beep();
            } else {
                ++this._currentRow;
                int x = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    x += this.getColumnWidth(i) + 1;
                }
                evtqueue.postEvent(new ScrollEvent(this, 102, new Point(x, this._currentRow + 2)));
            }
        } else if (key == 260) {
            if (this._currentColumn == 0) {
                term.beep();
            } else {
                --this._currentColumn;
                int x = 0;
                for (int i = 0; i < this._currentColumn; ++i) {
                    x += this.getColumnWidth(i) + 1;
                }
                evtqueue.postEvent(new ScrollEvent(this, 101, new Point(x, this._currentRow)));
            }
        } else if (key == 261) {
            if (this._currentColumn == this._model.getColumnCount() - 1) {
                term.beep();
            } else {
                ++this._currentColumn;
                int x = 0;
                for (int i = 0; i <= this._currentColumn; ++i) {
                    x += this.getColumnWidth(i) + 1;
                }
                evtqueue.postEvent(new ScrollEvent(this, 100, new Point(x, this._currentRow)));
            }
        } else if (key == 262) {
            int x = 0;
            for (int i = 0; i < this._currentColumn; ++i) {
                x += this.getColumnWidth(i) + 1;
            }
            evtqueue.postEvent(new ScrollEvent(this, 101, new Point(x, this._currentRow)));
        } else if (key == 360) {
            int x = 0;
            for (int i = 0; i <= this._currentColumn; ++i) {
                x += this.getColumnWidth(i) + 1;
            }
            evtqueue.postEvent(new ScrollEvent(this, 100, new Point(x, this._currentRow)));
        } else if (key == 343) {
            if (this.getColumnSelectionAllowed()) {
                this.selectCurrentColumn();
            }
            if (this.getRowSelectionAllowed()) {
                this.selectCurrentRow();
            }
            this.repaint();
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    public void addScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(sl_);
    }

    public void removeScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(sl_);
    }

    public void processScrollEvent(ScrollEvent e_) {
        if (this._scrollListeners != null) {
            Enumeration e = this._scrollListeners.elements();
            while (e.hasMoreElements()) {
                ScrollListener sl = (ScrollListener)e.nextElement();
                sl.scroll(e_);
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getWidth() {
        int columns = this._model.getColumnCount();
        int width = 1;
        for (int i = 0; i < columns; ++i) {
            width += this.getColumnWidth(i) + 1;
        }
        return width;
    }

    public int getHeight() {
        int rows = this._model.getRowCount();
        return rows + 2;
    }

    public void setPreferredScrollableViewportSize(Dimension size_) {
        this._viewportSize = size_;
        this._viewportSizeSet = true;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this._viewportSizeSet) {
            return new Dimension(this._viewportSize);
        }
        return this.minimumSize();
    }

    public void setSelectionModel(ListSelectionModel model_) {
        this._rowSelectionModel = model_;
        this._rowSelectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this._rowSelectionModel;
    }

    public void setSelectionMode(int mode_) {
        this._rowSelectionModel.setSelectionMode(mode_);
        this._columnSelectionModel.setSelectionMode(mode_);
    }

    public int getSelectionMode() {
        return this._rowSelectionModel.getSelectionMode();
    }

    public void setColumnSelectionAllowed(boolean allowed_) {
        this._columnSelectionAllowed = allowed_;
    }

    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed;
    }

    public void setRowSelectionAllowed(boolean allowed_) {
        this._rowSelectionAllowed = allowed_;
    }

    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed;
    }

    public void addColumnSelectionInterval(int index0_, int index1_) {
        this._columnSelectionModel.addSelectionInterval(index0_, index1_);
    }

    public void addRowSelectionInterval(int index0_, int index1_) {
        this._rowSelectionModel.addSelectionInterval(index0_, index1_);
    }

    public void setColumnSelectionInterval(int index0_, int index1_) {
        this._columnSelectionModel.setSelectionInterval(index0_, index1_);
    }

    public void setRowSelectionInterval(int index0_, int index1_) {
        this._rowSelectionModel.setSelectionInterval(index0_, index1_);
    }

    public int getSelectedRow() {
        return this._rowSelectionModel.getMinSelectionIndex();
    }

    public int getSelectedRowCount() {
        int min = this._rowSelectionModel.getMinSelectionIndex();
        if (min == -1) {
            return 0;
        }
        int max = this._rowSelectionModel.getMaxSelectionIndex();
        int j = 0;
        for (int i = min; i <= max; ++i) {
            if (!this._rowSelectionModel.isSelectedIndex(i)) continue;
            ++j;
        }
        return j;
    }

    public int[] getSelectedRows() {
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 0) {
            return new int[0];
        }
        int[] array = new int[rowCount];
        int min = this._rowSelectionModel.getMinSelectionIndex();
        int max = this._rowSelectionModel.getMaxSelectionIndex();
        int j = 0;
        for (int i = min; i <= max; ++i) {
            if (!this._rowSelectionModel.isSelectedIndex(i)) continue;
            array[j++] = i;
        }
        return array;
    }

    public int getSelectedColumn() {
        return this._columnSelectionModel.getMinSelectionIndex();
    }

    public int getSelectedColumnCount() {
        int min = this._columnSelectionModel.getMinSelectionIndex();
        if (min == -1) {
            return 0;
        }
        int max = this._columnSelectionModel.getMaxSelectionIndex();
        int j = 0;
        for (int i = min; i <= max; ++i) {
            if (!this._columnSelectionModel.isSelectedIndex(i)) continue;
            ++j;
        }
        return j;
    }

    public int[] getSelectedColumns() {
        int columnCount = this.getSelectedColumnCount();
        if (columnCount == 0) {
            return new int[0];
        }
        int[] array = new int[columnCount];
        int min = this._columnSelectionModel.getMinSelectionIndex();
        int max = this._columnSelectionModel.getMaxSelectionIndex();
        int j = 0;
        for (int i = min; i <= max; ++i) {
            if (!this._columnSelectionModel.isSelectedIndex(i)) continue;
            array[j++] = i;
        }
        return array;
    }

    public boolean isRowSelected(int row_) {
        return this._rowSelectionModel.isSelectedIndex(row_);
    }

    public boolean isColumnSelected(int column_) {
        return this._columnSelectionModel.isSelectedIndex(column_);
    }

    public void valueChanged(ListSelectionEvent e_) {
        this.repaint();
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTable origin=" + this._origin + " size=" + this.getSize());
    }

    private int getColumnWidth(int column_) {
        int columnwidth = this._model.getColumnName(column_).length() + 2;
        for (int j = 0; j < this._model.getRowCount(); ++j) {
            int width;
            Object value = this.getValueAt(j, column_);
            if (value == null || (width = value.toString().length()) <= columnwidth) continue;
            columnwidth = width;
        }
        return columnwidth;
    }

    private void selectCurrentColumn() {
        if (this._columnSelectionModel.isSelectedIndex(this._currentColumn)) {
            this._columnSelectionModel.removeSelectionInterval(this._currentColumn, this._currentColumn);
        } else {
            int selectionMode = this._rowSelectionModel.getSelectionMode();
            if (selectionMode == 201) {
                this._columnSelectionModel.setSelectionInterval(this._currentColumn, this._currentColumn);
            } else {
                this._columnSelectionModel.addSelectionInterval(this._currentColumn, this._currentColumn);
            }
        }
    }

    private void selectCurrentRow() {
        if (this._rowSelectionModel.isSelectedIndex(this._currentRow)) {
            this._rowSelectionModel.removeSelectionInterval(this._currentRow, this._currentRow);
        } else {
            int selectionMode = this._rowSelectionModel.getSelectionMode();
            if (selectionMode == 201) {
                this._rowSelectionModel.setSelectionInterval(this._currentRow, this._currentRow);
            } else {
                this._rowSelectionModel.addSelectionInterval(this._currentRow, this._currentRow);
            }
        }
    }
}

