/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.table;

import charvax.swing.event.TableModelEvent;
import charvax.swing.event.TableModelListener;
import charvax.swing.table.TableModel;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractTableModel
implements TableModel {
    private Vector _listeners = new Vector();

    public void addTableModelListener(TableModelListener l) {
        this._listeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this._listeners.remove(l);
    }

    public String getColumnName(int column_) {
        StringBuffer buf = new StringBuffer(65 + column_);
        return buf.toString();
    }

    public void setValueAt(Object value_, int row_, int column_) {
    }

    public void fireTableChanged(TableModelEvent evt_) {
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            TableModelListener l = (TableModelListener)e.nextElement();
            l.tableChanged(evt_);
        }
    }

    public void fireTableCellUpdated(int row_, int column_) {
        TableModelEvent evt = new TableModelEvent(this, row_, row_, column_);
        this.fireTableChanged(evt);
    }

    public void fireTableDataChanged() {
        TableModelEvent evt = new TableModelEvent(this, 0, this.getRowCount() - 1, -1);
        this.fireTableChanged(evt);
    }

    public void fireTableRowsDeleted(int firstRow_, int lastRow_) {
        TableModelEvent evt = new TableModelEvent(this, firstRow_, lastRow_, -1, 1);
        this.fireTableChanged(evt);
    }

    public void fireTableRowsInserted(int firstRow_, int lastRow_) {
        TableModelEvent evt = new TableModelEvent(this, firstRow_, lastRow_, -1, 2);
        this.fireTableChanged(evt);
    }

    public abstract int getRowCount();
}

