/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing.table;

import charvax.swing.table.AbstractTableModel;
import java.util.Vector;

public class DefaultTableModel
extends AbstractTableModel {
    private int _rows;
    private int _columns;
    private Vector _dataVector = null;
    private Vector _columnNames = null;
    private Vector _columnWidths = null;

    public DefaultTableModel(int rows_, int columns_) {
        this._rows = rows_;
        this._columns = columns_;
        this.setDataVector(rows_, columns_);
    }

    public DefaultTableModel(Object[][] data_, Object[] columnNames_) {
        this._rows = data_.length;
        this._columns = columnNames_.length;
        this.setDataVector(data_, columnNames_);
    }

    public int getColumnCount() {
        return this._columns;
    }

    public String getColumnName(int column_) {
        if (this._columnNames == null) {
            char heading = (char)(65 + column_);
            return String.valueOf(heading);
        }
        return this._columnNames.elementAt(column_).toString();
    }

    public int getColumnWidth(int column_) {
        int width = (Integer)this._columnWidths.elementAt(column_);
        return width;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getValueAt(int rowIndex_, int columnIndex_) {
        if (this._dataVector == null) {
            return null;
        }
        Vector rowVector = (Vector)this._dataVector.elementAt(rowIndex_);
        return rowVector.elementAt(columnIndex_);
    }

    public void setValueAt(Object value_, int row_, int column_) {
        Vector rowVector = (Vector)this._dataVector.elementAt(row_);
        rowVector.set(column_, value_);
        int columnwidth = 3;
        if (this._columnNames != null) {
            Object header = this._columnNames.get(column_);
            columnwidth = header.toString().length() + 2;
        }
        for (int j = 0; j < this._rows; ++j) {
            int width;
            Object value = this.getValueAt(j, column_);
            if (value == null || (width = value.toString().length()) <= columnwidth) continue;
            columnwidth = width;
        }
        this._columnWidths.set(column_, new Integer(columnwidth));
        this.fireTableCellUpdated(row_, column_);
    }

    public void setDataVector(Object[][] data_, Object[] columnNames_) {
        int j;
        int i;
        this._rows = data_.length;
        this._dataVector = new Vector(this._rows);
        for (i = 0; i < this._rows; ++i) {
            this._columns = data_[i].length;
            Vector<Object> rowVector = new Vector<Object>(this._columns);
            this._dataVector.add(rowVector);
            for (j = 0; j < this._columns; ++j) {
                rowVector.add(data_[i][j]);
            }
        }
        this._columnNames = new Vector(this._columns);
        this._columnWidths = new Vector(this._columns);
        for (i = 0; i < this._columns; ++i) {
            this._columnNames.add(columnNames_[i]);
            int columnwidth = columnNames_[i].toString().length() + 2;
            for (j = 0; j < this._rows; ++j) {
                int width = this.getValueAt(j, i).toString().length();
                if (width <= columnwidth) continue;
                columnwidth = width;
            }
            this._columnWidths.add(new Integer(columnwidth));
        }
    }

    public void setDataVector(int rows_, int columns_) {
        int i;
        this._dataVector = new Vector(rows_);
        for (i = 0; i < rows_; ++i) {
            Vector rowVector = new Vector(columns_);
            rowVector.setSize(columns_);
            this._dataVector.add(rowVector);
        }
        this._columnWidths = new Vector(columns_);
        for (i = 0; i < columns_; ++i) {
            int width = this._columnNames == null ? 3 : this._columnNames.get(i).toString().length();
            this._columnWidths.add(new Integer(width));
        }
    }
}

