/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bindings.config.apoc.Button;
import org.openinstaller.bindings.config.apoc.Category;
import org.openinstaller.bindings.config.apoc.CheckBox;
import org.openinstaller.bindings.config.apoc.Chooser;
import org.openinstaller.bindings.config.apoc.ColorSelector;
import org.openinstaller.bindings.config.apoc.ComboBox;
import org.openinstaller.bindings.config.apoc.Constraints;
import org.openinstaller.bindings.config.apoc.DateSelector;
import org.openinstaller.bindings.config.apoc.DirectorySelector;
import org.openinstaller.bindings.config.apoc.Enumeration;
import org.openinstaller.bindings.config.apoc.Hidden;
import org.openinstaller.bindings.config.apoc.HtmlPanel;
import org.openinstaller.bindings.config.apoc.IntegerRangeSelector;
import org.openinstaller.bindings.config.apoc.Length;
import org.openinstaller.bindings.config.apoc.MaxExclusive;
import org.openinstaller.bindings.config.apoc.MaxInclusive;
import org.openinstaller.bindings.config.apoc.MaxLength;
import org.openinstaller.bindings.config.apoc.MinExclusive;
import org.openinstaller.bindings.config.apoc.MinInclusive;
import org.openinstaller.bindings.config.apoc.MinLength;
import org.openinstaller.bindings.config.apoc.Page;
import org.openinstaller.bindings.config.apoc.Password;
import org.openinstaller.bindings.config.apoc.ProductsSelector;
import org.openinstaller.bindings.config.apoc.ProgressBar;
import org.openinstaller.bindings.config.apoc.PropValue;
import org.openinstaller.bindings.config.apoc.Property;
import org.openinstaller.bindings.config.apoc.RadioButtons;
import org.openinstaller.bindings.config.apoc.ResImport;
import org.openinstaller.bindings.config.apoc.ScriptHandler;
import org.openinstaller.bindings.config.apoc.Section;
import org.openinstaller.bindings.config.apoc.SlideResource;
import org.openinstaller.bindings.config.apoc.SlideShow;
import org.openinstaller.bindings.config.apoc.StringList;
import org.openinstaller.bindings.config.apoc.Template;
import org.openinstaller.bindings.config.apoc.TextArea;
import org.openinstaller.bindings.config.apoc.TextField;
import org.openinstaller.bindings.config.apoc.TextPanel;
import org.openinstaller.bindings.config.apoc.Visual;
import org.openinstaller.bindings.config.apoc.VisualMediaType;
import org.openinstaller.provider.conf.apoc.APOCButton;
import org.openinstaller.provider.conf.apoc.APOCCategory;
import org.openinstaller.provider.conf.apoc.APOCCheckBox;
import org.openinstaller.provider.conf.apoc.APOCChooser;
import org.openinstaller.provider.conf.apoc.APOCColorSelector;
import org.openinstaller.provider.conf.apoc.APOCComboBox;
import org.openinstaller.provider.conf.apoc.APOCConstraints;
import org.openinstaller.provider.conf.apoc.APOCDateSelector;
import org.openinstaller.provider.conf.apoc.APOCDirectorySelector;
import org.openinstaller.provider.conf.apoc.APOCEnumerationConstraint;
import org.openinstaller.provider.conf.apoc.APOCHidden;
import org.openinstaller.provider.conf.apoc.APOCHtmlPanel;
import org.openinstaller.provider.conf.apoc.APOCIntegerRangeSelector;
import org.openinstaller.provider.conf.apoc.APOCLengthConstraint;
import org.openinstaller.provider.conf.apoc.APOCMaxExclusiveConstraint;
import org.openinstaller.provider.conf.apoc.APOCMaxInclusiveConstraint;
import org.openinstaller.provider.conf.apoc.APOCMaxLengthConstraint;
import org.openinstaller.provider.conf.apoc.APOCMinExclusiveConstraint;
import org.openinstaller.provider.conf.apoc.APOCMinInclusiveConstraint;
import org.openinstaller.provider.conf.apoc.APOCMinLengthConstraint;
import org.openinstaller.provider.conf.apoc.APOCPage;
import org.openinstaller.provider.conf.apoc.APOCPassword;
import org.openinstaller.provider.conf.apoc.APOCProductsSelector;
import org.openinstaller.provider.conf.apoc.APOCProgressBar;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCRadioButton;
import org.openinstaller.provider.conf.apoc.APOCResImport;
import org.openinstaller.provider.conf.apoc.APOCScriptHandler;
import org.openinstaller.provider.conf.apoc.APOCSection;
import org.openinstaller.provider.conf.apoc.APOCSlideShow;
import org.openinstaller.provider.conf.apoc.APOCStringList;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.conf.apoc.APOCTextArea;
import org.openinstaller.provider.conf.apoc.APOCTextField;
import org.openinstaller.provider.conf.apoc.APOCTextPanel;
import org.openinstaller.provider.conf.apoc.APOCType;
import org.openinstaller.provider.conf.apoc.APOCVisual;
import org.openinstaller.provider.conf.apoc.APOCVisualMediaType;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;

public final class APOCBuilder {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private APOCBuilder() {
    }

    public static APOCTemplate createAPOCTemplate(Template aTemplate) throws EnhancedException {
        Category theParsedCategory = aTemplate.getCategory();
        List theResImport = aTemplate.getResImport();
        if (!Category.class.isInstance(theParsedCategory)) {
            LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
        }
        Category theCategory = theParsedCategory;
        APOCCategory theAPOCCategory = APOCBuilder.createAPOCCategory(theCategory);
        APOCTemplate theAPOCTemplate = new APOCTemplate(theAPOCCategory);
        theAPOCTemplate.setName(aTemplate.getName());
        if (theResImport != null) {
            for (ResImport theAResImport : theResImport) {
                theAPOCTemplate.addResImport(new APOCResImport(theAResImport.getPackagePath()));
            }
        }
        return theAPOCTemplate;
    }

    private static APOCCategory createAPOCCategory(Category aCategory) throws EnhancedException {
        String theName = aCategory.getName();
        String theLabel = aCategory.getLabel();
        String theInlineHelp = aCategory.getInlineHelp();
        String theScope = aCategory.getScope();
        APOCCategory theCategory = new APOCCategory(theName, theLabel);
        theCategory.setInlineHelp(theInlineHelp);
        theCategory.setScope(theScope);
        Page theParsedPage = aCategory.getPage();
        if (!Page.class.isInstance(theParsedPage)) {
            LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
        }
        Page thePage = theParsedPage;
        APOCPage theAPOCPage = APOCBuilder.createAPOCPage(thePage);
        theAPOCPage.setInlineHelp(thePage.getInlineHelp());
        theAPOCPage.setOnlineHelp(thePage.getOnlineHelp());
        theAPOCPage.setScope(thePage.getScope());
        ScriptHandler theUnmarshalledScriptHandler = thePage.getScriptHandler();
        if (theUnmarshalledScriptHandler != null) {
            try {
                theAPOCPage.setScriptHandler(new APOCScriptHandler().setScriptCode(theUnmarshalledScriptHandler.getScriptCode()).setScriptLanguage(theUnmarshalledScriptHandler.getScriptLanguage()));
            }
            catch (InvalidArgumentException theEIAEx) {
                throw new EnhancedException("INVALID_SCRIPT_LANGUAGE", (Throwable)theEIAEx, new String[]{"script-language=" + theUnmarshalledScriptHandler.getScriptLanguage()});
            }
        }
        theCategory.setPage(theAPOCPage);
        for (Section theParsedSection : thePage.getSection()) {
            if (!Section.class.isInstance(theParsedSection)) {
                LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
                continue;
            }
            Section theSection = theParsedSection;
            APOCSection theAPOCSection = APOCBuilder.createAPOCSection(theSection);
            theAPOCSection.setScope(theSection.getScope());
            theAPOCPage.addSection(theAPOCSection);
            for (Property thePropSpec : theSection.getProperty()) {
                if (!Property.class.isInstance(thePropSpec)) {
                    LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
                    continue;
                }
                Property theProperty = thePropSpec;
                theAPOCSection.addProperty(APOCBuilder.createAPOCProperty(theProperty));
            }
        }
        return theCategory;
    }

    private static APOCPage createAPOCPage(Page aPage) {
        return new APOCPage(aPage.getName(), aPage.getLabel());
    }

    private static APOCSection createAPOCSection(Section aSection) {
        return new APOCSection(aSection.getName(), aSection.getLabel());
    }

    private static APOCProperty createAPOCProperty(Property aProperty) throws EnhancedException {
        Constraints theConstraints;
        ScriptHandler aScriptHandler;
        APOCType theType;
        String theName = aProperty.getName();
        String theLabel = aProperty.getLabel();
        String theDataPath = aProperty.getDataPath();
        try {
            theType = APOCType.getTypeForString(aProperty.getType());
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new EnhancedException("INVALID_CONFIG_SCHEMA", (Throwable)theEIAEx, new String[]{"propertyname=" + theName});
        }
        Visual theAPOCPropertyVisual = aProperty.getVisual();
        APOCVisual theAPOCVisual = new APOCVisual();
        if (theAPOCPropertyVisual != null) {
            CheckBox theUnmarshalledCheckBox = theAPOCPropertyVisual.getCheckBox();
            Chooser theUnmarshalledChooser = theAPOCPropertyVisual.getChooser();
            ComboBox theUnmarshalledComboBox = theAPOCPropertyVisual.getComboBox();
            RadioButtons theUnmarshalledRadioButtons = theAPOCPropertyVisual.getRadioButtons();
            TextArea theUnmarshalledTextArea = theAPOCPropertyVisual.getTextArea();
            Password theUnmarshalledPassword = theAPOCPropertyVisual.getPassword();
            StringList theUnmarshalledStringList = theAPOCPropertyVisual.getStringList();
            Hidden theUnmarshalledHidden = theAPOCPropertyVisual.getHidden();
            ColorSelector theUnmarshalledColorSelector = theAPOCPropertyVisual.getColorSelector();
            TextField theUnmarshalledTextField = theAPOCPropertyVisual.getTextField();
            DirectorySelector theUnmarshalledDirSelector = theAPOCPropertyVisual.getDirectorySelector();
            IntegerRangeSelector theUnmarshalledIntRangeSelector = theAPOCPropertyVisual.getIntegerRangeSelector();
            DateSelector theUnmarshalledDateSelector = theAPOCPropertyVisual.getDateSelector();
            ProgressBar theUnmarshalledProgressBar = theAPOCPropertyVisual.getProgressBar();
            TextPanel theUnmarshalledTextPanel = theAPOCPropertyVisual.getTextPanel();
            HtmlPanel theUnmarshalledHtmlPanel = theAPOCPropertyVisual.getHtmlPanel();
            Button theUnmarshalledButton = theAPOCPropertyVisual.getButton();
            SlideShow theUnmarshalledSlideShow = theAPOCPropertyVisual.getSlideShow();
            ProductsSelector theUnmarshalledProductsSelector = theAPOCPropertyVisual.getProductsSelector();
            if (theUnmarshalledCheckBox != null) {
                theAPOCVisual.setType(new APOCCheckBox(theUnmarshalledCheckBox.getLabelPost()).setToolTip(theUnmarshalledCheckBox.getToolTip()));
            } else if (theUnmarshalledChooser != null) {
                theAPOCVisual.setType(new APOCChooser().setToolTip(theUnmarshalledChooser.getToolTip()).setDataPath(theUnmarshalledChooser.getDataPath()).setExtendsChooser(theUnmarshalledChooser.getExtendsChooser()).setLabelPopup(theUnmarshalledChooser.getLabelPopup()));
            } else if (theUnmarshalledButton != null) {
                try {
                    theAPOCVisual.setType(new APOCButton().setToolTip(theUnmarshalledButton.getToolTip()).setAlignment(theUnmarshalledButton.getHAlignment()));
                }
                catch (InvalidArgumentException theEIAEx) {
                    throw new EnhancedException("INVALID_AlIGNMENT", (Throwable)theEIAEx, new String[]{"button-alignment=" + theUnmarshalledButton.getHAlignment()});
                }
            } else if (theUnmarshalledComboBox != null) {
                theAPOCVisual.setType(new APOCComboBox().setToolTip(theUnmarshalledComboBox.getToolTip()));
            } else if (theUnmarshalledRadioButtons != null) {
                theAPOCVisual.setType(new APOCRadioButton().setToolTip(theUnmarshalledRadioButtons.getToolTip()));
            } else if (theUnmarshalledTextArea != null) {
                theAPOCVisual.setType(new APOCTextArea().setRows(theUnmarshalledTextArea.getRows()).setColumns(theUnmarshalledTextArea.getColumns()).setToolTip(theUnmarshalledTextArea.getToolTip()).setReadOnly(theUnmarshalledTextArea.isReadOnly()));
            } else if (theUnmarshalledPassword != null) {
                APOCPassword thePassword = new APOCPassword().setToolTip(theUnmarshalledPassword.getToolTip());
                if (theUnmarshalledPassword.getColumns() != null) {
                    thePassword.setColumns(theUnmarshalledPassword.getColumns());
                }
                theAPOCVisual.setType(thePassword);
            } else if (theUnmarshalledStringList != null) {
                theAPOCVisual.setType(new APOCStringList().setToolTip(theUnmarshalledStringList.getToolTip()));
            } else if (theUnmarshalledHidden != null) {
                theAPOCVisual.setType(new APOCHidden().setToolTip(theUnmarshalledHidden.getToolTip()));
            } else if (theUnmarshalledColorSelector != null) {
                theAPOCVisual.setType(new APOCColorSelector().setToolTip(theUnmarshalledColorSelector.getToolTip()));
            } else if (theUnmarshalledTextField != null) {
                APOCTextField theTextField = new APOCTextField().setToolTip(theUnmarshalledTextField.getToolTip());
                if (theUnmarshalledTextField.getColumns() != null) {
                    theTextField.setColumns(theUnmarshalledTextField.getColumns());
                }
                theAPOCVisual.setType(theTextField);
            } else if (theUnmarshalledDirSelector != null) {
                APOCDirectorySelector theDirectorySelector = new APOCDirectorySelector().setToolTip(theUnmarshalledDirSelector.getToolTip()).setFileSelector(theUnmarshalledDirSelector.isFileSelector());
                if (theUnmarshalledDirSelector.getColumns() != null) {
                    theDirectorySelector.setColumns(theUnmarshalledDirSelector.getColumns());
                }
                theAPOCVisual.setType(theDirectorySelector);
            } else if (theUnmarshalledIntRangeSelector != null) {
                theAPOCVisual.setType(new APOCIntegerRangeSelector().setToolTip(theUnmarshalledIntRangeSelector.getToolTip()));
            } else if (theUnmarshalledDateSelector != null) {
                theAPOCVisual.setType(new APOCDateSelector().setToolTip(theUnmarshalledDateSelector.getToolTip()));
            } else if (theUnmarshalledProgressBar != null) {
                theAPOCVisual.setType(new APOCProgressBar().setToolTip(theUnmarshalledProgressBar.getToolTip()).setDeterminate(theUnmarshalledProgressBar.isDeterminate()).setProgressMax(theUnmarshalledProgressBar.getProgressMax()).setProgressBackground(theUnmarshalledProgressBar.getProgressBackground()));
            } else if (theUnmarshalledTextPanel != null) {
                theAPOCVisual.setType(new APOCTextPanel().setToolTip(theUnmarshalledTextPanel.getToolTip()));
            } else if (theUnmarshalledHtmlPanel != null) {
                theAPOCVisual.setType(new APOCHtmlPanel().setToolTip(theUnmarshalledHtmlPanel.getToolTip()));
            } else if (theUnmarshalledSlideShow != null) {
                APOCSlideShow theSlideShow = new APOCSlideShow();
                theSlideShow.setUpdateURL(theUnmarshalledSlideShow.getUpdateURL()).setDefaultTimePerSlide(theUnmarshalledSlideShow.getTimePerSlide());
                List theSlideResources = theUnmarshalledSlideShow.getSlideResource();
                for (SlideResource theSlideResource : theSlideResources) {
                    theSlideShow.addSlideResource(theSlideResource.getValue(), theSlideResource.getTime());
                }
                theAPOCVisual.setType(theSlideShow);
            } else if (theUnmarshalledProductsSelector != null) {
                theAPOCVisual.setType(new APOCProductsSelector().setAddTooltip(theUnmarshalledProductsSelector.getTooltips().getAdd()).setAddAllTooltip(theUnmarshalledProductsSelector.getTooltips().getAddAll()).setAvailableTooltip(theUnmarshalledProductsSelector.getTooltips().getAvailable()).setDescTooltip(theUnmarshalledProductsSelector.getTooltips().getDesc()).setRemoveAllTooltip(theUnmarshalledProductsSelector.getTooltips().getRemoveAll()).setRemoveTooltip(theUnmarshalledProductsSelector.getTooltips().getRemove()).setSelectedTooltip(theUnmarshalledProductsSelector.getTooltips().getSelected()).setShowFeatures(theUnmarshalledProductsSelector.isShowFeatures()).setShowDependencies(theUnmarshalledProductsSelector.isShowDependencies()).setUnselectFeatures(theUnmarshalledProductsSelector.isUnselectFeatures()).setUnselectDependencies(theUnmarshalledProductsSelector.isUnselectDependencies()).setRootIsAContainer(theUnmarshalledProductsSelector.isRootIsAContainer()));
            }
        }
        APOCProperty theProperty = new APOCProperty(theName, theLabel, theDataPath, theType, theAPOCVisual);
        theProperty.setInlineHelp(aProperty.getInlineHelp()).setScope(aProperty.getScope()).setStoreDefault(aProperty.getStoreDefault()).setXmlHandler(aProperty.getXmlHandler());
        VisualMediaType theUnmarshalledVisualMediaType = aProperty.getVisualMediaType();
        if (theUnmarshalledVisualMediaType != null) {
            theProperty.setVisualMediaType(new APOCVisualMediaType().setData(theUnmarshalledVisualMediaType.getData()).setEncoding(theUnmarshalledVisualMediaType.getEncoding()).setToolTip(theUnmarshalledVisualMediaType.getToolTip()).setType(theUnmarshalledVisualMediaType.getType()).setURL(theUnmarshalledVisualMediaType.getUrl()));
        }
        if ((aScriptHandler = aProperty.getScriptHandler()) != null) {
            try {
                theProperty.setScriptHandler(new APOCScriptHandler().setScriptCode(aScriptHandler.getScriptCode()).setScriptLanguage(aScriptHandler.getScriptLanguage()));
            }
            catch (InvalidArgumentException theEIAEx) {
                throw new EnhancedException("INVALID_SCRIPT_LANGUAGE", (Throwable)theEIAEx, new String[]{"script-language=" + aScriptHandler.getScriptLanguage()});
            }
        }
        if ((theConstraints = aProperty.getConstraints()) != null) {
            MinLength theMinLength = theConstraints.getMinLength();
            MaxLength theMaxLength = theConstraints.getMaxLength();
            Length theLength = theConstraints.getLength();
            MinInclusive theMinInc = theConstraints.getMinInclusive();
            MaxInclusive theMaxInc = theConstraints.getMaxInclusive();
            MinExclusive theMinExc = theConstraints.getMinExclusive();
            MaxExclusive theMaxExc = theConstraints.getMaxExclusive();
            List theEnum = theConstraints.getEnumeration();
            try {
                if (theMinLength != null) {
                    theProperty.addConstraint(new APOCMinLengthConstraint(Integer.parseInt(theMinLength.getValue())));
                }
                if (theMaxLength != null) {
                    theProperty.addConstraint(new APOCMaxLengthConstraint(Integer.parseInt(theMaxLength.getValue())));
                }
                if (theLength != null) {
                    theProperty.addConstraint(new APOCLengthConstraint(Integer.parseInt(theLength.getValue())));
                }
                if (theMinInc != null) {
                    theProperty.addConstraint(new APOCMinInclusiveConstraint(Integer.parseInt(theMinInc.getValue())));
                }
                if (theMaxInc != null) {
                    theProperty.addConstraint(new APOCMaxInclusiveConstraint(Integer.parseInt(theMaxInc.getValue())));
                }
                if (theMaxExc != null) {
                    theProperty.addConstraint(new APOCMaxExclusiveConstraint(Integer.parseInt(theMaxExc.getValue())));
                }
                if (theMinExc != null) {
                    theProperty.addConstraint(new APOCMinExclusiveConstraint(Integer.parseInt(theMinExc.getValue())));
                }
                if (theEnum != null) {
                    APOCEnumerationConstraint theAPOCEnumConstraint = new APOCEnumerationConstraint();
                    for (Enumeration theTempEnum : theEnum) {
                        theAPOCEnumConstraint.addEnumConstraint(theTempEnum.getValue(), theTempEnum.getLabel());
                        if (null == theTempEnum.getToolTip() || "".equalsIgnoreCase(theTempEnum.getToolTip())) continue;
                        theAPOCEnumConstraint.addToolTip(theTempEnum.getValue(), theTempEnum.getToolTip());
                    }
                    theProperty.addConstraint(theAPOCEnumConstraint);
                }
            }
            catch (NumberFormatException theEx) {
                throw new EnhancedException("SCHEMA_CONSTRAINT_INVALID", (Throwable)theEx, new String[0]);
            }
        }
        for (PropValue tempValue : aProperty.getPropValue()) {
            APOCPropValue theValue = new APOCPropValue().setSeperator(tempValue.getSeparator()).setValue(tempValue.getValue());
            APOCConstraints theFailedConstraint = theProperty.setPropValue(theValue);
            if (theFailedConstraint == null) continue;
            throw new EnhancedException("UI_CONFIG_DEFAULT_VALUE_INVALID", new String[]{"item=" + theName, "value=" + theValue.getValue()});
        }
        return theProperty;
    }
}

