/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.config.apoc.Template;
import org.openinstaller.bindings.config.oor.schema.ComponentSchema;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.config.PropertySheet;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.provider.conf.APOCBuilder;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.ConfigProgress;
import org.openinstaller.provider.conf.Configurator;
import org.openinstaller.provider.conf.ConfiguratorFactory;
import org.openinstaller.provider.conf.OORUtils;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.provider.conf.oor.OORDesktop;
import org.openinstaller.provider.conf.oor.OORGroup;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.WebStartUtils;
import org.openinstaller.util.desktopintegration.LocalDesktop;
import org.openinstaller.util.install.Common;
import org.openinstaller.util.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final Map<String, OORComponent> gSchemaCache = new HashMap<String, OORComponent>();
    private final Map<String, OORDesktop> gDesktopSchemaCache = new HashMap<String, OORDesktop>();
    private final Map<String, APOCTemplate> gUISchemaCache = new HashMap<String, APOCTemplate>();
    private final Map<String, String> gSchemaFileCache = new HashMap<String, String>();
    private static final String MODEL_RESOURCE_TOPDIR = "/model/";
    private static final String VIEW_RESOURCE_TOPDIR = "/view/";
    private boolean gDryRun;
    private List<OORComponent> gComponents;
    private List<OORDesktop> gDesktopComponents;
    private List<APOCTemplate> gUIComponents;
    public static final String CONFIG_JMX_NAME = "org.openinstaller.provider.conf:type=ConfigProgress";
    private MBeanServer gMBeanServer;
    private JMXConnectorServer gJMXConnectorServer = null;
    private Registry gRMIRegistry = null;
    private static final int MAX_TRIES = 20;

    public void init(ControlBus aBus) throws BusException {
        LOGGER.log(Level.FINEST, "Initializing configuration provider");
        if (WebStartUtils.IS_WEBSTART) {
            try {
                this.detectDryRun();
            }
            catch (Exception theEx) {
                throw new BusException("PARSE_ERROR", (Throwable)theEx, new String[0]);
            }
            return;
        }
        URL theMediaDirURL = Common.getMediaLocationURL();
        File theModelSchemaDirFile = new File(theMediaDirURL.getPath(), "model");
        LOGGER.log(Level.FINE, "Looking in " + theModelSchemaDirFile + "for model schemas");
        if (!(theModelSchemaDirFile.exists() && theModelSchemaDirFile.isDirectory() && theModelSchemaDirFile.canRead())) {
            throw new BusException("CANNOT_FIND_COMPONENT_SCHEMAS", new String[]{"dir=" + theModelSchemaDirFile});
        }
        File theUISchemaDirFile = new File(theMediaDirURL.getPath(), "view");
        LOGGER.log(Level.FINE, "Looking in " + theUISchemaDirFile + "for UI schemas");
        if (!(theUISchemaDirFile.exists() && theUISchemaDirFile.isDirectory() && theUISchemaDirFile.canRead())) {
            throw new BusException("CANNOT_FIND_UI_SCHEMAS", new String[]{"dir=" + theUISchemaDirFile});
        }
        try {
            this.discoverComponents(theModelSchemaDirFile);
            this.discoverUIComponents(theUISchemaDirFile);
            this.fillCache();
        }
        catch (EnhancedException theEE) {
            throw new BusException("PARSE_ERROR", (Throwable)theEE, new String[0]);
        }
        this.detectDryRun();
        try {
            this.gMBeanServer = this.createServerAndRegisterMbean();
        }
        catch (Exception theEx) {
            LOGGER.log(Level.WARNING, "CANNOT_REGISTER_MBEAN_SERVER", theEx);
        }
    }

    private void fillCache() {
        for (OORComponent oORComponent : this.gComponents) {
            this.gSchemaCache.put(oORComponent.getName(), oORComponent);
            LOGGER.log(Level.FINE, "Found and parsed component \"" + oORComponent.getName());
        }
        for (OORDesktop oORDesktop : this.gDesktopComponents) {
            this.gDesktopSchemaCache.put(oORDesktop.getName(), oORDesktop);
            LOGGER.log(Level.FINE, "Found and parsed desktop component \"" + oORDesktop.getName());
        }
        for (APOCTemplate aPOCTemplate : this.gUIComponents) {
            this.gUISchemaCache.put(aPOCTemplate.getName(), aPOCTemplate);
            LOGGER.log(Level.FINE, "Found and parsed UI component \"" + aPOCTemplate.getName());
        }
    }

    private void detectDryRun() {
        try {
            BusRequest theModeReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DRY_RUN_FILE));
            BusResponse theModeResp = ControlBus.getInstance().publishRequest(theModeReq, "svc://general/EngineConfig");
            this.gDryRun = theModeResp.getResult() != null;
        }
        catch (Exception theEx) {
            LOGGER.log(Level.WARNING, "CANNOT_DETERMINE_RUN _MODE", theEx);
        }
    }

    private void discoverComponents(File aSchemaDir) throws EnhancedException {
        String[] theSchemas;
        this.gComponents = new ArrayList<OORComponent>();
        this.gDesktopComponents = new ArrayList<OORDesktop>();
        for (String theSchema : theSchemas = aSchemaDir.list(new FilenameFilter(){

            public boolean accept(File aDir, String aName) {
                return aName.endsWith(".xcs");
            }
        })) {
            File theSchemaFile = new File(aSchemaDir, theSchema);
            try {
                OORComponent theComponentSchema = this.unmarshalOORComponent(new FileInputStream(theSchemaFile), theSchemaFile.toString());
                this.gComponents.add(theComponentSchema);
                this.gSchemaFileCache.put(theComponentSchema.getName(), theSchemaFile.getAbsolutePath());
                OORDesktop theDesktopSchema = this.unmarshalOORDesktop(new FileInputStream(theSchemaFile), theSchemaFile.toString());
                if (theDesktopSchema == null) continue;
                this.gDesktopComponents.add(theDesktopSchema);
            }
            catch (FileNotFoundException theEx) {
                throw new EnhancedException("CONFIG_SCHEMA_INVALID", (Throwable)theEx, new String[]{"file=" + theSchemaFile});
            }
            catch (EnhancedException theEx) {
                theEx.addContext("CONFIG_SCHEMA_INVALID", new String[]{"file=" + theSchemaFile});
                throw theEx;
            }
        }
    }

    private void discoverUIComponents(File aSchemaDir) throws EnhancedException {
        String[] theSchemas;
        this.gUIComponents = new ArrayList<APOCTemplate>();
        for (String theSchema : theSchemas = aSchemaDir.list(new FilenameFilter(){

            public boolean accept(File aDir, String aName) {
                return aName != null && aName.endsWith(".xml");
            }
        })) {
            File theSchemaFile = new File(aSchemaDir, theSchema);
            try {
                this.gUIComponents.add(this.unmarshalAPOCTemplate(new FileInputStream(theSchemaFile), theSchemaFile.toString()));
            }
            catch (FileNotFoundException theEx) {
                throw new EnhancedException("CONFIG_UI_SCHEMA_INVALID", (Throwable)theEx, new String[]{"resource=" + theSchemaFile.toString()});
            }
            catch (EnhancedException theEx) {
                theEx.addContext("CONFIG_UI_SCHEMA_INVALID", new String[]{"resource=" + theSchemaFile.toString()});
                throw theEx;
            }
        }
    }

    private OORComponent unmarshalOORComponent(InputStream aInputSchemaStream, String aResourceIdentifier) throws EnhancedException {
        try {
            if (aInputSchemaStream == null) {
                throw new EnhancedException("NULL_INPUT_STREAM_TO_UNMARSHAL", new String[]{"resource=" + aResourceIdentifier});
            }
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.schema");
            Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
            return OORUtils.createOORComponent((ComponentSchema)theUnMarshaller.unmarshal(aInputSchemaStream));
        }
        catch (JAXBException theEx) {
            throw new EnhancedException("CONFIG_SCHEMA_INVALID", (Throwable)theEx, new String[]{"resource=" + aResourceIdentifier});
        }
    }

    private OORDesktop unmarshalOORDesktop(InputStream aInputSchemaStream, String aResourceIdentifier) throws EnhancedException {
        try {
            if (aInputSchemaStream == null) {
                throw new EnhancedException("NULL_INPUT_STREAM_TO_UNMARSHAL", new String[]{"resource=" + aResourceIdentifier});
            }
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.schema");
            Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
            return OORUtils.createOORDesktop((ComponentSchema)theUnMarshaller.unmarshal(aInputSchemaStream));
        }
        catch (JAXBException theEx) {
            throw new EnhancedException("CONFIG_SCHEMA_INVALID", (Throwable)theEx, new String[]{"resource=" + aResourceIdentifier});
        }
    }

    private APOCTemplate unmarshalAPOCTemplate(InputStream aInputSchemaStream, String aResourceIdentifier) throws EnhancedException {
        try {
            if (aInputSchemaStream == null) {
                throw new EnhancedException("NULL_INPUT_STREAM_TO_UNMARSHAL", new String[]{"resource=" + aResourceIdentifier});
            }
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.apoc");
            Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
            return APOCBuilder.createAPOCTemplate((Template)theUnMarshaller.unmarshal(aInputSchemaStream));
        }
        catch (JAXBException theEx) {
            throw new EnhancedException("CONFIG_UI_SCHEMA_INVALID", (Throwable)theEx, new String[]{"resource=" + aResourceIdentifier});
        }
    }

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if (!ConfigControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
            return;
        }
        switch (5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[((ConfigControl)aReq.getData()).getCommand().ordinal()]) {
            case 1: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (String.class.isInstance(theData)) {
                    theName = (String)theData;
                    try {
                        aResp.setFinalResult((Object)this.findAndCacheModel(theName));
                        break;
                    }
                    catch (EnhancedException theException) {
                        aResp.setException((Exception)theException);
                        return;
                    }
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 2: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (String.class.isInstance(theData)) {
                    theName = (String)theData;
                    try {
                        aResp.setFinalResult((Object)this.findAndCacheUIModel(theName));
                        break;
                    }
                    catch (EnhancedException theException) {
                        aResp.setException((Exception)theException);
                        return;
                    }
                }
                aResp.setException((Exception)new EnhancedException("INVALID_UI_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 3: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (!String.class.isInstance(theData)) ** GOTO lbl73
                theName = (String)theData;
                thePS = new PropertySheet();
                theConfig = null;
                try {
                    theModel = this.findAndCacheModel(theName);
                    theXCSFile = new File(this.gSchemaFileCache.get(theName));
                    theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ALTERNATE_ROOT));
                    theResp = aBus.publishRequest(theReq, "svc://general/EngineConfig");
                    theAltRoot = (String)theResp.getResult();
                    thePS.read(theModel);
                    theInstalledPath = (String)ConfigHelper.getValue("InstallHome.directory.INSTALL_HOME");
                    ConfigProvider.LOGGER.fine("Initializing configurator for " + theName + " altroot: " + theAltRoot + " theXCSFile: " + theXCSFile.getAbsolutePath() + " installhome: " + theInstalledPath);
                    theConfig = ConfiguratorFactory.newConfigurator(theName, theAltRoot, theXCSFile.getAbsolutePath(), theInstalledPath);
                    if (this.gDryRun) {
                        theRR = new ResultReport(ResultReport.ResultStatus.SUCCESS, Msg.get((String)"CONFIG_DRYRUN", (Object[])new Object[0]), null, null, null);
                    } else {
                        this.initializeJMXServer(theConfig);
                        theRR = theConfig.configure(thePS, false);
                    }
                    aResp.setFinalResult((Object)theRR);
                    if (this.gDryRun || theConfig == null) ** GOTO lbl53
                    this.stopJMXServer(theConfig);
                }
                catch (EnhancedException theEx) {
                    aResp.setException((Exception)theEx);
                    break;
                }
                catch (Exception theEx) {
                    ConfigProvider.LOGGER.log(Level.SEVERE, "CANNOT_PERFORM_CONFIGURE_TASK", theEx);
                    aResp.setException(theEx);
                    break;
                    {
                        catch (Throwable var15_64) {
                            throw var15_64;
                        }
                    }
                }
                finally {
                    if (!this.gDryRun && theConfig != null) {
                        this.stopJMXServer(theConfig);
                    }
                    TempFileManager.deleteTempFiles();
                }
lbl53:
                // 2 sources

                TempFileManager.deleteTempFiles();
                break;
lbl73:
                // 1 sources

                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 4: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (String.class.isInstance(theData)) {
                    theName = (String)theData;
                    try {
                        if (this.findAndCacheModel(theName) == null) {
                            aResp.setFinalResult((Object)Boolean.FALSE);
                            break;
                        }
                        aResp.setFinalResult((Object)Boolean.TRUE);
                    }
                    catch (EnhancedException theEx) {
                        aResp.setException((Exception)theEx);
                    }
                    break;
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 5: {
                theData = ((ConfigControl)aReq.getData()).getData();
                theConfig = null;
                if (!String.class.isInstance(theData)) ** GOTO lbl127
                thePS = new PropertySheet();
                theName = (String)theData;
                try {
                    theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ALTERNATE_ROOT));
                    theResp = aBus.publishRequest(theReq, "svc://general/EngineConfig");
                    theAltRoot = (String)theResp.getResult();
                    theInstalledPath = (String)ConfigHelper.getValue("InstallHome.directory.INSTALL_HOME");
                    ConfigProvider.LOGGER.log(Level.FINE, "INSTALL HOME:" + theInstalledPath);
                    theModel = this.findAndCacheModel(theName);
                    theFilePath = this.gSchemaFileCache.get(theName);
                    ConfigProvider.LOGGER.log(Level.FINE, "FILEPATH:" + theFilePath);
                    theConfig = ConfiguratorFactory.newConfigurator(theName, theAltRoot, theFilePath, theInstalledPath);
                    this.initializeJMXServer(theConfig);
                    thePS.read(theModel);
                    theRR = theConfig.unConfigure(thePS, this.gDryRun);
                    aResp.setFinalResult((Object)theRR);
                    if (theConfig == null) ** GOTO lbl112
                    this.stopJMXServer(theConfig);
                }
                catch (EnhancedException theEx) {
                    aResp.setException((Exception)theEx);
                    break;
                }
                finally {
                    if (theConfig != null) {
                        this.stopJMXServer(theConfig);
                    }
                    TempFileManager.deleteTempFiles();
                }
lbl112:
                // 2 sources

                TempFileManager.deleteTempFiles();
                break;
lbl127:
                // 1 sources

                aResp.setException((Exception)new EnhancedException("INVALID_UNCONFIGURATION_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 6: {
                theConfigDataSheets = new ArrayList<PropertySheet>();
                theKeyListCopy = new ArrayList<String>();
                theKeyListCopy.addAll(this.gSchemaCache.keySet());
                try {
                    for (String theCompName : theKeyListCopy) {
                        theConfigSheet = new PropertySheet();
                        theConfigSheet.setAllowTransient(false);
                        theConfigSheet.read(this.gSchemaCache.get(theCompName));
                        theConfigDataSheets.add(theConfigSheet);
                    }
                }
                catch (EnhancedException theEEx) {
                    ConfigProvider.LOGGER.log(Level.WARNING, "ERROR_READING_CONFIG_DATA");
                    aResp.setException((Exception)theEEx);
                }
                aResp.setFinalResult(theConfigDataSheets);
                break;
            }
            case 7: {
                try {
                    this.setAllConfiguration();
                }
                catch (EnhancedException theEx) {
                    ConfigProvider.LOGGER.log(Level.FINE, "No persisted data");
                    aResp.setException((Exception)theEx);
                }
                break;
            }
            case 8: {
                theUITemplates = new ArrayList<APOCTemplate>();
                theUICatNames = this.gUISchemaCache.keySet();
                for (String theUICatName : theUICatNames) {
                    theTemplate = this.gUISchemaCache.get(theUICatName);
                    if (theTemplate == null) continue;
                    theUITemplates.add(theTemplate);
                }
                aResp.setFinalResult(theUITemplates);
                break;
            }
            case 9: {
                theData = ((ConfigControl)aReq.getData()).getData();
                ConfigProvider.LOGGER.finest("INSTALL_IMAGE_CONFIG called for " + theData);
                if (String.class.isInstance(theData)) {
                    theName = (String)theData;
                    theDesktop = this.gDesktopSchemaCache.get(theName);
                    try {
                        LocalDesktop.createShortcuts((OORDesktop)theDesktop);
                    }
                    catch (EnhancedException theEx) {
                        aResp.setException((Exception)theEx);
                    }
                    break;
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 10: {
                theData = ((ConfigControl)aReq.getData()).getData();
                ConfigProvider.LOGGER.finest("INSTALL_IMAGE_RESET called for " + theData);
                if (String.class.isInstance(theData)) {
                    theName = (String)theData;
                    theDesktop = this.gDesktopSchemaCache.get(theName);
                    try {
                        LocalDesktop.removeShortcuts((OORDesktop)theDesktop);
                    }
                    catch (EnhancedException theEx) {
                        aResp.setException((Exception)theEx);
                    }
                    break;
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 11: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (NotificationListener.class.isInstance(theData)) {
                    theListener = (NotificationListener)theData;
                    try {
                        this.gMBeanServer.removeNotificationListener(new ObjectName("org.openinstaller.provider.conf:type=ConfigProgress"), theListener);
                    }
                    catch (Exception theEx) {
                        aResp.setException(theEx);
                    }
                    break;
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            case 12: {
                theData = ((ConfigControl)aReq.getData()).getData();
                if (NotificationListener.class.isInstance(theData)) {
                    theListener = (NotificationListener)theData;
                    try {
                        this.gMBeanServer.addNotificationListener(new ObjectName("org.openinstaller.provider.conf:type=ConfigProgress"), theListener, null, null);
                    }
                    catch (Exception theEx) {
                        aResp.setException(theEx);
                    }
                    break;
                }
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
                break;
            }
            default: {
                aResp.setException((Exception)new EnhancedException("INVALID_CONFIG_REQUEST", new String[]{"request=" + aReq}));
            }
        }
    }

    private OORComponent findAndCacheModel(String aCompName) throws EnhancedException {
        OORComponent theModel = this.gSchemaCache.get(aCompName);
        if (theModel == null && aCompName != null) {
            if (WebStartUtils.IS_WEBSTART) {
                try {
                    BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.MEDIA_LOCATION));
                    BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
                    String theMediaDir = (String)theResp.getResult();
                    URL theMediaURL = new URL(theMediaDir);
                    URL theCompURL = new URL(theMediaURL, "model/" + aCompName + ".xcs");
                    URL theAlternateURL = new URL(System.getProperty("default.resources.url"));
                    URL theAlternateCompURL = new URL(theAlternateURL, "model/" + aCompName + ".xcs");
                    try {
                        theModel = this.unmarshalOORComponent(theAlternateCompURL.openStream(), aCompName);
                    }
                    catch (Exception theEx) {
                        theModel = this.unmarshalOORComponent(theCompURL.openStream(), aCompName);
                    }
                }
                catch (Exception theEx) {
                    theModel = null;
                }
            } else {
                LOGGER.fine("Trying to find default OOR resource [" + aCompName + "] at [" + MODEL_RESOURCE_TOPDIR + aCompName + ".xcs]");
                InputStream theResourceStream = this.getClass().getResourceAsStream(MODEL_RESOURCE_TOPDIR + aCompName + ".xcs");
                if (theResourceStream != null && !aCompName.equals((theModel = this.unmarshalOORComponent(theResourceStream, aCompName)).getName())) {
                    return null;
                }
            }
            if (theModel != null) {
                this.gSchemaCache.put(theModel.getName(), theModel);
            }
        }
        return theModel;
    }

    private APOCTemplate findAndCacheUIModel(String aCompName) throws EnhancedException {
        APOCTemplate theUIModel = this.gUISchemaCache.get(aCompName);
        if (theUIModel == null && aCompName != null) {
            if (WebStartUtils.IS_WEBSTART) {
                try {
                    BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.MEDIA_LOCATION));
                    BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
                    String theMediaDir = (String)theResp.getResult();
                    URL theMediaURL = new URL(theMediaDir);
                    URL theCompURL = new URL(theMediaURL, "view/" + aCompName + ".xml");
                    URL theAlternateURL = new URL(System.getProperty("default.resources.url"));
                    URL theAlternateCompURL = new URL(theAlternateURL, "view/" + aCompName + ".xml");
                    try {
                        theUIModel = this.unmarshalAPOCTemplate(theAlternateCompURL.openStream(), aCompName);
                    }
                    catch (Exception theEx) {
                        theUIModel = this.unmarshalAPOCTemplate(theCompURL.openStream(), aCompName);
                    }
                }
                catch (Exception theEx) {
                    LOGGER.log(Level.WARNING, "CANNOT_FIND_UI_MODELS", theEx);
                }
            } else {
                LOGGER.fine("Trying to find default APOC Template resource [" + aCompName + "] at [" + VIEW_RESOURCE_TOPDIR + aCompName + ".xml]");
                InputStream theResourceStream = this.getClass().getResourceAsStream(VIEW_RESOURCE_TOPDIR + aCompName + ".xml");
                if (theResourceStream != null && !aCompName.equals((theUIModel = this.unmarshalAPOCTemplate(theResourceStream, aCompName)).getName())) {
                    return null;
                }
            }
            if (theUIModel != null) {
                this.gUISchemaCache.put(theUIModel.getName(), theUIModel);
            }
        }
        return theUIModel;
    }

    private List<PropertySheet> readConfigurationUpdates() throws EnhancedException {
        ArrayList<PropertySheet> theConfUpdateSheets = new ArrayList<PropertySheet>();
        try {
            BusRequest theReq = new BusRequest("ConfStateReq", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.CONFIG_STATE));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theConfStateObj = theResp.getResult();
            String theConfigStateDir = "";
            if (theConfStateObj != null) {
                theConfigStateDir = (String)theConfStateObj;
            }
            if (theConfigStateDir != null && !"".equals(theConfigStateDir)) {
                LOGGER.log(Level.FINE, "Reading persisted data ...");
                File thePersistedDataPath = new File(theConfigStateDir);
                if (thePersistedDataPath.exists() && thePersistedDataPath.isDirectory()) {
                    File[] theOORUpdateFiles;
                    for (File theOORFile : theOORUpdateFiles = thePersistedDataPath.listFiles(new FilenameFilter(){

                        public boolean accept(File aDir, String aName) {
                            return aName.endsWith(".xcu");
                        }
                    })) {
                        LOGGER.log(Level.FINE, "Reading the config update files ...");
                        FileInputStream theConfUpdateInputStream = new FileInputStream(theOORFile);
                        String theCompName = theOORFile.getName().substring(0, theOORFile.getName().lastIndexOf("."));
                        LOGGER.fine("UpdateFile=" + theCompName);
                        OORComponent theDefOORComp = this.findAndCacheModel(theCompName);
                        if (theDefOORComp == null) continue;
                        PropertySheet thePS = new PropertySheet();
                        thePS.setAllowTransient(false);
                        LOGGER.fine("Reading [" + theCompName + "] from " + theOORFile);
                        thePS.read(theDefOORComp, (InputStream)theConfUpdateInputStream);
                        theConfUpdateSheets.add(thePS);
                    }
                }
            } else {
                LOGGER.log(Level.FINE, "No Config data found in " + theConfigStateDir);
            }
        }
        catch (FileNotFoundException theFNFEx) {
            throw new EnhancedException("CANNOT_FIND_UPDATE_FILE", (Throwable)theFNFEx, new String[0]);
        }
        return theConfUpdateSheets;
    }

    private void setAllConfiguration() throws EnhancedException {
        List<PropertySheet> theConfUpdateSheets = this.readConfigurationUpdates();
        if (theConfUpdateSheets.isEmpty()) {
            LOGGER.fine("NO UPDATES AVAILABLE FOR PREFILL");
            return;
        }
        LOGGER.fine("Begin prefill values ....");
        for (PropertySheet thePS : theConfUpdateSheets) {
            List<OORGroup> theOORGroups;
            Map theNewPropVals = thePS.getAllProps();
            String theCompName = thePS.getComponentName();
            LOGGER.fine("Looking into component [" + theCompName + "]");
            OORComponent theOORComp = this.findAndCacheModel(theCompName);
            if (theOORComp == null || (theOORGroups = theOORComp.getGroups()).isEmpty()) continue;
            for (OORGroup theGroup : theOORGroups) {
                LOGGER.fine("Looking into group [" + theGroup.getName() + "]");
                List<OORProp> theOORProps = theGroup.getProperties();
                for (OORProp theOORProp : theOORProps) {
                    String theNewValue;
                    if (theOORProp.isTransient() || (theNewValue = (String)theNewPropVals.get(theOORProp.getName())) == null) continue;
                    LOGGER.fine("Setting current value of [" + theOORProp.getName() + "] to [" + theNewValue + "]");
                    theOORProp.setUnconfirmedValue(ConfigHelper.thaw(theNewValue, theOORProp.getType()));
                }
            }
        }
    }

    private void initializeJMXServer(Configurator aConfig) {
        int theRMIPort = 0;
        try {
            int theTries = 0;
            while (this.gRMIRegistry == null) {
                theRMIPort = 2000 + (int)(Math.random() * 2000.0);
                try {
                    this.gRMIRegistry = LocateRegistry.createRegistry(theRMIPort);
                    System.setProperty("INIT_CONFIG_PROGRESS_RMIPORT", Integer.toString(theRMIPort));
                }
                catch (RemoteException theEx) {
                    LOGGER.log(Level.WARNING, "tried port " + theRMIPort, theEx);
                    if (++theTries <= 20) continue;
                    LOGGER.log(Level.WARNING, "CANT_FIND_PORT", new String[]{"port=2000", "port=4000"});
                    return;
                }
            }
            this.gMBeanServer.addNotificationListener(new ObjectName(CONFIG_JMX_NAME), aConfig, null, null);
            this.gJMXConnectorServer = ConfigProvider.createConnectorServer(theRMIPort, this.gMBeanServer);
            this.gJMXConnectorServer.start();
        }
        catch (Exception theEx) {
            LogUtils.log((Logger)LOGGER, (Level)Level.WARNING, (String)"CANT_START_SERVER", (Throwable)theEx, (String[])new String[]{"port=" + theRMIPort});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopJMXServer(Configurator aConfig) {
        if (this.gJMXConnectorServer != null) {
            try {
                this.gJMXConnectorServer.stop();
            }
            catch (IOException theEx) {
                LOGGER.log(Level.FINE, "CANT_START_SERVER", theEx);
            }
            finally {
                this.gJMXConnectorServer = null;
            }
        }
        if (aConfig != null) {
            try {
                this.gMBeanServer.removeNotificationListener(new ObjectName(CONFIG_JMX_NAME), aConfig);
            }
            catch (Exception theEx) {
                LOGGER.log(Level.FINE, "Cannot remove connector server", theEx);
            }
        }
        if (this.gRMIRegistry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.gRMIRegistry, true);
            }
            catch (Exception theEx) {
                LOGGER.log(Level.FINE, "Cannot stop RMI server", theEx);
            }
            finally {
                this.gRMIRegistry = null;
            }
        }
        TempFileManager.deleteTempFiles();
    }

    private MBeanServer createServerAndRegisterMbean() throws Exception {
        MBeanServer theMBeanServer = MBeanServerFactory.createMBeanServer();
        System.setProperty("INIT_CONFIG_PROGRESS_OBJECTNAME", CONFIG_JMX_NAME);
        ConfigProgress theMbean = new ConfigProgress();
        theMBeanServer.registerMBean(theMbean, new ObjectName(CONFIG_JMX_NAME));
        return theMBeanServer;
    }

    private static JMXConnectorServer createConnectorServer(int aRMIPort, MBeanServer aServer) throws Exception {
        final String thePassword = "oiconfigpassword" + new Random().nextInt();
        System.setProperty("INIT_CONFIG_PROGRESS_PASSWORD", thePassword);
        HashMap<String, 4> theEnv = new HashMap<String, 4>();
        JMXAuthenticator theAuth = new JMXAuthenticator(){

            public Subject authenticate(Object aCred) throws SecurityException {
                if (thePassword.equals(aCred)) {
                    Subject theSub = new Subject();
                    theSub.getPrincipals().add(new JMXPrincipal("oiconfiguser"));
                    theSub.setReadOnly();
                    return theSub;
                }
                throw new SecurityException("Invalid security credentials: " + aCred);
            }
        };
        theEnv.put("jmx.remote.authenticator", theAuth);
        JMXServiceURL theRMIurl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + aRMIPort + "/server");
        JMXConnectorServer theConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(theRMIurl, theEnv, aServer);
        return theConnectorServer;
    }

    public String getName() {
        return "svc://general/conf";
    }

    static class 5 {
        static final /* synthetic */ int[] $SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand;

        static {
            $SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand = new int[ConfigControl.ConfigCommand.values().length];
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.GET_CONFIG_MODEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.GET_CONFIG_UI_MODEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.CONFIGURE_COMPONENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.CAN_CONFIGURE_COMPONENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.RESET.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.GET_ALL_CONFIGURATION.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.SET_ALL_CONFIGURATION.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.GET_ALL_UI_CONFIG.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.INSTALL_IMAGE_CONFIG.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.INSTALL_IMAGE_RESET.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.REMOVE_CONFIG_PROGRESS_LISTENER.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                5.$SwitchMap$org$openinstaller$provider$conf$ConfigControl$ConfigCommand[ConfigControl.ConfigCommand.ADD_CONFIG_PROGRESS_LISTENER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

