/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.Configurator;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public final class ConfiguratorFactory {
    private static final Logger LOGGER;
    public static final String DEFAULT_CONFIGURATOR_CLASS_NAME = "org.openinstaller.provider.conf.CLIConfigurator";
    public static final String CONFIGURATOR_CLASS_KEY = "org.openinstaller.provider.configurator.class";
    public static final String CONFIGURATOR_CLASS_NAME;
    private static final Constructor<?> CONSTRUCTOR;

    private ConfiguratorFactory() {
    }

    public static Configurator newConfigurator(String aProductName, String aAltRootDir, String aXCSFilePath, String aInstallDir) {
        try {
            return (Configurator)CONSTRUCTOR.newInstance(aProductName, aAltRootDir, aXCSFilePath, aInstallDir);
        }
        catch (Exception theEx) {
            LOGGER.log(Level.SEVERE, "LOG_EXCEPTION", theEx);
            throw new IllegalStateException(theEx);
        }
    }

    static {
        CONFIGURATOR_CLASS_NAME = System.getProperty(CONFIGURATOR_CLASS_KEY, DEFAULT_CONFIGURATOR_CLASS_NAME);
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
        try {
            Class<?> theClass = Class.forName(CONFIGURATOR_CLASS_NAME, true, ConfiguratorFactory.class.getClassLoader());
            LOGGER.log(Level.INFO, "LOG_INFO", theClass);
            CONSTRUCTOR = theClass.getConstructor(String.class, String.class, String.class, String.class);
        }
        catch (Exception theEx) {
            LOGGER.log(Level.SEVERE, "LOG_EXCEPTION", theEx);
            EnhancedException.getLastCause(null).getLocalizedMessage();
            throw new ExceptionInInitializerError(theEx);
        }
    }
}

