/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bindings.config.oor.schema.ComponentSchema;
import org.openinstaller.bindings.config.oor.schema.Desktop;
import org.openinstaller.bindings.config.oor.schema.Group;
import org.openinstaller.bindings.config.oor.schema.PathType;
import org.openinstaller.bindings.config.oor.schema.Prop;
import org.openinstaller.bindings.config.oor.schema.RelativeType;
import org.openinstaller.bindings.config.oor.schema.ShortcutType;
import org.openinstaller.bindings.config.oor.schema.Value;
import org.openinstaller.provider.conf.CompareToImpl;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.oor.ConfigType;
import org.openinstaller.provider.conf.oor.Constraint;
import org.openinstaller.provider.conf.oor.EnumerationConstraint;
import org.openinstaller.provider.conf.oor.LengthConstraint;
import org.openinstaller.provider.conf.oor.MaxExclusiveConstraint;
import org.openinstaller.provider.conf.oor.MaxInclusiveConstraint;
import org.openinstaller.provider.conf.oor.MaxLengthConstraint;
import org.openinstaller.provider.conf.oor.MinExclusiveConstraint;
import org.openinstaller.provider.conf.oor.MinInclusiveConstraint;
import org.openinstaller.provider.conf.oor.MinLengthConstraint;
import org.openinstaller.provider.conf.oor.OORAddRemoveEntry;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.provider.conf.oor.OORDesktop;
import org.openinstaller.provider.conf.oor.OORGroup;
import org.openinstaller.provider.conf.oor.OORPathType;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.provider.conf.oor.OORRelativeType;
import org.openinstaller.provider.conf.oor.OORShortcut;
import org.openinstaller.provider.conf.oor.OORShortcutType;
import org.openinstaller.provider.conf.oor.PatternConstraint;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OORUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private OORUtils() {
    }

    public static OORComponent createOORComponent(ComponentSchema aComponentSchema) throws EnhancedException {
        String theName = aComponentSchema.getName();
        String thePackage = aComponentSchema.getPackage();
        String theVersion = aComponentSchema.getVersion();
        OORComponent theComponent = new OORComponent(theName, thePackage, new Version(theVersion));
        ComponentSchema.Component theOORComp = aComponentSchema.getComponent();
        for (Object theParsedGroup : theOORComp.getPropOrNodeRefOrGroup()) {
            if (!Group.class.isInstance(theParsedGroup)) {
                LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
                continue;
            }
            Group theGroup = (Group)theParsedGroup;
            OORGroup theOORGroup = OORUtils.createOORGroup(theGroup);
            theComponent.addGroup(theOORGroup);
            for (Object thePropSpec : theGroup.getPropOrGroupOrSet()) {
                if (!Prop.class.isInstance(thePropSpec)) {
                    LOGGER.log(Level.WARNING, "IGNORING_UNSUPPORTED_CONFIG_OPTION");
                    continue;
                }
                Prop theProp = (Prop)thePropSpec;
                OORProp theOORProp = OORUtils.createOORProp(theProp);
                theOORGroup.addProperty(theOORProp);
            }
        }
        return theComponent;
    }

    private static OORGroup createOORGroup(Group aGroup) {
        return new OORGroup(aGroup.getName());
    }

    private static OORProp createOORProp(Prop aProp) throws EnhancedException {
        ConfigType theType;
        String theName = aProp.getName();
        try {
            theType = ConfigType.getTypeForString(aProp.getType());
        }
        catch (InvalidArgumentException theEx) {
            throw new EnhancedException("INVALID_CONFIG_SCHEMA", (Throwable)theEx, new String[]{"property=" + theName});
        }
        List theListDefVal = aProp.getValue();
        ArrayList<CompareToImpl> theList = new ArrayList<CompareToImpl>();
        HashMap<String, Value> theKeyVal = new HashMap<String, Value>();
        Value theDefVal = null;
        String theOSType = null;
        String theOSName = null;
        String theOSArch = null;
        String theOSVersion = null;
        for (Value theTempDefVal : theListDefVal) {
            theOSType = theTempDefVal.getOsType();
            theOSName = theTempDefVal.getOsName();
            theOSArch = theTempDefVal.getOsArch();
            theOSVersion = theTempDefVal.getOsVersion();
            CompareToImpl theValueObject = new CompareToImpl();
            if (theOSType != null) {
                theValueObject.setProperty("osType", theOSType);
            }
            if (theOSName != null) {
                theValueObject.setProperty("osName", theOSName);
            }
            if (theOSArch != null) {
                theValueObject.setProperty("osArch", theOSArch);
            }
            if (theOSVersion != null) {
                theValueObject.setProperty("osVersion", theOSVersion);
            }
            theValueObject.setProperty("Def-Value", theTempDefVal.toString());
            theKeyVal.put(theTempDefVal.toString(), theTempDefVal);
            theList.add(theValueObject);
        }
        Collections.reverse(theList);
        for (CompareToImpl theValueProp : theList) {
            Value theTempValue;
            Platform thePlatform;
            theOSType = theValueProp.getProperty("osType");
            theOSName = theValueProp.getProperty("osName");
            theOSArch = theValueProp.getProperty("osArch");
            theOSVersion = theValueProp.getProperty("osVersion");
            if (theOSType == null) {
                theOSType = "UNDEFINED";
            }
            if (theOSName == null) {
                theOSName = "UNDEFINED";
            }
            if (theOSArch == null) {
                theOSArch = "UNDEFINED";
            }
            if (theOSVersion == null) {
                theOSVersion = "0";
            }
            if (!(thePlatform = new Platform(Platform.getOSTypeForString((String)theOSType), Platform.getOSNameForString((String)theOSName), Platform.getArchForString((String)theOSArch), new VersionRange(new Version(theOSVersion), true, Version.INFINITY, false))).isCompatible()) continue;
            String theTempString = theValueProp.getProperty("Def-Value");
            theDefVal = theTempValue = (Value)theKeyVal.get(theTempString);
            break;
        }
        String theRawValue = null;
        String theSeparator = "";
        if (theDefVal != null) {
            List theRawValues = theDefVal.getValue();
            theSeparator = theDefVal.getSeparator();
            theRawValue = OORUtils.concat(theRawValues);
        }
        Object theThawedDefaultValue = ConfigHelper.thaw(theRawValue, theType);
        OORProp theProp = new OORProp(theName, theType, theThawedDefaultValue, theThawedDefaultValue, theSeparator);
        if (null == theDefVal) {
            theProp.setEval(null);
            theProp.setEvalEngine(null);
        } else {
            theProp.setEval(theDefVal.getEval());
            theProp.setEvalEngine(theDefVal.getEvalEngine());
        }
        theProp.setTransient(aProp.isTransient());
        theProp.setNillable(aProp.isNillable());
        if (!aProp.isNillable() && theDefVal == null) {
            throw new EnhancedException("MISSING_DEFAULT_VALUE", new String[]{"propertyname=" + aProp.getName()});
        }
        Prop.Constraints theConstraints = aProp.getConstraints();
        if (theConstraints != null) {
            OORUtils.addConstraints(theProp, theConstraints);
        }
        if (aProp.getActions() != null) {
            theProp.setOnSetAction(aProp.getActions().getOnSet());
            theProp.setOnInvalidValueSetAction(aProp.getActions().getOnInvalidValueSet());
        }
        return theProp;
    }

    private static void addConstraints(OORProp aProp, Prop.Constraints aConstraints) throws EnhancedException {
        org.openinstaller.bindings.config.oor.schema.Constraint theMinLength = aConstraints.getMinLength();
        org.openinstaller.bindings.config.oor.schema.Constraint theMaxLength = aConstraints.getMaxLength();
        org.openinstaller.bindings.config.oor.schema.Constraint theLength = aConstraints.getLength();
        org.openinstaller.bindings.config.oor.schema.Constraint theMinInc = aConstraints.getMinInclusive();
        org.openinstaller.bindings.config.oor.schema.Constraint theMaxInc = aConstraints.getMaxInclusive();
        org.openinstaller.bindings.config.oor.schema.Constraint theMinExc = aConstraints.getMinExclusive();
        org.openinstaller.bindings.config.oor.schema.Constraint theMaxExc = aConstraints.getMaxExclusive();
        org.openinstaller.bindings.config.oor.schema.Constraint thePattern = aConstraints.getPattern();
        List theEnum = aConstraints.getEnumeration();
        try {
            if (theMinLength != null) {
                aProp.addConstraint(new MinLengthConstraint(Integer.parseInt(theMinLength.getValue())));
            }
            if (theMaxLength != null) {
                aProp.addConstraint(new MaxLengthConstraint(Integer.parseInt(theMaxLength.getValue())));
            }
            if (theLength != null) {
                aProp.addConstraint(new LengthConstraint(Integer.parseInt(theLength.getValue())));
            }
            if (theMinInc != null) {
                aProp.addConstraint(new MinInclusiveConstraint(Integer.parseInt(theMinInc.getValue())));
            }
            if (theMaxInc != null) {
                aProp.addConstraint(new MaxInclusiveConstraint(Integer.parseInt(theMaxInc.getValue())));
            }
            if (theMinExc != null) {
                aProp.addConstraint(new MinExclusiveConstraint(Integer.parseInt(theMinExc.getValue())));
            }
            if (theMaxExc != null) {
                aProp.addConstraint(new MaxExclusiveConstraint(Integer.parseInt(theMaxExc.getValue())));
            }
            if (thePattern != null) {
                aProp.addConstraint(new PatternConstraint(thePattern.getValue()));
            }
            if (theEnum != null && !theEnum.isEmpty()) {
                EnumerationConstraint theEnumConstraint = new EnumerationConstraint();
                for (org.openinstaller.bindings.config.oor.schema.Constraint theTempEnum : theEnum) {
                    theEnumConstraint.addEnumConstraint(theTempEnum.getValue());
                }
                aProp.addConstraint(theEnumConstraint);
            }
        }
        catch (NumberFormatException theEx) {
            throw new EnhancedException("SCHEMA_CONSTRAINT_INVALID", (Throwable)theEx, new String[0]);
        }
        Constraint theFailedConstraint = null;
        if (aProp.getDefaultValue() != null && !"".equals(aProp.getDefaultValue())) {
            theFailedConstraint = aProp.setValue(aProp.getDefaultValue());
        }
        if (theFailedConstraint != null) {
            throw new EnhancedException("CONFIG_SCHEMA_DEFAULT_INVALID", new String[]{"item=" + aProp.getName(), "value=" + aProp.getDefaultValue()});
        }
    }

    public static String concat(List<String> aRawValues) {
        StringBuffer theFinal = new StringBuffer();
        for (String theRawValue : aRawValues) {
            theFinal.append(theRawValue);
            theFinal.append(' ');
        }
        return theFinal.toString().trim();
    }

    public static OORDesktop createOORDesktop(ComponentSchema aComponentSchema) throws EnhancedException {
        OORDesktop theOORDesktop = null;
        Desktop theDesktop = aComponentSchema.getDesktop();
        if (theDesktop != null) {
            theOORDesktop = new OORDesktop(aComponentSchema.getName());
            List theShortcuts = theDesktop.getShortcut();
            Desktop.Addremoveentry theAddremoveentry = theDesktop.getAddremoveentry();
            if (theAddremoveentry != null) {
                OORAddRemoveEntry theOORAddRemoveEntry = new OORAddRemoveEntry();
                String theDisplayName = theAddremoveentry.getName();
                theOORAddRemoveEntry.setDisplayName(theDisplayName);
                String theDisplayIcon = theAddremoveentry.getIcon();
                theOORAddRemoveEntry.setDisplayIcon(theDisplayIcon);
                String theUninstallString = theAddremoveentry.getUninstallstring();
                theOORAddRemoveEntry.setUninstallString(theUninstallString);
                theOORDesktop.setAddRemoveEntry(theOORAddRemoveEntry);
            }
            for (Desktop.Shortcut theShortcut : theShortcuts) {
                OORShortcut theOORShortcut = new OORShortcut(theShortcut.getName(), OORUtils.getOORShortcutType(theShortcut.getType()));
                theOORShortcut.setRunInTerminal(theShortcut.isRunInTerminal());
                OORPathType theOORPathType = new OORPathType();
                PathType theTarget = theShortcut.getTarget();
                theOORPathType.setPath(theTarget.getPath());
                if (theTarget.getArgs() != null) {
                    theOORPathType.setArgs(theTarget.getArgs());
                }
                if (theTarget.getRelative() != null) {
                    theOORPathType.setRelative(OORUtils.getOORRelativeType(theTarget.getRelative()));
                }
                theOORShortcut.setTarget(theOORPathType);
                theOORPathType = new OORPathType();
                PathType theLocation = theShortcut.getLocation();
                theOORPathType.setPath(theLocation.getPath());
                if (theLocation.getArgs() != null) {
                    theOORPathType.setArgs(theLocation.getArgs());
                }
                if (theLocation.getRelative() != null) {
                    theOORPathType.setRelative(OORUtils.getOORRelativeType(theLocation.getRelative()));
                }
                theOORShortcut.setLocation(theOORPathType);
                theOORPathType = new OORPathType();
                PathType theIcon = theShortcut.getIcon();
                theOORPathType.setPath(theIcon.getPath());
                if (theIcon.getArgs() != null) {
                    theOORPathType.setArgs(theIcon.getArgs());
                }
                if (theIcon.getRelative() != null) {
                    theOORPathType.setRelative(OORUtils.getOORRelativeType(theIcon.getRelative()));
                }
                theOORShortcut.setIcon(theOORPathType);
                theOORDesktop.addShortcut(theOORShortcut);
            }
        }
        return theOORDesktop;
    }

    private static OORRelativeType getOORRelativeType(RelativeType aRelType) {
        OORRelativeType theOORRelType = null;
        switch (aRelType) {
            case USER_DESKTOP_FOLDER: {
                theOORRelType = OORRelativeType.OOR_USER_DESKTOP_FOLDER;
                break;
            }
            case ALL_DESKTOP_FOLDER: {
                theOORRelType = OORRelativeType.OOR_ALL_DESKTOP_FOLDER;
                break;
            }
            case USER_PROGRAM_MENU: {
                theOORRelType = OORRelativeType.OOR_USER_PROGRAM_MENU;
                break;
            }
            case ALL_PROGRAM_MENU: {
                theOORRelType = OORRelativeType.OOR_ALL_PROGRAM_MENU;
                break;
            }
            case USER_START_MENU: {
                theOORRelType = OORRelativeType.OOR_USER_START_MENU;
                break;
            }
            case ALL_START_MENU: {
                theOORRelType = OORRelativeType.OOR_ALL_START_MENU;
                break;
            }
            case INSTALL_HOME: {
                theOORRelType = OORRelativeType.OOR_INSTALL_HOME;
                break;
            }
            case NONE: {
                theOORRelType = OORRelativeType.OOR_NONE;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "ILLEGAL_RELATIVE_TYPE");
            }
        }
        return theOORRelType;
    }

    private static OORShortcutType getOORShortcutType(ShortcutType aShortcutType) {
        OORShortcutType theOORShortcutType = null;
        switch (aShortcutType) {
            case APPLICATION: {
                theOORShortcutType = OORShortcutType.OOR_APPLICATION;
                break;
            }
            case LINK: {
                theOORShortcutType = OORShortcutType.OOR_LINK;
                break;
            }
            case URL: {
                theOORShortcutType = OORShortcutType.OOR_URL;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "ILLEGAL_SHORTCUT_TYPE");
            }
        }
        return theOORShortcutType;
    }
}

