/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class TeeInputStream
extends FilterInputStream {
    private Logger gLogger;
    private Level gLevel;
    private String gIdentifier;
    public static final int LOG_TRIGGER_LEN = 1024;
    private ByteArrayOutputStream gBuf = new ByteArrayOutputStream();

    public TeeInputStream(InputStream aIn, Logger aLogger, Level aLevel, String aId) {
        super(aIn);
        this.gLogger = aLogger;
        this.gLevel = aLevel;
        this.gIdentifier = aId;
    }

    public int read() throws IOException {
        int theByte = super.read();
        if (theByte == -1) {
            return theByte;
        }
        this.gBuf.write(theByte);
        if (this.gBuf.size() >= 1024) {
            this.flushText();
        }
        return theByte;
    }

    public int read(byte[] aByteArray) throws IOException {
        int theResult = super.read(aByteArray);
        if (theResult == -1) {
            return theResult;
        }
        this.gBuf.write(aByteArray, 0, theResult);
        if (this.gBuf.size() >= 1024) {
            this.flushText();
        }
        return theResult;
    }

    public int read(byte[] aByteArray, int aOffset, int aLen) throws IOException {
        int theResult = super.read(aByteArray, aOffset, aLen);
        if (theResult == -1) {
            return theResult;
        }
        this.gBuf.write(aByteArray, aOffset, theResult);
        if (this.gBuf.size() >= 1024) {
            this.flushText();
        }
        return theResult;
    }

    public void close() throws IOException {
        if (this.gBuf.size() > 0) {
            this.flushText();
        }
        super.close();
    }

    private void flushText() {
        this.gLogger.log(this.gLevel, "RAW_DATA", new String[]{"id=" + this.gIdentifier, "data=[" + this.gBuf.toString() + "]"});
        this.gBuf.reset();
    }
}

