/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.logging.Logger;
import org.openinstaller.provider.conf.apoc.APOCPage;
import org.openinstaller.provider.conf.apoc.APOCScope;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public final class APOCCategory {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final String gName;
    private String gScope;
    private final String gLabel;
    private String gInlineHelp;
    private APOCPage gPage;

    public APOCCategory(String aName, String aLabel) {
        this.gName = aName;
        this.gLabel = aLabel;
    }

    public String getName() {
        return this.gName;
    }

    public String getScope() {
        return this.gScope;
    }

    public APOCCategory setScope(String aScope) throws EnhancedException {
        APOCScope theAPOCScope = APOCScope.getScopeForString(aScope);
        this.gScope = theAPOCScope != null ? theAPOCScope.getScopeSpecifier() : null;
        return this;
    }

    public String getLabel() {
        return this.gLabel;
    }

    public String getInlineHelp() {
        return this.gInlineHelp;
    }

    public APOCCategory setInlineHelp(String aInlineHelp) {
        this.gInlineHelp = aInlineHelp;
        return this;
    }

    public APOCPage getPage() {
        return this.gPage;
    }

    public APOCCategory setPage(APOCPage aPage) {
        this.gPage = aPage;
        return this;
    }
}

