/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openinstaller.provider.conf.apoc.APOCConstraintImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APOCEnumerationConstraint
extends APOCConstraintImpl {
    private List<Object> gEnumeration = new Vector<Object>();
    private Map<Object, Object> gEnumerationMap = new LinkedHashMap<Object, Object>();
    private Map<String, String> gToolTipMap = new LinkedHashMap<String, String>();

    public APOCEnumerationConstraint addEnumConstraint(Object aValue, Object aLabel) {
        this.gEnumeration.add(aValue);
        this.gEnumerationMap.put(aValue, aLabel);
        return this;
    }

    public APOCEnumerationConstraint addToolTip(String aValue, String aToolTip) {
        this.gToolTipMap.put(aValue, aToolTip);
        return this;
    }

    @Override
    public boolean isValid(Object aValue) {
        if (!String.class.isInstance(aValue) && !Integer.class.isInstance(aValue)) {
            this.setLastViolation("\"" + aValue + "\" is not of the String or Integer type");
            return false;
        }
        Object theValue = null;
        if (String.class.isInstance(aValue)) {
            theValue = aValue.toString();
        } else if (Integer.class.isInstance(aValue)) {
            theValue = (Integer)aValue;
        }
        if (!this.gEnumeration.contains(theValue)) {
            this.setLastViolation("\"" + aValue + "\" is not equal to the enumeration constraint");
            return false;
        }
        return true;
    }

    public Map<Object, Object> getEnumeration() {
        return this.gEnumerationMap;
    }

    public Map<String, String> getToolTipMap() {
        return this.gToolTipMap;
    }
}

