/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCScope;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APOCSection {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final String gName;
    private String gScope;
    private final String gLabel;
    private final List<APOCProperty> gProperties;

    public APOCSection(String aName, String aLabel) {
        this.gName = aName;
        this.gLabel = aLabel;
        this.gProperties = new Vector<APOCProperty>();
    }

    public String getName() {
        return this.gName;
    }

    public String getScope() {
        return this.gScope;
    }

    public APOCSection setScope(String aScope) throws EnhancedException {
        APOCScope theAPOCScope = APOCScope.getScopeForString(aScope);
        this.gScope = theAPOCScope != null ? theAPOCScope.getScopeSpecifier() : null;
        return this;
    }

    public String getLabel() {
        return this.gLabel;
    }

    public List<APOCProperty> getProperties() {
        return this.gProperties;
    }

    public APOCSection addProperty(APOCProperty aProperty) {
        this.gProperties.add(aProperty);
        return this;
    }
}

