/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import org.openinstaller.util.InvalidArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum APOCType {
    APOCSTRING("xs:string"),
    APOCBOOLEAN("xs:boolean"),
    APOCSHORT("xs:short"),
    APOCINT("xs:int"),
    APOCLONG("xs:long"),
    APOCDOUBLE("xs:double"),
    APOCHEXBINARY("xs:hexBinary"),
    APOCANY("oor:any"),
    APOCLONGLIST("oor:long-list"),
    APOCSHORTLIST("oor:short-list"),
    APOCINTLIST("oor:int-list");

    private String gType;

    private APOCType(String aType) {
        this.gType = aType;
    }

    public String getTypeSpecifier() {
        return this.gType;
    }

    public static APOCType getTypeForString(String aTypeString) throws InvalidArgumentException {
        for (APOCType theType : APOCType.values()) {
            if (!aTypeString.equals(theType.getTypeSpecifier())) continue;
            return theType;
        }
        throw new InvalidArgumentException("INVALID_APOC_TYPE", new String[]{"type=" + aTypeString});
    }
}

