/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.debug;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.util.ClassUtils;

public final class DebugProvider
implements ServiceProvider {
    public static final int BSH_TELNET_PORT = 6660;
    private boolean gInitCompleteFlag = false;
    private Object gInterp = null;
    private Method gEvalMethod = null;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public void init(ControlBus aBus) {
        try {
            Class<?> theInterpClass = Class.forName("bsh.Interpreter");
            this.gInterp = theInterpClass.newInstance();
            Method theSetStringMethod = theInterpClass.getMethod("set", String.class, Object.class);
            Method theSetIntMethod = theInterpClass.getMethod("set", String.class, Integer.TYPE);
            this.gEvalMethod = theInterpClass.getMethod("eval", String.class);
            theSetStringMethod.invoke(this.gInterp, "bus", aBus);
            theSetIntMethod.invoke(this.gInterp, "portnum", 6660);
            this.gEvalMethod.invoke(this.gInterp, "this.interpreter.setClassLoader(bus.getClass().getClassLoader())");
            this.gEvalMethod.invoke(this.gInterp, "Thread.currentThread().setContextClassLoader(bus.getClass().getClassLoader())");
            this.gEvalMethod.invoke(this.gInterp, "import org.openinstaller.core.*");
            this.gEvalMethod.invoke(this.gInterp, "import org.openinstaller.util.*");
            this.gEvalMethod.invoke(this.gInterp, "import org.openinstaller.bus.*");
            this.gEvalMethod.invoke(this.gInterp, "import bsh.util.Httpd");
            this.gEvalMethod.invoke(this.gInterp, "import bsh.util.Sessiond");
            this.gEvalMethod.invoke(this.gInterp, "setAccessibility(true)");
            this.gEvalMethod.invoke(this.gInterp, "Sessiond sd = new Sessiond(global.namespace, portnum+1)");
            this.gEvalMethod.invoke(this.gInterp, "sd.ss.setReuseAddress(true)");
            this.gEvalMethod.invoke(this.gInterp, "new Thread(sd).start()");
            this.gEvalMethod.invoke(this.gInterp, "Httpd hd = new Httpd(portnum)");
            this.gEvalMethod.invoke(this.gInterp, "hd.ss.setReuseAddress(true)");
            this.gEvalMethod.invoke(this.gInterp, "new Thread(hd).start()");
            this.gEvalMethod.invoke(this.gInterp, "bsh.prompt=\"openInstaller> \"");
            this.gInitCompleteFlag = true;
        }
        catch (NoSuchMethodException theEx) {
            LOGGER.log(Level.WARNING, "CANT_LOAD_BEANSHELL", theEx);
            LOGGER.log(Level.WARNING, "NO_DEBUG_FACIL_AVAIL");
        }
        catch (IllegalAccessException theEx) {
            LOGGER.log(Level.WARNING, "CANT_LOAD_BEANSHELL", theEx);
            LOGGER.log(Level.WARNING, "NO_DEBUG_FACIL_AVAIL");
        }
        catch (InvocationTargetException theEx) {
            LOGGER.log(Level.WARNING, "CANT_LOAD_BEANSHELL", theEx);
            LOGGER.log(Level.WARNING, "NO_DEBUG_FACIL_AVAIL");
        }
        catch (InstantiationException theEx) {
            LOGGER.log(Level.WARNING, "CANT_LOAD_BEANSHELL", theEx);
            LOGGER.log(Level.WARNING, "NO_DEBUG_FACIL_AVAIL");
        }
        catch (ClassNotFoundException theEx) {
            LOGGER.log(Level.WARNING, "CANT_LOAD_BEANSHELL", theEx);
            LOGGER.log(Level.WARNING, "NO_DEBUG_FACIL_AVAIL");
        }
    }

    public void shutdown() {
        try {
            this.gEvalMethod.invoke(this.gInterp, "sd.ss.close()");
            this.gEvalMethod.invoke(this.gInterp, "hd.ss.close()");
        }
        catch (IllegalAccessException theEx) {
            LOGGER.log(Level.FINE, "Cannot shut down debug provider", theEx);
        }
        catch (InvocationTargetException theEx) {
            LOGGER.log(Level.FINE, "Cannot shut down debug provider", theEx);
        }
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
    }

    public String getName() {
        return "svc://general/debug";
    }

    public boolean getInitCompleteFlag() {
        return this.gInitCompleteFlag;
    }
}

