/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.component.CapabilityRef;
import org.openinstaller.bindings.component.CapabilityRefs;
import org.openinstaller.bindings.component.Component;
import org.openinstaller.bindings.component.ComponentRef;
import org.openinstaller.bindings.component.ComponentRefs;
import org.openinstaller.bindings.component.CompositeUnit;
import org.openinstaller.bindings.component.Description;
import org.openinstaller.bindings.component.Features;
import org.openinstaller.bindings.component.Identity;
import org.openinstaller.bindings.component.InstallableUnit;
import org.openinstaller.bindings.component.Item;
import org.openinstaller.bindings.component.KeyItems;
import org.openinstaller.bindings.component.KeyReg;
import org.openinstaller.bindings.component.Parameter;
import org.openinstaller.bindings.component.Payload;
import org.openinstaller.bindings.component.PrequalifiedCompatibleVersions;
import org.openinstaller.bindings.component.PrequalifiedDiscreteVersion;
import org.openinstaller.bindings.component.PrequalifiedDiscreteVersions;
import org.openinstaller.bindings.component.PrequalifiedRangeVersion;
import org.openinstaller.bindings.component.PrequalifiedRangeVersions;
import org.openinstaller.bindings.component.Realization;
import org.openinstaller.bindings.component.Requirements;
import org.openinstaller.provider.dependency.InstallableUnitParameter;
import org.openinstaller.provider.dependency.KeyValueStringPair;
import org.openinstaller.provider.dependency.L10nInstallableUnitKeyValue;
import org.openinstaller.provider.dependency.PlatformInstUnit;
import org.openinstaller.provider.dependency.PreConfiguredKeyValue;
import org.openinstaller.provider.dependency.RequirementKeyValue;
import org.openinstaller.provider.dependency.VersionObject;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.LocaleUtils;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescriptor {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final String XMLNAMESPACE = "org.openinstaller.bindings.component";
    private URL gURL;
    private Component gComponent;
    private Unmarshaller gXMLUnmarshaller;
    private Identity gIdentity = null;
    private Features gFeatures = null;
    private Requirements gRequirements = null;
    private Payload gPayload = null;
    private final VersionObject gTempVersionObject = new VersionObject();
    private final List<String> gFeaturesID = new ArrayList<String>();
    private final Map<String, VersionObject> gRequirementsCapabilityMap = new HashMap<String, VersionObject>();
    private final Map<String, VersionObject> gRequirementsComponentMap = new HashMap<String, VersionObject>();
    private final Map<String, VersionObject> gCompositeUnitToCPVersionMap = new HashMap<String, VersionObject>();
    private final Map<String, List<String>> gCompositeUnitToOSVersionMap = new HashMap<String, List<String>>();
    private final Map<String, String> gAlternateRealizationsToDefaultMap = new HashMap<String, String>();
    private final Map<String, List<L10nInstallableUnitKeyValue>> gCompositeUnitToInstallableUnitMap = new HashMap<String, List<L10nInstallableUnitKeyValue>>();
    private final Map<String, List<RequirementKeyValue>> gCompositeUnitToRequirementMap = new HashMap<String, List<RequirementKeyValue>>();
    private final Map<String, List<InstallableUnitParameter>> gCompositeUnitToParametersMap = new HashMap<String, List<InstallableUnitParameter>>();
    private final Map<String, List<RequirementKeyValue>> gCompositeUnitToKeyRegMap = new HashMap<String, List<RequirementKeyValue>>();
    private final Map<String, List<String>> gCompositeUnitToKeyFilesMap = new HashMap<String, List<String>>();
    private final Map<String, String> gCompositeUnitToUninstallUnitMap = new HashMap<String, String>();
    private final List<PreConfiguredKeyValue> gConfiguredComponentsList = new ArrayList<PreConfiguredKeyValue>();
    private final Set<String> gPayloadCompositeUnitIdentifiers = new HashSet<String>();

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(URL aDescriptor) throws EnhancedException {
        this.setURLInput(aDescriptor);
        this.createXMLHandlers();
        try {
            this.gComponent = (Component)this.gXMLUnmarshaller.unmarshal(this.getURLInput());
        }
        catch (JAXBException theJAXBe) {
            throw new EnhancedException("ERROR_CONSTRUCTING_DESCRIPTOR", theJAXBe.getCause(), new String[]{"file=" + aDescriptor.toString()});
        }
        this.unmarshallDescriptor();
    }

    public final void setURLInput(URL aDescriptor) {
        this.gURL = aDescriptor;
    }

    protected final void createXMLHandlers() throws EnhancedException {
        try {
            JAXBContext theJC = JAXBContext.newInstance((String)XMLNAMESPACE);
            this.gXMLUnmarshaller = theJC.createUnmarshaller();
        }
        catch (JAXBException theJAXBe) {
            LOGGER.log(Level.FINE, "Cannot create the Un/Marshaller.");
            throw new EnhancedException("CANNOT_CREATE_MARSHALLER_OR_UNMARSHALLER", (Throwable)theJAXBe, new String[0]);
        }
    }

    public final URL getURLInput() {
        return this.gURL;
    }

    private void unmarshallDescriptor() {
        this.initializeHighLevelElements();
        this.initializeRequirementsMaps();
        this.initializeFeaturesSet();
        this.initializePayloadMaps();
    }

    private void initializeHighLevelElements() {
        this.gIdentity = this.gComponent.getIdentity();
        this.gFeatures = this.gComponent.getFeatures();
        this.gRequirements = this.gComponent.getRequirements();
        this.gPayload = this.gComponent.getPayload();
    }

    private void initializeRequirementsMaps() {
        if (this.getRequirements() != null) {
            for (Object theRequirement : this.getRequirements().getContent()) {
                Object theElement = theRequirement;
                Class<?> theType = theElement.getClass();
                if (theType == CapabilityRefs.class) {
                    this.updateCapabilityMap((CapabilityRefs)theElement);
                }
                if (theType != ComponentRefs.class) continue;
                this.updateComponentMap((ComponentRefs)theElement);
            }
        }
    }

    private Requirements getRequirements() {
        return this.gRequirements;
    }

    private void updateCapabilityMap(CapabilityRefs aCapabilityRefs) {
        for (CapabilityRef theCapabilityRef : aCapabilityRefs.getCapabilityRef()) {
            String theElementIdentifier = theCapabilityRef.getCapabilityIdentifier();
            this.gRequirementsCapabilityMap.put(theElementIdentifier, this.gTempVersionObject.versCompat2versObject(theElementIdentifier, theCapabilityRef.getCapabilityRefVersion()));
            if (!theCapabilityRef.isConfigRequired()) continue;
            this.gConfiguredComponentsList.add(new PreConfiguredKeyValue("Capability", theElementIdentifier));
        }
    }

    private void updateComponentMap(ComponentRefs theComponentRefs) {
        for (ComponentRef theComponentRef : theComponentRefs.getComponentRef()) {
            String theElementIdentifier = theComponentRef.getComponentIdentifier();
            this.gRequirementsComponentMap.put(theElementIdentifier, this.gTempVersionObject.versCompat2versObject(theElementIdentifier, theComponentRef.getComponentRefVersion()));
            if (!theComponentRef.isConfigRequired()) continue;
            this.gConfiguredComponentsList.add(new PreConfiguredKeyValue("Component", theElementIdentifier));
        }
    }

    private void initializeFeaturesSet() {
        if (this.getFeatures() != null) {
            for (ComponentRef componentRef : this.getFeatures().getComponentRef()) {
                this.gFeaturesID.add(componentRef.getComponentIdentifier());
            }
        }
    }

    private Features getFeatures() {
        return this.gFeatures;
    }

    public final List<String> getFeaturesID() {
        ArrayList<String> theResult = new ArrayList<String>();
        if (this.getFeatures() != null) {
            for (ComponentRef componentRef : this.getFeatures().getComponentRef()) {
                theResult.add(componentRef.getComponentIdentifier());
            }
        }
        return theResult;
    }

    protected final String getNiceDescription() {
        String theResult = "(v. " + this.getBaselineVersion() + " by " + this.getIdentityVendor() + ")";
        return theResult;
    }

    protected final boolean isFeature() {
        return this.getIdentity().getIdentifier().isFeature();
    }

    public final boolean isUpgradeAll() {
        boolean theUpgradeAll = false;
        if (this.gFeatures != null) {
            theUpgradeAll = this.gFeatures.isUpgradeAll();
        }
        return theUpgradeAll;
    }

    private void initializePayloadMaps() {
        if (this.getPayload() != null) {
            for (CompositeUnit theCompositeUnit : this.getPayload().getCompositeUnit()) {
                String theIdentifier = theCompositeUnit.getName();
                ArrayList<InstallableUnitParameter> theCompositeUnitParams = new ArrayList<InstallableUnitParameter>();
                this.gPayloadCompositeUnitIdentifiers.add(theIdentifier);
                if (theCompositeUnit.getParameters() != null) {
                    InstallableUnitParameter theIUParam;
                    for (Parameter theParam : theCompositeUnit.getParameters().getParameter()) {
                        theIUParam = new InstallableUnitParameter(theParam.getName());
                        theIUParam.setValue(theParam.getValue());
                        theCompositeUnitParams.add(theIUParam);
                    }
                    for (Parameter theParam : theCompositeUnit.getParameters().getParameterMap()) {
                        theIUParam = new InstallableUnitParameter(theParam.getRealName(), theParam.getMappedName());
                        theCompositeUnitParams.add(theIUParam);
                    }
                }
                for (Realization theRealization : theCompositeUnit.getRealization()) {
                    try {
                        String thePlatformIdentifier = this.getPlatformIdentifier(theRealization);
                        String theMapEntryIdentifier = new KeyValueStringPair(theIdentifier, thePlatformIdentifier).getCompactForm();
                        this.gCompositeUnitToOSVersionMap.put(theMapEntryIdentifier, this.getAlternatePlatformIdentifiers(theRealization));
                        if (theRealization.getOS().getOtherArch() != null) {
                            for (String theOtherArch : theRealization.getOS().getOtherArch()) {
                                this.gAlternateRealizationsToDefaultMap.put(new KeyValueStringPair(theIdentifier, this.getArchCompatiblePlatformIdentifier(theRealization, theOtherArch)).getCompactForm(), theMapEntryIdentifier);
                                if (theRealization.getOS().getOtherName() == null) continue;
                                for (String theOtherName : theRealization.getOS().getOtherName()) {
                                    this.gAlternateRealizationsToDefaultMap.put(new KeyValueStringPair(theIdentifier, this.getOSArchNameCompatiblePlatformIdentifier(theRealization, theOtherName, theOtherArch)).getCompactForm(), theMapEntryIdentifier);
                                }
                            }
                        }
                        if (theRealization.getIdentityVersion() == null) {
                            this.gCompositeUnitToCPVersionMap.put(theMapEntryIdentifier, this.getIdentityVersionIdentifier());
                        } else {
                            this.gCompositeUnitToCPVersionMap.put(theMapEntryIdentifier, this.gTempVersionObject.versCompat2versObject(theMapEntryIdentifier, theRealization.getIdentityVersion()));
                        }
                        for (String theAlternateOSName : theRealization.getOS().getOtherName()) {
                            this.gAlternateRealizationsToDefaultMap.put(new KeyValueStringPair(theIdentifier, this.getOSNameCompatiblePlatformIdentifier(theRealization, theAlternateOSName)).getCompactForm(), theMapEntryIdentifier);
                        }
                        ArrayList<InstallableUnitParameter> theRealizationParams = new ArrayList<InstallableUnitParameter>();
                        if (theRealization.getParameters() != null) {
                            InstallableUnitParameter theIUParam;
                            for (Parameter theParam : theRealization.getParameters().getParameter()) {
                                theIUParam = new InstallableUnitParameter(theParam.getName());
                                theIUParam.setValue(theParam.getValue());
                                theRealizationParams.add(theIUParam);
                            }
                            for (Parameter theParam : theRealization.getParameters().getParameterMap()) {
                                theIUParam = new InstallableUnitParameter(theParam.getRealName(), theParam.getMappedName());
                                theRealizationParams.add(theIUParam);
                            }
                        }
                        ArrayList<InstallableUnitParameter> theFinalList = new ArrayList<InstallableUnitParameter>();
                        theFinalList.addAll(theRealizationParams);
                        for (InstallableUnitParameter theCompositeParam : theCompositeUnitParams) {
                            if (this.containsParameterByName(theFinalList, theCompositeParam.getRealName())) continue;
                            theFinalList.add(theCompositeParam);
                        }
                        this.gCompositeUnitToParametersMap.put(theMapEntryIdentifier, theFinalList);
                        ArrayList<L10nInstallableUnitKeyValue> theInstUnitsList = new ArrayList<L10nInstallableUnitKeyValue>();
                        for (InstallableUnit theIterLocIURef : theRealization.getInstallableUnit()) {
                            String theIUVersion;
                            L10nInstallableUnitKeyValue theInstUnitKeyValue = new L10nInstallableUnitKeyValue(theIterLocIURef.getValue(), theIterLocIURef.getLocalized());
                            theInstUnitKeyValue.setOverwrite(theIterLocIURef.isOverwriteAllowed());
                            if (theRealization.isCritical()) {
                                LOGGER.finest(" @ Critical flag found, setting it");
                                theInstUnitKeyValue.setCritical(theRealization.isCritical());
                            }
                            if (null == (theIUVersion = theIterLocIURef.getVersion()) || "".equals(theIUVersion)) {
                                if (null != theRealization.getVersion() || !"".equals(theRealization.getVersion())) {
                                    theInstUnitKeyValue.setVersion(theRealization.getVersion());
                                    LOGGER.finest("@Setting " + theInstUnitKeyValue.getCoreInstallableUnitName() + " with Realization Ver =" + theRealization.getVersion());
                                }
                            } else {
                                theInstUnitKeyValue.setVersion(theIUVersion);
                                LOGGER.finest("@Setting " + theInstUnitKeyValue.getCoreInstallableUnitName() + " with pkg Ver=" + theIUVersion);
                            }
                            theInstUnitsList.add(theInstUnitKeyValue);
                        }
                        this.gCompositeUnitToInstallableUnitMap.put(theMapEntryIdentifier, theInstUnitsList);
                        if (theRealization.getOS().getRequirementsRealization() == null) {
                            this.gCompositeUnitToRequirementMap.put(theMapEntryIdentifier, new ArrayList());
                        } else {
                            ArrayList<RequirementKeyValue> theRequirementsList = new ArrayList<RequirementKeyValue>();
                            Iterator i$ = theRealization.getOS().getRequirementsRealization().getItem().iterator();
                            while (i$.hasNext()) {
                                Item item;
                                Item theItem = item = (Item)i$.next();
                                String theItemValue = theItem.getValue();
                                String theItemType = theItem.getType().value();
                                theRequirementsList.add(new RequirementKeyValue(theItemType, theItemValue));
                            }
                            this.gCompositeUnitToRequirementMap.put(theMapEntryIdentifier, theRequirementsList);
                        }
                        this.populateKeyItems(theMapEntryIdentifier, theRealization);
                        this.populateUninstallUnit(theMapEntryIdentifier, theRealization);
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CREATE_PLAT_ID", theEIAEx);
                    }
                }
            }
        }
    }

    private boolean containsParameterByName(List<InstallableUnitParameter> aFinalList, String aRealName) {
        for (InstallableUnitParameter theParam : aFinalList) {
            if (!theParam.getRealName().equals(aRealName)) continue;
            return true;
        }
        return false;
    }

    private void populateKeyItems(String aMapEntryIdentifier, Realization aRealization) {
        if (aRealization.getOS().getKeyItems() == null) {
            this.gCompositeUnitToKeyFilesMap.put(aMapEntryIdentifier, new ArrayList());
            this.gCompositeUnitToKeyRegMap.put(aMapEntryIdentifier, new ArrayList());
        } else {
            List theKeyFilesList = new ArrayList();
            ArrayList<RequirementKeyValue> theKeyRegEntries = new ArrayList<RequirementKeyValue>();
            List theKeyRegList = new ArrayList();
            KeyItems theKeyItems = aRealization.getOS().getKeyItems();
            theKeyFilesList = theKeyItems.getKeyFile();
            theKeyRegList = theKeyItems.getKeyReg();
            for (KeyReg theKeyRegValue : theKeyRegList) {
                theKeyRegEntries.add(new RequirementKeyValue(theKeyRegValue.getKeyName(), theKeyRegValue.getKeyValue()));
            }
            this.gCompositeUnitToKeyFilesMap.put(aMapEntryIdentifier, theKeyFilesList);
            this.gCompositeUnitToKeyRegMap.put(aMapEntryIdentifier, theKeyRegEntries);
        }
    }

    public void populateUninstallUnit(String aMapEntryIdentifier, Realization aRealization) {
        if (aRealization.getUninstallUnit() == null) {
            this.gCompositeUnitToUninstallUnitMap.put(aMapEntryIdentifier, null);
        } else {
            this.gCompositeUnitToUninstallUnitMap.put(aMapEntryIdentifier, aRealization.getUninstallUnit());
        }
    }

    private Payload getPayload() {
        return this.gPayload;
    }

    private String getPlatformIdentifier(Realization aRealization) throws InvalidArgumentException {
        return Platform.encode((Platform)new Platform(Platform.getOSTypeForString((String)aRealization.getOS().getType()), Platform.getOSNameForString((String)aRealization.getOS().getName()), Platform.getArchForString((String)aRealization.getOS().getArch()), new VersionRange(new Version(aRealization.getOS().getVersionCertified().getVersionBaseline()))));
    }

    private String getOSNameCompatiblePlatformIdentifier(Realization aRealization, String aOSName) throws InvalidArgumentException {
        return Platform.encodeSansVersion((Platform)new Platform(Platform.getOSTypeForString((String)aRealization.getOS().getType()), Platform.getOSNameForString((String)aOSName), Platform.getArchForString((String)aRealization.getOS().getArch())));
    }

    private String getOSArchNameCompatiblePlatformIdentifier(Realization aRealization, String aOSName, String aOSArch) throws InvalidArgumentException {
        return Platform.encodeSansVersion((Platform)new Platform(Platform.getOSTypeForString((String)aRealization.getOS().getType()), Platform.getOSNameForString((String)aOSName), Platform.getArchForString((String)aOSArch)));
    }

    private String getArchCompatiblePlatformIdentifier(Realization aRealization, String aArch) throws InvalidArgumentException {
        return Platform.encodeSansVersion((Platform)new Platform(Platform.getOSTypeForString((String)aRealization.getOS().getType()), Platform.getOSNameForString((String)aRealization.getOS().getName()), Platform.getArchForString((String)aArch)));
    }

    private List<String> getAlternatePlatformIdentifiers(Realization aRealization) {
        ArrayList<String> theResult;
        block10: {
            block9: {
                PrequalifiedRangeVersions thePrequalifiedRangeVersions;
                boolean theHighBorder;
                String theHighEnd;
                boolean theLowBorder;
                String theLowEnd;
                theResult = new ArrayList<String>();
                PrequalifiedCompatibleVersions thePrequalifiedCompatibleVersions = aRealization.getOS().getVersionCertified().getPrequalifiedCompatibleVersions();
                if (thePrequalifiedCompatibleVersions == null) break block9;
                PrequalifiedDiscreteVersions thePrequalifiedDiscreteVersions = thePrequalifiedCompatibleVersions.getPrequalifiedDiscreteVersions();
                if (thePrequalifiedDiscreteVersions != null) {
                    for (PrequalifiedDiscreteVersion thePrequalifiedDiscreteVersion : thePrequalifiedDiscreteVersions.getPrequalifiedDiscreteVersion()) {
                        theLowEnd = thePrequalifiedDiscreteVersion.getVersionIdentifier().getValue();
                        theLowBorder = true;
                        theHighEnd = theLowEnd;
                        theHighBorder = true;
                        try {
                            theResult.add(new VersionRange(new Version(theLowEnd), theLowBorder, new Version(theHighEnd), theHighBorder).toString());
                        }
                        catch (InvalidArgumentException theEIAEx) {
                            LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
                        }
                    }
                }
                if ((thePrequalifiedRangeVersions = thePrequalifiedCompatibleVersions.getPrequalifiedRangeVersions()) == null) break block10;
                for (PrequalifiedRangeVersion thePrequalifiedRangeVersion : thePrequalifiedRangeVersions.getPrequalifiedRangeVersion()) {
                    theLowEnd = thePrequalifiedRangeVersion.getLow().getValue();
                    theLowBorder = "included".equals(thePrequalifiedRangeVersion.getLow().getBorder().value());
                    theHighEnd = thePrequalifiedRangeVersion.getHigh().getValue();
                    theHighBorder = "included".equals(thePrequalifiedRangeVersion.getHigh().getBorder().value());
                    try {
                        theResult.add(new VersionRange(new Version(theLowEnd), theLowBorder, new Version(theHighEnd), theHighBorder).toString());
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
                    }
                }
                break block10;
            }
            String theLowEnd = aRealization.getOS().getVersionCertified().getVersionBaseline();
            boolean theLowBorder = true;
            String theHighEnd = "INFINITY";
            boolean theHighBorder = false;
            try {
                theResult.add(new VersionRange(new Version(theLowEnd), theLowBorder, new Version(theHighEnd), theHighBorder).toString());
            }
            catch (InvalidArgumentException theEIAEx) {
                LOGGER.log(Level.WARNING, "ERROR_CREATING_VERSION_RANGE", theEIAEx);
            }
        }
        return theResult;
    }

    public final VersionObject getIdentityVersionIdentifier() {
        return this.gTempVersionObject.versCompat2versObject(this.getIdentityIdentifier(), this.getIdentity().getIdentityVersion());
    }

    public final String getIdentityIdentifier() {
        return this.getIdentity().getIdentifier().getValue();
    }

    public final String getIdentityName() {
        String theResult = this.getIdentity().getName();
        theResult = theResult != null ? theResult : this.getIdentity().getIdentifier().getValue();
        return theResult;
    }

    public ComponentDescriptor(String aDirectory, String aDescriptor) throws EnhancedException {
        try {
            this.setURLInput(new URL("file", "localhost", aDirectory + System.getProperty("file.separator") + aDescriptor));
            this.createXMLHandlers();
        }
        catch (MalformedURLException theMUe) {
            throw new EnhancedException("MALFORMED_URL", (Throwable)theMUe, new String[]{"url=" + aDescriptor});
        }
        catch (EnhancedException theEe) {
            theEe.addContext("CANT_CREATE_XML_DESC", new String[]{"descriptor=" + aDescriptor});
            throw theEe;
        }
        try {
            this.gComponent = (Component)this.gXMLUnmarshaller.unmarshal(this.getURLInput());
        }
        catch (JAXBException theJAXBe) {
            throw new EnhancedException("ERROR_CONSTRUCTING_DESCRIPTOR", (Throwable)theJAXBe, new String[]{"descriptor=" + aDescriptor});
        }
        this.unmarshallDescriptor();
    }

    public final List<String> getFeaturesComponentRefs() {
        return new ArrayList<String>(this.gFeaturesID);
    }

    private Identity getIdentity() {
        return this.gIdentity;
    }

    public final List<String> getIdentityCategory() {
        ArrayList<String> theResult = new ArrayList<String>();
        if (this.getIdentity().getCategories() != null) {
            theResult = new ArrayList(this.getIdentity().getCategories().getCategory());
        }
        return theResult;
    }

    public final String getIdentityDescription(Locale aLocale) {
        List theDescriptions = this.getIdentity().getDescription();
        List theSearchOrder = LocaleUtils.getSubLocaleNames((Locale)aLocale);
        for (String theSearchItem : theSearchOrder) {
            for (Description theDescription : theDescriptions) {
                if (!theSearchItem.equals(theDescription.getLocale())) continue;
                return theDescription.getValue();
            }
        }
        return "";
    }

    public final Map<Locale, String> getIdentityDescriptions() {
        HashMap<Locale, String> theDescriptions = new HashMap<Locale, String>();
        for (Description theDescription : this.getIdentity().getDescription()) {
            theDescriptions.put(LocaleUtils.createLocaleFromString((String)theDescription.getLocale()), theDescription.getValue());
        }
        return theDescriptions;
    }

    public final String getIdentityOther() {
        return this.getIdentity().getOther();
    }

    public final List<String> getIdentityStandards() {
        ArrayList<String> theResult = new ArrayList<String>();
        if (this.getIdentity().getCapabilities() != null) {
            theResult = new ArrayList(this.getIdentity().getCapabilities().getStandard());
        }
        return theResult;
    }

    public final String getIdentityVendor() {
        return this.getIdentity().getVendor();
    }

    public final Set<String> getPayloadCompositeNames() {
        return this.gPayloadCompositeUnitIdentifiers;
    }

    public final List<PlatformInstUnit> getPayloadInstallableUnits(String aCompositeUnitName, Platform aPlatform) throws EnhancedException {
        ArrayList<PlatformInstUnit> theResult = new ArrayList<PlatformInstUnit>();
        String theEncodedRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        if (this.gCompositeUnitToInstallableUnitMap.containsKey(theEncodedRealizationID)) {
            List<L10nInstallableUnitKeyValue> theIUs = this.gCompositeUnitToInstallableUnitMap.get(theEncodedRealizationID);
            List<InstallableUnitParameter> theParams = this.gCompositeUnitToParametersMap.get(theEncodedRealizationID);
            for (L10nInstallableUnitKeyValue theIU : theIUs) {
                PlatformInstUnit theUnit = new PlatformInstUnit(theEncodedRealizationID, theIU);
                theUnit.setParameters(theParams);
                theResult.add(theUnit);
            }
        }
        return theResult;
    }

    public final List<RequirementKeyValue> getPayloadRequirements(String aCompositeUnitName, Platform aPlatform) {
        ArrayList<RequirementKeyValue> theResult = new ArrayList<RequirementKeyValue>();
        String theRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        if (this.gCompositeUnitToInstallableUnitMap.containsKey(theRealizationID)) {
            theResult.addAll((Collection<RequirementKeyValue>)this.gCompositeUnitToRequirementMap.get(theRealizationID));
        }
        return theResult;
    }

    public final List<RequirementKeyValue> getKeyRegEntriesList(String aCompositeUnitName, Platform aPlatform) {
        ArrayList<RequirementKeyValue> theKeyRegEntriesList = new ArrayList<RequirementKeyValue>();
        String theRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        if (this.gCompositeUnitToKeyRegMap.containsKey(theRealizationID)) {
            theKeyRegEntriesList.addAll((Collection<RequirementKeyValue>)this.gCompositeUnitToKeyRegMap.get(theRealizationID));
        }
        return theKeyRegEntriesList;
    }

    public List<String> getKeyFilesList(String aCompositeUnitName, Platform aPlatform) {
        ArrayList<String> theKeyFileList = new ArrayList<String>();
        String theRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        if (this.gCompositeUnitToKeyFilesMap.containsKey(theRealizationID)) {
            theKeyFileList.addAll((Collection<String>)this.gCompositeUnitToKeyFilesMap.get(theRealizationID));
        }
        return theKeyFileList;
    }

    public String getUninstallUnit(String aCompositeUnitName, Platform aPlatform) {
        String theUninstallExecutable = null;
        String theRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        if (this.gCompositeUnitToUninstallUnitMap.containsKey(theRealizationID)) {
            theUninstallExecutable = this.gCompositeUnitToUninstallUnitMap.get(theRealizationID);
        }
        return theUninstallExecutable;
    }

    public final VersionObject getPayloadVersions(String aCompositeUnitName, Platform aPlatform) {
        String theRealizationID = this.convertRealizationID(aCompositeUnitName, aPlatform);
        return this.gCompositeUnitToCPVersionMap.get(theRealizationID);
    }

    public final VersionObject getRequirementCapabilityVersion(String aCapabilityID) {
        return this.gRequirementsCapabilityMap.get(aCapabilityID);
    }

    public final VersionObject getRequirementComponentVersion(String aComponentID) {
        return this.gRequirementsComponentMap.get(aComponentID);
    }

    public final List<PreConfiguredKeyValue> getRequirementConfigureRequired() {
        return new ArrayList<PreConfiguredKeyValue>(this.gConfiguredComponentsList);
    }

    public final Set<String> getRequirementsCapabilityIdentifiers() {
        return this.gRequirementsCapabilityMap.keySet();
    }

    public final Set<String> getRequirementsComponentIdentifiers() {
        return this.gRequirementsComponentMap.keySet();
    }

    private String convertRealizationID(String aCompositeUnitName, Platform aPlatform) {
        String theAlteredRequest;
        String theResult = "";
        boolean theMatchFound = false;
        String theInputID = new KeyValueStringPair(aCompositeUnitName, Platform.encode((Platform)aPlatform)).getCompactForm();
        Set<String> theKeys = this.gCompositeUnitToOSVersionMap.keySet();
        if (theKeys.contains(theInputID)) {
            theMatchFound = true;
            theResult = theInputID;
        }
        if (!theMatchFound) {
            List<Object> theCompatibleVersions = new ArrayList<String>();
            String theSansVersionPlatform = Platform.encodeSansVersion((Platform)aPlatform);
            String theAlteredRequest2 = new KeyValueStringPair(aCompositeUnitName, theSansVersionPlatform).getCompactForm();
            for (String theEntry : theKeys) {
                if (!theEntry.startsWith(theAlteredRequest2)) continue;
                theCompatibleVersions.add(theEntry);
            }
            Collections.sort(theCompatibleVersions);
            Iterator theEntryIter = theCompatibleVersions.iterator();
            while (theEntryIter.hasNext() && !theMatchFound) {
                String theKey = (String)theEntryIter.next();
                theCompatibleVersions = this.gCompositeUnitToOSVersionMap.get(theKey);
                Iterator<Object> theVersionsIter = theCompatibleVersions.iterator();
                while (theVersionsIter.hasNext() && !theMatchFound) {
                    try {
                        VersionRange theVersionRange = new VersionRange((String)theVersionsIter.next());
                        if (!theVersionRange.overlaps(aPlatform.retrievePlatformVersion())) continue;
                        theMatchFound = true;
                        theResult = theKey;
                    }
                    catch (EnhancedException theEE) {
                        LOGGER.log(Level.FINE, "Manufactured an erroneous VersionRange.");
                    }
                }
            }
        }
        if (!theMatchFound && this.gAlternateRealizationsToDefaultMap.containsKey(theAlteredRequest = new KeyValueStringPair(aCompositeUnitName, Platform.encodeSansVersion((Platform)aPlatform)).getCompactForm())) {
            theResult = this.gAlternateRealizationsToDefaultMap.get(theAlteredRequest);
        }
        return theResult;
    }

    public final boolean isCompatible(ComponentDescriptor aSubmittedComponentDescriptor) {
        boolean theStatusIsUnknown = true;
        boolean theDescrIsCompatible = true;
        if (aSubmittedComponentDescriptor != null) {
            String theSubmittedDescrName = aSubmittedComponentDescriptor.getIdentityIdentifier();
            Version theSubmittedBaselineVersion = new Version(aSubmittedComponentDescriptor.getBaselineVersion());
            VersionObject theSubmittedIdentityVersObject = aSubmittedComponentDescriptor.getIdentityVersionIdentifier();
            if (!this.gRequirementsComponentMap.containsKey(theSubmittedDescrName)) {
                LOGGER.log(Level.FINE, "COMPAT_OK_INDEPENDANT_DESCRIPTORS");
                theDescrIsCompatible = true;
                theStatusIsUnknown = false;
            } else {
                VersionObject theRequiredDescVersionObject = this.gRequirementsComponentMap.get(theSubmittedDescrName);
                Version theRequiredVersion = theRequiredDescVersionObject.getBaseline(theSubmittedDescrName);
                if (theStatusIsUnknown) {
                    if (theSubmittedBaselineVersion.compareTo(theRequiredVersion) == 0) {
                        LOGGER.log(Level.FINE, "COMPAT_OK_SUPPLY_MATCHING_DEMAND");
                        theDescrIsCompatible = true;
                        theStatusIsUnknown = false;
                    } else {
                        LOGGER.log(Level.FINE, "COMPAT_KO_SUPPLY_MATCHING_DEMAND");
                    }
                }
                if (theStatusIsUnknown) {
                    if (this.tolerates(theSubmittedDescrName, theSubmittedBaselineVersion)) {
                        LOGGER.log(Level.FINE, "COMPAT_OK_TOLERANCE");
                        theDescrIsCompatible = true;
                        theStatusIsUnknown = false;
                    } else {
                        LOGGER.log(Level.FINE, "COMPAT_KO_TOLERANCE");
                    }
                }
                if (theStatusIsUnknown) {
                    if (this.isGuaranteedSameService(theRequiredVersion, theSubmittedIdentityVersObject)) {
                        LOGGER.log(Level.FINE, "COMPAT_OK_IMPERSONATION");
                        theDescrIsCompatible = true;
                        theStatusIsUnknown = false;
                    } else {
                        LOGGER.log(Level.FINE, "COMPAT_KO_IMPERSONATION");
                    }
                }
                if (theStatusIsUnknown) {
                    LOGGER.log(Level.FINE, "COMPAT_KO");
                    theDescrIsCompatible = false;
                }
            }
        }
        return theDescrIsCompatible;
    }

    public final String getBaselineVersion() {
        return this.getIdentity().getIdentityVersion().getVersionBaseline();
    }

    private boolean tolerates(String aSubmittedDescrName, Version aSubmittedBaselineVersion) {
        boolean theDescrIsFitToUse = false;
        boolean theStatusIsUnknown = true;
        if (theStatusIsUnknown && this.gRequirementsComponentMap.containsKey(aSubmittedDescrName)) {
            VersionObject theRequiredDescVersionObject = this.gRequirementsComponentMap.get(aSubmittedDescrName);
            Version theRequiredVersion = theRequiredDescVersionObject.getBaseline(aSubmittedDescrName);
            Iterator<Version> theIterIdentifiers = theRequiredDescVersionObject.getDiscretes(aSubmittedDescrName).iterator();
            while (theStatusIsUnknown && theIterIdentifiers.hasNext()) {
                if (theIterIdentifiers.next().compareTo(aSubmittedBaselineVersion) != 0) continue;
                theDescrIsFitToUse = true;
                theStatusIsUnknown = false;
            }
            Iterator<VersionRange> theIterRanges = this.getRequirementComponentVersion(aSubmittedDescrName).getRanges(aSubmittedDescrName).iterator();
            while (theStatusIsUnknown && theIterRanges.hasNext()) {
                if (!theIterRanges.next().includesVersion(theRequiredVersion)) continue;
                theDescrIsFitToUse = true;
                theStatusIsUnknown = false;
            }
        }
        return theDescrIsFitToUse;
    }

    private boolean isGuaranteedSameService(Version aRequiredVersion, VersionObject aSubmittedIdentityVersObject) {
        boolean theStatusIsUnknown = true;
        boolean theServiceIsGuaranteed = false;
        String theCurrentComponentID = this.getIdentityIdentifier();
        Iterator<Version> theIterIdentifiers = aSubmittedIdentityVersObject.getDiscretes(theCurrentComponentID).iterator();
        while (theStatusIsUnknown && theIterIdentifiers.hasNext()) {
            if (aRequiredVersion.compareTo(theIterIdentifiers.next()) != 0) continue;
            theServiceIsGuaranteed = true;
            theStatusIsUnknown = false;
        }
        Iterator<VersionRange> theIterRanges = aSubmittedIdentityVersObject.getRanges(theCurrentComponentID).iterator();
        while (theStatusIsUnknown && theIterRanges.hasNext()) {
            if (!theIterRanges.next().includesVersion(aRequiredVersion)) continue;
            theServiceIsGuaranteed = true;
            theStatusIsUnknown = false;
        }
        return theServiceIsGuaranteed;
    }
}

