/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.DependencyTree;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.RequirementKeyValue;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private DependencyTree gDependencyTree;
    private String gRootNodeID = null;
    private URL[] gImportLocations = null;

    public DependencyManager() {
    }

    public DependencyManager(URL[] aImportLocations, String aRootIdentifier, URL aPackageTOCLocation) throws EnhancedException {
        this.setRootNodeID(aRootIdentifier);
        this.setDescriptorsLocations(aImportLocations);
        try {
            this.bootUp();
        }
        catch (EnhancedException theEException) {
            theEException.addContext("CANNOT_START_DEPENDENCY_MANAGER", new String[0]);
            throw theEException;
        }
    }

    public final void bootUp() throws EnhancedException {
        if (this.getDescriptorsLocations() != null && this.getRootNodeID() != null) {
            this.gDependencyTree = new DependencyTree(this.getDescriptorsLocations(), this.getRootNodeID());
        }
    }

    public final void setDescriptorsLocations(URL[] aImportLocations) {
        this.gImportLocations = (URL[])aImportLocations.clone();
    }

    public final URL[] getDescriptorsLocations() {
        URL[] theResult = new URL[this.gImportLocations.length];
        System.arraycopy(this.gImportLocations, 0, theResult, 0, this.gImportLocations.length);
        return theResult;
    }

    public final String getRootNodeID() {
        return this.gRootNodeID;
    }

    public final void setRootNodeID(String aRootNodeID) {
        this.gRootNodeID = aRootNodeID;
    }

    public final MediaProduct getProductNodeRoot() throws EnhancedException {
        MediaProduct theResult;
        try {
            theResult = this.getProductNode(this.getRootNodeID());
        }
        catch (EnhancedException aEException) {
            throw new EnhancedException("CANNOT_FIND_PRODUCT_NODE", (Throwable)aEException, new String[0]);
        }
        return theResult;
    }

    public final MediaProduct getProductNode(String aProductNodeID) throws EnhancedException {
        return new MediaProduct(this, this.gDependencyTree.getHybridElement(aProductNodeID));
    }

    public final String getNiceDescription(String aComponentName) {
        return this.gDependencyTree.getNiceDescription(aComponentName);
    }

    protected final void resetTree() {
        this.gDependencyTree.reset();
    }

    public final void toggleHybridElement(String aHybridComponentElementID) {
        this.gDependencyTree.toggleHybridElement(aHybridComponentElementID);
    }

    public final void deselectHybridElement(String aHybridComponentElementID) {
        this.gDependencyTree.deselectHybridElement(aHybridComponentElementID);
    }

    public final void selectHybridElement(String aHybridComponentElementID) {
        this.gDependencyTree.selectHybridElement(aHybridComponentElementID);
    }

    public final Map<String, List<String>> getPayloadRequirementsMap(Platform aPlatform) {
        HashMap<String, List<String>> theResult = new HashMap<String, List<String>>();
        for (ComponentDescriptor theComponentDescriptor : this.gDependencyTree.getSequencedComponents()) {
            for (String theCompositeName : theComponentDescriptor.getPayloadCompositeNames()) {
                for (RequirementKeyValue theRequirement : theComponentDescriptor.getPayloadRequirements(theCompositeName, aPlatform)) {
                    ArrayList<String> theRequiredValues = (ArrayList<String>)theResult.get(theRequirement.getType());
                    if (theRequiredValues == null) {
                        theRequiredValues = new ArrayList<String>();
                    }
                    theRequiredValues.add(theRequirement.getContent());
                    theResult.put(theRequirement.getType(), theRequiredValues);
                }
            }
        }
        return theResult;
    }

    public final List<String> getSequencedIdentifiers() {
        return this.gDependencyTree.getSequencedSelection();
    }

    public final List<ComponentDescriptor> getSequencedComponents() {
        return this.gDependencyTree.getSequencedComponents();
    }

    public final List<String> getReverseSequencedIdentifiers() {
        return this.gDependencyTree.getReverseSequencedSelection();
    }

    public final List<ComponentDescriptor> getReverseSequencedComponents() {
        return this.gDependencyTree.getReverseSequencedComponents();
    }

    public final void displayHierarchy() {
        this.gDependencyTree.displayTree();
    }

    public final DependencyTree getDependencyTree() {
        return this.gDependencyTree;
    }
}

