/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.dependency.DependencyManager;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.legacy.LegacyDependency;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.install.Common;

public class DependencyProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private DependencyManager gDependencyManager = null;
    private LegacyDependency gLegacyDependency = null;
    private URL gLegacyDescLoc = null;

    public final void init(ControlBus aBus) throws BusException {
        this.gDependencyManager = new DependencyManager();
        try {
            this.gLegacyDescLoc = this.getLegacyDescriptorsLocation();
            if (this.gLegacyDescLoc != null) {
                LOGGER.fine(" Descriptors for Legacy are found at : " + this.gLegacyDescLoc.toExternalForm());
                this.gLegacyDependency = new LegacyDependency(this.gLegacyDescLoc);
                this.gLegacyDependency.initialize();
            }
        }
        catch (EnhancedException theEEx) {
            LOGGER.log(Level.FINE, "COULD_NOT_GET_LEGACY_DESC_LOC", theEEx);
        }
    }

    public final void shutdown() {
    }

    public final void receiveEvent(ControlBus aBus, BusEvent aEvt) {
    }

    public final void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        Throwable theException = null;
        if (!DependencyControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new InvalidArgumentException("INVALID_DEPENDENCY_REQUEST", new String[0])));
            return;
        }
        DependencyControl theDependencyControl = (DependencyControl)aReq.getData();
        switch (theDependencyControl.getCommand()) {
            case SET_DESCRIPTORS_LOCATION: {
                LOGGER.log(Level.FINE, "Setting descriptors location entered");
                if (URL[].class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "set_descriptors_location: OK");
                    URL[] theDescriptorsLocation = (URL[])theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Setting location...");
                    this.gDependencyManager.setDescriptorsLocations(theDescriptorsLocation);
                    break;
                }
                LOGGER.log(Level.FINE, "set_descriptors_location: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_SET_DESCRIPTORS_LOCATION", (Throwable)theIAe, new String[0]);
                break;
            }
            case SET_HIERARCHY_ROOT: {
                LOGGER.log(Level.FINE, "Setting the hierarchy root element");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "set_hierarchy_root: OK");
                    String theTreeRootID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Setting tree root to " + theTreeRootID);
                    this.gDependencyManager.setRootNodeID(theTreeRootID);
                    break;
                }
                LOGGER.log(Level.FINE, "set_hierarchy_root: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_SET_HIERARCHY_ROOT", (Throwable)theIAe, new String[0]);
                break;
            }
            case GET_COMPONENT_INFO: {
                LOGGER.log(Level.FINE, "requesting info about a component");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "fetching the information: OK");
                    String theHybridComponentElementID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Element to select: " + theHybridComponentElementID);
                    aResp.setFinalResult((Object)this.gDependencyManager.getNiceDescription(theHybridComponentElementID));
                    break;
                }
                LOGGER.log(Level.FINE, "fetching: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_RETRIEVE_INFORMATION", (Throwable)theIAe, new String[0]);
                break;
            }
            case BOOT_UP: {
                LOGGER.log(Level.FINE, "Activating the dependency manager");
                try {
                    this.gDependencyManager.bootUp();
                }
                catch (EnhancedException theEException) {
                    theException = theEException;
                }
                break;
            }
            case GET_PRODUCT_NODE_ROOT: {
                LOGGER.log(Level.FINE, "Retrieving a product node");
                try {
                    aResp.setFinalResult((Object)this.gDependencyManager.getProductNodeRoot());
                }
                catch (Exception theEException) {
                    theException = theEException;
                    LOGGER.log(Level.FINE, "product_node_root_retrieval: exception");
                }
                break;
            }
            case GET_PRODUCT_NODE: {
                LOGGER.log(Level.FINE, "Retrieving a product node");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "retrieving_product_node: OK");
                    String theProductNodeID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Product node to retrieve: " + theProductNodeID);
                    try {
                        aResp.setFinalResult((Object)this.gDependencyManager.getProductNode(theProductNodeID));
                    }
                    catch (EnhancedException theEException) {
                        theException = theEException;
                    }
                    break;
                }
                LOGGER.log(Level.FINE, "product_node_retrieval: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_RETRIEVE_PRODUCT_NODE", (Throwable)theIAe, new String[0]);
                break;
            }
            case TOGGLE_ELEMENT_SELECTION: {
                LOGGER.log(Level.FINE, "Changing an element's selection status");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "toggling_element_selection_status: OK");
                    String theHybridComponentElementID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Element to toggle: " + theHybridComponentElementID);
                    this.gDependencyManager.toggleHybridElement(theHybridComponentElementID);
                    break;
                }
                LOGGER.log(Level.FINE, "toggling_element_selection: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_TOGGLE_ELEMENT_SELECTION_STATUS", (Throwable)theIAe, new String[0]);
                break;
            }
            case SET_COMPONENT_SELECTION: {
                LOGGER.log(Level.FINE, "Changing an element's selection status");
                if (String[].class.isInstance(theDependencyControl.getData())) {
                    String[] theHybridComponentElementIDs;
                    LOGGER.log(Level.FINE, "set_component_selection_status: OK");
                    for (String theHybridComponentElementID : theHybridComponentElementIDs = (String[])theDependencyControl.getData()) {
                        LOGGER.log(Level.FINE, "Element to toggle: " + theHybridComponentElementID);
                        this.gDependencyManager.selectHybridElement(theHybridComponentElementID);
                    }
                    break;
                }
                LOGGER.log(Level.FINE, "set_component_selection_status: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_SET_COMPONENT_SELECTION_STATUS", (Throwable)theIAe, new String[0]);
                break;
            }
            case FORCE_SELECT_ELEMENT: {
                LOGGER.log(Level.FINE, "Forcing an element's selection");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "forcing_element_selection: OK");
                    String theHybridComponentElementID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Element to select: " + theHybridComponentElementID);
                    this.gDependencyManager.selectHybridElement(theHybridComponentElementID);
                    break;
                }
                LOGGER.log(Level.FINE, "toggling_element_selection: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_FORCE_ELEMENT_SELECTION", (Throwable)theIAe, new String[0]);
                break;
            }
            case FORCE_DESELECT_ELEMENT: {
                LOGGER.log(Level.FINE, "Forcing an element's deselection");
                if (String.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.log(Level.FINE, "forcing_element_deselection: OK");
                    String theHybridComponentElementID = (String)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "Element to deselect: " + theHybridComponentElementID);
                    this.gDependencyManager.deselectHybridElement(theHybridComponentElementID);
                    break;
                }
                LOGGER.log(Level.FINE, "toggling_element_deselection: exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                theException = new EnhancedException("CANNOT_FORCE_ELEMENT_DESELECTION", (Throwable)theIAe, new String[0]);
                break;
            }
            case GET_SEQUENCED_ID: {
                LOGGER.log(Level.FINE, "retrieving the list of identificators");
                aResp.setFinalResult(this.gDependencyManager.getSequencedIdentifiers());
                break;
            }
            case GET_SEQUENCED_COMPONENT: {
                LOGGER.log(Level.FINE, "retrieving the list of components");
                aResp.setFinalResult(this.gDependencyManager.getSequencedComponents());
                break;
            }
            case GET_REVERSE_SEQUENCED_ID: {
                LOGGER.log(Level.FINE, "retrieving the reverse list of identificators");
                aResp.setFinalResult(this.gDependencyManager.getReverseSequencedIdentifiers());
                break;
            }
            case GET_REVERSE_SEQUENCED_COMPONENT: {
                LOGGER.log(Level.FINE, "retrieving the reverse list of components");
                aResp.setFinalResult(this.gDependencyManager.getReverseSequencedComponents());
                break;
            }
            case GET_REQUIREMENTS: {
                Platform thePlatform = null;
                LOGGER.log(Level.FINE, "Retrieving the system resource requirements");
                if (Platform.class.isInstance(theDependencyControl.getData())) {
                    thePlatform = (Platform)theDependencyControl.getData();
                    LOGGER.log(Level.FINE, "retrieving data for platform");
                    aResp.setFinalResult(this.gDependencyManager.getPayloadRequirementsMap(thePlatform));
                    break;
                }
                LOGGER.log(Level.FINE, "invalid argument type for " + theDependencyControl.getCommand().name() + " exception");
                InvalidArgumentException theIAe = new InvalidArgumentException("ILLEGAL_DATA_TYPE", new String[0]);
                aResp.setException((Exception)((Object)theIAe));
                aResp.setFinalResult(null);
                break;
            }
            case GET_LEGACY_DATA: {
                try {
                    if (this.gLegacyDependency != null) {
                        aResp.setFinalResult(this.gLegacyDependency.getLegacyData());
                        break;
                    }
                    aResp.setFinalResult(null);
                }
                catch (EnhancedException theEEx) {
                    theException = theEEx;
                }
                break;
            }
            case GET_LEGACY_SIMS_PRODUCT: {
                if (this.gLegacyDependency == null) {
                    aResp.setFinalResult(null);
                    break;
                }
                Object theData = theDependencyControl.getData();
                if (MediaProduct.class.isInstance(theDependencyControl.getData())) {
                    LOGGER.finest("Getting SIMS legacy product");
                    try {
                        aResp.setFinalResult((Object)this.gLegacyDependency.getLegacySIMSProduct((MediaProduct)theData));
                    }
                    catch (EnhancedException theEEx) {
                        theException = theEEx;
                    }
                    break;
                }
                theException = new EnhancedException("INVALID_GET_LEGACY_SIMS_PRODUCT_REQUEST", new String[]{"req=" + aReq});
                break;
            }
            default: {
                theException = new InvalidArgumentException("INVALID_DEPENDENCY_REQUEST", new String[0]);
            }
        }
        if (theException != null) {
            aResp.setException((Exception)theException);
        }
    }

    public URL getLegacyDescriptorsLocation() throws EnhancedException {
        URL theLegacyDescURL;
        URL theMediaURL = null;
        try {
            theMediaURL = Common.getMediaLocationURL();
            theLegacyDescURL = new URL(theMediaURL, "dependency/legacy");
            LOGGER.finest("getLegacyDescriptorsLocation: URL = " + theLegacyDescURL);
            File theLegacyDir = new File(theLegacyDescURL.getPath());
            if (!theLegacyDir.exists() || !theLegacyDir.isDirectory()) {
                theLegacyDescURL = null;
            }
        }
        catch (MalformedURLException theEx) {
            throw new BusException("INVALID_MEDIA_DIRECTORY", (Throwable)theEx, new String[]{"url=" + theMediaURL});
        }
        return theLegacyDescURL;
    }

    public final void receiveResponse(BusResponse aResponse) {
    }

    public final String getName() {
        return "svc://general/Dependency";
    }
}

