/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.AdvancedDependencyGraph;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.HybridComponentElement;
import org.openinstaller.provider.dependency.HybridElementTreeModel;
import org.openinstaller.provider.dependency.HybridGroupElement;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTree {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private AdvancedDependencyGraph gDependencyGraph = new AdvancedDependencyGraph();
    private Map<String, List<String>> gDependenciesMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> gHierarchyMap = new HashMap<String, List<String>>();
    private Map<String, Set<String>> gCapabilitiesMap = new HashMap<String, Set<String>>();
    private Map<String, HybridComponentElement> gComponentsRegisterMap = new HashMap<String, HybridComponentElement>();
    private final Map<String, HybridGroupElement> gCapabilityRegisterMap = new HashMap<String, HybridGroupElement>();
    private HybridElementTreeModel gHybridElementTreeModel;
    private String gTreeRoot;

    public final void toggleHybridElement(String aIdentifier) {
        HybridComponentElement theHCE = this.gComponentsRegisterMap.get(aIdentifier);
        if (theHCE != null) {
            theHCE.toggle();
        }
    }

    public final void deselectHybridElement(String aIdentifier) {
        HybridComponentElement theHCE = this.gComponentsRegisterMap.get(aIdentifier);
        if (theHCE != null) {
            theHCE.setSelected(false);
        }
    }

    public final void selectHybridElement(String aIdentifier) {
        HybridComponentElement theHCE = this.gComponentsRegisterMap.get(aIdentifier);
        if (theHCE != null) {
            theHCE.setSelected(true);
        }
    }

    public DependencyTree(Map<String, List<String>> aDependencyMap, Map<String, Set<String>> aGroupMap, Map<String, List<String>> aHierarchyMap, String aRootID) {
        this.setTreeRoot(aRootID);
        this.setDependenciesMap(aDependencyMap);
        this.setCapabilitiesMap(aGroupMap);
        this.setHierarchyMap(aHierarchyMap);
        this.bootupNetwork();
    }

    public DependencyTree(URL[] aDescriptorLocations, String aRootID) throws EnhancedException {
        this.setTreeRoot(aRootID);
        this.initializeDependencyGraph(aDescriptorLocations);
        this.uploadDependencyGraph();
        this.bootupNetwork();
    }

    public final void setTreeRoot(String aRootID) {
        this.gTreeRoot = aRootID;
    }

    public final String getTreeRoot() {
        return this.gTreeRoot;
    }

    private void initializeDependencyGraph(URL[] aDescriptorLocations) throws EnhancedException {
        this.gDependencyGraph.inventoryDescriptors(aDescriptorLocations);
    }

    private void uploadDependencyGraph() {
        this.gDependenciesMap = this.gDependencyGraph.exportDirectDependencies();
        this.gCapabilitiesMap = this.gDependencyGraph.exportCapabilities();
        this.gHierarchyMap = this.gDependencyGraph.exportHierarchy();
    }

    public final void setDependenciesMap(Map<String, List<String>> aDependencyMap) {
        this.gDependenciesMap = aDependencyMap;
    }

    public final void setCapabilitiesMap(Map<String, Set<String>> aCapabilityMap) {
        this.gCapabilitiesMap = aCapabilityMap;
    }

    public final void setHierarchyMap(Map<String, List<String>> aHierarchyMap) {
        this.gHierarchyMap = aHierarchyMap;
    }

    public final void bootupNetwork() {
        this.initializeComponentHybrids();
        this.initializeHybridTree();
        this.initializeCapabilityHybrids();
    }

    private void initializeComponentHybrids() {
        if (!this.gDependenciesMap.isEmpty()) {
            for (String theComponentID : this.gDependenciesMap.keySet()) {
                HybridComponentElement theHCEObservable;
                List<String> theDependenciesID = this.gDependenciesMap.get(theComponentID);
                if (!this.gComponentsRegisterMap.containsKey(theComponentID)) {
                    theHCEObservable = new HybridComponentElement(this.gDependencyGraph.getDescriptor(theComponentID));
                    this.gComponentsRegisterMap.put(theComponentID, theHCEObservable);
                }
                theHCEObservable = this.gComponentsRegisterMap.get(theComponentID);
                for (String theDependencyID : theDependenciesID) {
                    HybridGroupElement theHGEObserver;
                    HybridComponentElement theHCEObserver;
                    if (!this.gCapabilitiesMap.containsKey(theDependencyID)) {
                        if (!this.gComponentsRegisterMap.containsKey(theDependencyID)) {
                            theHCEObserver = new HybridComponentElement(this.gDependencyGraph.getDescriptor(theDependencyID));
                            this.gComponentsRegisterMap.put(theDependencyID, theHCEObserver);
                        } else {
                            theHCEObserver = this.gComponentsRegisterMap.get(theDependencyID);
                        }
                        theHCEObserver.addDependentID(theComponentID);
                    }
                    if (this.gComponentsRegisterMap.containsKey(theDependencyID)) {
                        theHCEObserver = this.gComponentsRegisterMap.get(theDependencyID);
                        theHCEObservable.addObserver(theHCEObserver);
                    }
                    if (!this.gCapabilitiesMap.containsKey(theDependencyID)) continue;
                    if (this.gCapabilityRegisterMap.containsKey(theDependencyID)) {
                        theHGEObserver = this.gCapabilityRegisterMap.get(theDependencyID);
                    } else {
                        theHGEObserver = new HybridGroupElement(theDependencyID);
                        this.gCapabilityRegisterMap.put(theDependencyID, theHGEObserver);
                    }
                    theHCEObservable.addObserver(theHGEObserver);
                }
            }
        }
    }

    private void initializeHybridTree() {
        this.gHybridElementTreeModel = new HybridElementTreeModel(this.gHierarchyMap, this.getTreeRoot());
    }

    private void initializeCapabilityHybrids() {
        for (String theCapabilityID : this.gCapabilitiesMap.keySet()) {
            HybridGroupElement theHGEObserver;
            ArrayList<HybridComponentElement> theHGEProviders = new ArrayList<HybridComponentElement>();
            for (String theProviderID : this.gCapabilitiesMap.get(theCapabilityID)) {
                theHGEProviders.add(this.gComponentsRegisterMap.get(theProviderID));
            }
            if (this.gCapabilityRegisterMap.containsKey(theCapabilityID)) {
                theHGEObserver = this.gCapabilityRegisterMap.get(theCapabilityID);
                theHGEObserver.setProviders(theHGEProviders);
            } else {
                theHGEObserver = new HybridGroupElement(theCapabilityID, theHGEProviders);
            }
            this.gCapabilityRegisterMap.put(theCapabilityID, theHGEObserver);
        }
    }

    public final void displayTree() {
        this.gHybridElementTreeModel.display();
    }

    protected final void reset() {
        for (String theElementID : this.getHybridElementsIDs()) {
            this.deselectHybridElement(theElementID);
        }
    }

    protected final String getNiceDescription(String aHybridComponentElementName) {
        String theResult = "";
        if (this.gComponentsRegisterMap.containsKey(aHybridComponentElementName)) {
            theResult = this.gComponentsRegisterMap.get(aHybridComponentElementName).getNiceDescription();
        }
        return theResult;
    }

    public final HybridElementTreeModel exportHybridsTree() {
        return new HybridElementTreeModel(this.gHierarchyMap, this.getTreeRoot());
    }

    public final Map<String, HybridComponentElement> exportRequestedHybrids() {
        HashMap<String, HybridComponentElement> theRequestedHybrids = new HashMap<String, HybridComponentElement>();
        Iterator<String> theIterator = this.gatherHybridElementsIDs();
        while (theIterator.hasNext()) {
            String theKey = theIterator.next();
            HybridComponentElement theCandidate = this.gComponentsRegisterMap.get(theKey);
            if (!theCandidate.getStatus()) continue;
            theRequestedHybrids.put(theKey, theCandidate);
        }
        return theRequestedHybrids;
    }

    private Iterator<String> gatherHybridElementsIDs() {
        return this.gComponentsRegisterMap.keySet().iterator();
    }

    public final List<String> getHybridElementsIDs() {
        ArrayList<String> theResult = new ArrayList<String>();
        Iterator<String> theIterator = this.gatherHybridElementsIDs();
        while (theIterator.hasNext()) {
            theResult.add(theIterator.next());
        }
        return theResult;
    }

    public final HybridComponentElement getHybridElement(String aIdentifier) throws EnhancedException {
        HybridComponentElement theResult = this.gComponentsRegisterMap.get(aIdentifier);
        if (theResult == null) {
            throw new EnhancedException("UNDEFINED_ENTRY", new String[]{"entry=" + aIdentifier});
        }
        return theResult;
    }

    private List<String> getRequestedIdentifiers() {
        ArrayList<String> theSequence = new ArrayList<String>();
        for (String theRequestedComponentID : this.exportRequestedHybrids().keySet()) {
            theSequence.add(theRequestedComponentID);
        }
        return theSequence;
    }

    public final Map<String, HybridComponentElement> exportSelectedHybrids() {
        HashMap<String, HybridComponentElement> theRequestedHybrids = new HashMap<String, HybridComponentElement>();
        Iterator<String> theIterator = this.gatherHybridElementsIDs();
        while (theIterator.hasNext()) {
            String theKey = theIterator.next();
            HybridComponentElement theCandidate = this.gComponentsRegisterMap.get(theKey);
            if (!theCandidate.getSelected()) continue;
            theRequestedHybrids.put(theKey, theCandidate);
        }
        return theRequestedHybrids;
    }

    public final List<String> getSequencedSelection() {
        return this.gDependencyGraph.getSequencedSelection(this.getRequestedIdentifiers());
    }

    public final List<String> getReverseSequencedSelection() {
        return this.gDependencyGraph.getReverseSequencedSelection(this.getRequestedIdentifiers());
    }

    public final List<ComponentDescriptor> getSequencedComponents() {
        return this.gDependencyGraph.exportComponentDescriptorSequence(this.getRequestedIdentifiers());
    }

    public final List<ComponentDescriptor> getReverseSequencedComponents() {
        return this.gDependencyGraph.exportComponentDescriptorReverseSequence(this.getRequestedIdentifiers());
    }
}

