/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.PreConfiguredKeyValue;
import org.openinstaller.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridComponentElement
extends Observable
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final ComponentDescriptor gComponentDescriptor;
    private boolean gSelected;
    private final Set<String> gDependentsID = new HashSet<String>();
    private final List<String> gDependenciesID = new ArrayList<String>();
    private int gLinks = 0;

    public HybridComponentElement(ComponentDescriptor aComponentDescriptor) {
        this.gComponentDescriptor = aComponentDescriptor;
    }

    @Override
    public final void update(Observable aObservable, Object aArg) {
        this.updateCount((Boolean)aArg);
    }

    public final String getIdentifier() {
        return this.gComponentDescriptor.getIdentityIdentifier();
    }

    public final String getName() {
        return this.gComponentDescriptor.getIdentityName();
    }

    protected final String getNiceDescription() {
        return this.gComponentDescriptor.getNiceDescription();
    }

    public final String getDescription(Locale aLocale) {
        return this.gComponentDescriptor.getIdentityDescription(aLocale);
    }

    public final Map<Locale, String> getDescriptions() {
        return this.gComponentDescriptor.getIdentityDescriptions();
    }

    public final void toggle() {
        this.setSelected(!this.getSelected());
    }

    public final void setSelected(boolean aState) {
        this.gSelected = aState;
        this.setChanged();
        this.notifyObservers(this.getSelected());
    }

    public final boolean getSelected() {
        return this.gSelected;
    }

    public final void addDependentID(String aDependentID) {
        this.gDependentsID.add(aDependentID);
    }

    public final void addDependenciesID(String aIdentifier) {
        this.gDependenciesID.add(aIdentifier);
    }

    public final String[] getChildIdentifier() {
        return this.gDependenciesID.toArray(new String[0]);
    }

    public final int getChildCount() {
        if (this.gDependenciesID == null) {
            return -1;
        }
        return this.gDependenciesID.size();
    }

    protected final void updateCount(boolean aTrend) {
        if (aTrend) {
            ++this.gLinks;
        } else if (this.gLinks > 0) {
            --this.gLinks;
        }
        this.setChanged();
        this.notifyObservers(aTrend);
    }

    public final boolean getStatus() {
        return this.getSelected() || this.gLinks > 0;
    }

    public final int getCount() {
        return this.gLinks;
    }

    public final String getVersion() {
        return this.gComponentDescriptor.getBaselineVersion();
    }

    public final List<String> getFeaturesID() {
        return new ArrayList<String>(this.gComponentDescriptor.getFeaturesID());
    }

    public final List<String> getDependentsID() {
        return new ArrayList<String>(this.gDependentsID);
    }

    public final Set<String> getDependenciesID() {
        return new HashSet<String>(this.gComponentDescriptor.getRequirementsComponentIdentifiers());
    }

    public final List<String> getRequiredCapabilitiesID() {
        ArrayList<String> theResult = new ArrayList<String>();
        theResult.addAll(this.gComponentDescriptor.getRequirementsCapabilityIdentifiers());
        return theResult;
    }

    public final ComponentDescriptor getComponentDescriptor() {
        return this.gComponentDescriptor;
    }

    public final List<PreConfiguredKeyValue> getRequirementConfigureRequired() {
        return this.gComponentDescriptor.getRequirementConfigureRequired();
    }
}

